/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.jpa.entity.FederatedUserCredentialAttributeEntity;
import org.keycloak.storage.jpa.entity.FederatedUserCredentialEntity;

public class JpaFederatedUserCredentialStore
implements UserCredentialStore {
    private final KeycloakSession session;
    protected final EntityManager em;

    public JpaFederatedUserCredentialStore(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)cred.getId());
        if (entity == null) {
            return;
        }
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        if (!entity.getCredentialAttributes().isEmpty() || cred.getConfig() != null && !cred.getConfig().isEmpty()) {
            MultivaluedHashMap attrs = cred.getConfig();
            MultivaluedHashMap config = cred.getConfig();
            if (config == null) {
                config = new MultivaluedHashMap();
            }
            Iterator<FederatedUserCredentialAttributeEntity> it = entity.getCredentialAttributes().iterator();
            while (it.hasNext()) {
                FederatedUserCredentialAttributeEntity attr = it.next();
                List values = config.getList((Object)attr.getName());
                if (values == null || !values.contains(attr.getValue())) {
                    this.em.remove((Object)attr);
                    it.remove();
                    continue;
                }
                attrs.add((Object)attr.getName(), (Object)attr.getValue());
            }
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                List attrValues = attrs.getList((Object)key);
                for (String val : values) {
                    if (attrValues != null && attrValues.contains(val)) continue;
                    FederatedUserCredentialAttributeEntity attr = new FederatedUserCredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        FederatedUserCredentialEntity entity = new FederatedUserCredentialEntity();
        String id = cred.getId() == null ? KeycloakModelUtils.generateId() : cred.getId();
        entity.setId(id);
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        entity.setUserId(user.getId());
        entity.setRealmId(realm.getId());
        entity.setStorageProviderId(StorageId.resolveProviderId((UserModel)user));
        this.em.persist((Object)entity);
        MultivaluedHashMap config = cred.getConfig();
        if (config != null || !config.isEmpty()) {
            for (String key : config.keySet()) {
                List values = config.getList((Object)key);
                for (String val : values) {
                    FederatedUserCredentialAttributeEntity attr = new FederatedUserCredentialAttributeEntity();
                    attr.setId(KeycloakModelUtils.generateId());
                    attr.setValue(val);
                    attr.setName(key);
                    attr.setCredential(entity);
                    this.em.persist((Object)attr);
                    entity.getCredentialAttributes().add(attr);
                }
            }
        }
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)id);
        if (entity == null) {
            return false;
        }
        this.em.remove((Object)entity);
        return true;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        FederatedUserCredentialEntity entity = (FederatedUserCredentialEntity)this.em.find(FederatedUserCredentialEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        CredentialModel model = this.toModel(entity);
        return model;
    }

    protected CredentialModel toModel(FederatedUserCredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setType(entity.getType());
        model.setValue(entity.getValue());
        model.setAlgorithm(entity.getAlgorithm());
        model.setSalt(entity.getSalt());
        model.setPeriod(entity.getPeriod());
        model.setCounter(entity.getCounter());
        model.setCreatedDate(entity.getCreatedDate());
        model.setDevice(entity.getDevice());
        model.setDigits(entity.getDigits());
        MultivaluedHashMap config = new MultivaluedHashMap();
        model.setConfig(config);
        for (FederatedUserCredentialAttributeEntity attr : entity.getCredentialAttributes()) {
            config.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return model;
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUser", FederatedUserCredentialEntity.class).setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (FederatedUserCredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByUserAndType", FederatedUserCredentialEntity.class).setParameter("type", (Object)type).setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
        for (FederatedUserCredentialEntity entity : results) {
            rtn.add(this.toModel(entity));
        }
        return rtn;
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        TypedQuery query = this.em.createNamedQuery("federatedUserCredentialByNameAndType", FederatedUserCredentialEntity.class).setParameter("type", (Object)type).setParameter("device", (Object)name).setParameter("userId", (Object)user.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return this.toModel((FederatedUserCredentialEntity)results.get(0));
    }

    public void close() {
    }
}

