/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderCreationEventImpl;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.jpa.ClientTemplateAdapter;
import org.keycloak.models.jpa.GroupAdapter;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.AuthenticationExecutionEntity;
import org.keycloak.models.jpa.entities.AuthenticationFlowEntity;
import org.keycloak.models.jpa.entities.AuthenticatorConfigEntity;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientTemplateEntity;
import org.keycloak.models.jpa.entities.ComponentConfigEntity;
import org.keycloak.models.jpa.entities.ComponentEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.IdentityProviderEntity;
import org.keycloak.models.jpa.entities.IdentityProviderMapperEntity;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RequiredActionProviderEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.UserFederationMapperEntity;
import org.keycloak.models.jpa.entities.UserFederationProviderEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class RealmAdapter
implements RealmModel,
JpaModel<RealmEntity> {
    protected static final Logger logger = Logger.getLogger(RealmAdapter.class);
    protected RealmEntity realm;
    protected EntityManager em;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient X509Certificate certificate;
    protected volatile transient Key codeSecretKey;
    protected KeycloakSession session;
    private PasswordPolicy passwordPolicy;
    private OTPPolicy otpPolicy;
    private static final String BROWSER_HEADER_PREFIX = "_browser_header.";

    public RealmAdapter(KeycloakSession session, EntityManager em, RealmEntity realm) {
        this.session = session;
        this.em = em;
        this.realm = realm;
    }

    @Override
    public RealmEntity getEntity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public String getDisplayName() {
        return this.getAttribute("displayName");
    }

    public void setDisplayName(String displayName) {
        this.setAttribute("displayName", displayName);
    }

    public String getDisplayNameHtml() {
        return this.getAttribute("displayNameHtml");
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.setAttribute("displayNameHtml", displayNameHtml);
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public SslRequired getSslRequired() {
        return this.realm.getSslRequired() != null ? SslRequired.valueOf((String)this.realm.getSslRequired()) : null;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
        this.em.flush();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.em.flush();
    }

    public void setAttribute(String name, String value) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        RealmAttributeEntity attr = new RealmAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setRealm(this.realm);
        this.em.persist((Object)attr);
        this.realm.getAttributes().add(attr);
    }

    public void setAttribute(String name, Boolean value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Integer value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Long value) {
        this.setAttribute(name, value.toString());
    }

    public void removeAttribute(String name) {
        Iterator<RealmAttributeEntity> it = this.realm.getAttributes().iterator();
        while (it.hasNext()) {
            RealmAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Long.parseLong(v) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public boolean isBruteForceProtected() {
        return this.getAttribute("bruteForceProtected", false);
    }

    public void setBruteForceProtected(boolean value) {
        this.setAttribute("bruteForceProtected", value);
    }

    public int getMaxFailureWaitSeconds() {
        return this.getAttribute("maxFailureWaitSeconds", 0);
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.setAttribute("maxFailureWaitSeconds", val);
    }

    public int getWaitIncrementSeconds() {
        return this.getAttribute("waitIncrementSeconds", 0);
    }

    public void setWaitIncrementSeconds(int val) {
        this.setAttribute("waitIncrementSeconds", val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.getAttribute("quickLoginCheckMilliSeconds", 0L);
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.setAttribute("quickLoginCheckMilliSeconds", val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.getAttribute("minimumQuickLoginWaitSeconds", 0);
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.setAttribute("minimumQuickLoginWaitSeconds", val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.getAttribute("maxDeltaTimeSeconds", 0);
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.setAttribute("maxDeltaTimeSeconds", val);
    }

    public int getFailureFactor() {
        return this.getAttribute("failureFactor", 0);
    }

    public void setFailureFactor(int failureFactor) {
        this.setAttribute("failureFactor", failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.realm.setEditUsernameAllowed(editUsernameAllowed);
        this.em.flush();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public boolean isRevokeRefreshToken() {
        return this.realm.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.realm.setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.realm.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.realm.setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        return this.realm.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.realm.setOfflineSessionIdleTimeout(seconds);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
        this.em.flush();
    }

    public String getKeyId() {
        PublicKey publicKey = this.getPublicKey();
        return publicKey != null ? JWKBuilder.create().rs256(publicKey).getKeyId() : null;
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.em.flush();
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certificatePem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certificatePem);
    }

    public String getCertificatePem() {
        return this.realm.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.realm.setCertificatePem(certificate);
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.em.flush();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.realm.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.realm.setCodeSecret(codeSecret);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setRealm(this.realm);
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredCredentials();
        if (entities == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<RequiredCredentialModel> requiredCredentialModels = new LinkedList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return Collections.unmodifiableList(requiredCredentialModels);
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        if (entities == null || entities.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> roles = new LinkedList<String>();
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return Collections.unmodifiableList(roles);
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entities.add(roleEntity);
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (Iterator<RoleEntity> iterator : defaultRoles) {
            if (already.contains(iterator)) continue;
            this.addDefaultRole((String)((Object)iterator));
        }
        this.em.flush();
    }

    public void removeDefaultRoles(String ... defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) continue;
            remove.add(rel);
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
    }

    public List<GroupModel> getDefaultGroups() {
        Collection<GroupEntity> entities = this.realm.getDefaultGroups();
        if (entities == null || entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<GroupModel> defaultGroups = new LinkedList<GroupModel>();
        for (GroupEntity entity : entities) {
            defaultGroups.add(this.session.realms().getGroupById(entity.getId(), (RealmModel)this));
        }
        return Collections.unmodifiableList(defaultGroups);
    }

    public void addDefaultGroup(GroupModel group) {
        Collection<GroupEntity> entities = this.realm.getDefaultGroups();
        for (GroupEntity entity : entities) {
            if (!entity.getId().equals(group.getId())) continue;
            return;
        }
        GroupEntity groupEntity = GroupAdapter.toEntity(group, this.em);
        this.realm.getDefaultGroups().add(groupEntity);
        this.em.flush();
    }

    public void removeDefaultGroup(GroupModel group) {
        GroupEntity found = null;
        for (GroupEntity defaultGroup : this.realm.getDefaultGroups()) {
            if (!defaultGroup.getId().equals(group.getId())) continue;
            found = defaultGroup;
            break;
        }
        if (found != null) {
            this.realm.getDefaultGroups().remove(found);
            this.em.flush();
        }
    }

    public List<ClientModel> getClients() {
        return this.session.realms().getClients((RealmModel)this);
    }

    public ClientModel addClient(String name) {
        return this.session.realms().addClient((RealmModel)this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.session.realms().addClient((RealmModel)this, id, clientId);
    }

    public boolean removeClient(String id) {
        if (id == null) {
            return false;
        }
        ClientModel client = this.getClientById(id);
        if (client == null) {
            return false;
        }
        return this.session.realms().removeClient(id, (RealmModel)this);
    }

    public ClientModel getClientById(String id) {
        return this.session.realms().getClientById(id, (RealmModel)this);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.session.realms().getClientByClientId(clientId, (RealmModel)this);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        Map<String, String> attributes = this.getAttributes();
        if (attributes.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!entry.getKey().startsWith(BROWSER_HEADER_PREFIX)) continue;
            headers.put(entry.getKey().substring(BROWSER_HEADER_PREFIX.length()), entry.getValue());
        }
        return Collections.unmodifiableMap(headers);
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.setAttribute(BROWSER_HEADER_PREFIX + entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getSmtpConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.putAll(this.realm.getSmtpConfig());
        return Collections.unmodifiableMap(config);
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    private void removeFederationMappersForProvider(String federationProviderId) {
        Set<UserFederationMapperEntity> mappers = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity mapper : mappers) {
            this.realm.getUserFederationMappers().remove(mapper);
            this.em.remove((Object)mapper);
        }
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List<UserFederationProviderEntity> entities = this.realm.getUserFederationProviders();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<UserFederationProviderEntity> copy = new ArrayList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        ArrayList<UserFederationProviderModel> result = new ArrayList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return Collections.unmodifiableList(result);
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)displayName, null, this.getUserFederationProviders());
        String id = KeycloakModelUtils.generateId();
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(id);
        entity.setRealm(this.realm);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        entity.setPriority(priority);
        if (displayName == null) {
            displayName = id;
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.em.persist((Object)entity);
        this.realm.getUserFederationProviders().add(entity);
        this.em.flush();
        UserFederationProviderModel providerModel = new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, providerModel));
        return providerModel;
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, provider);
            this.removeFederationMappersForProvider(provider.getId());
            it.remove();
            this.em.remove((Object)entity);
            return;
        }
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)model.getDisplayName(), (UserFederationProviderModel)model, this.getUserFederationProviders());
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            entity.setProviderName(model.getProviderName());
            entity.setPriority(model.getPriority());
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            break;
        }
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        Object displayName;
        for (UserFederationProviderModel currentProvider : providers) {
            KeycloakModelUtils.ensureUniqueDisplayName((String)currentProvider.getDisplayName(), (UserFederationProviderModel)currentProvider, providers);
        }
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            boolean found = false;
            for (UserFederationProviderModel model : providers) {
                if (!entity.getId().equals(model.getId())) continue;
                entity.setConfig(model.getConfig());
                entity.setPriority(model.getPriority());
                entity.setProviderName(model.getProviderName());
                displayName = model.getDisplayName();
                if (displayName != null) {
                    entity.setDisplayName((String)displayName);
                }
                entity.setFullSyncPeriod(model.getFullSyncPeriod());
                entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
                entity.setLastSync(model.getLastSync());
                found = true;
                break;
            }
            if (found) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            this.removeFederationMappersForProvider(entity.getId());
            it.remove();
            this.em.remove((Object)entity);
        }
        LinkedList<UserFederationProviderModel> add = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderModel model : providers) {
            boolean found = false;
            for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
                if (!entity.getId().equals(model.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            add.add(model);
        }
        for (UserFederationProviderModel model : add) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                String id = KeycloakModelUtils.generateId();
                entity.setId(id);
                model.setId(id);
            }
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            entity.setProviderName(model.getProviderName());
            entity.setPriority(model.getPriority());
            displayName = model.getDisplayName();
            if (displayName == null) {
                displayName = entity.getId();
            }
            entity.setDisplayName((String)displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            entity.setRealm(this.realm);
            this.em.persist((Object)entity);
            this.realm.getUserFederationProviders().add(entity);
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, model));
        }
    }

    protected UserFederationProviderEntity getUserFederationProviderEntityById(String federationProviderId) {
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(federationProviderId)) continue;
            return entity;
        }
        return null;
    }

    public RoleModel getRole(String name) {
        return this.session.realms().getRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.realms().addRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.realms().addRealmRole((RealmModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.realms().removeRole((RealmModel)this, role);
    }

    public Set<RoleModel> getRoles() {
        return this.session.realms().getRealmRoles((RealmModel)this);
    }

    public RoleModel getRoleById(String id) {
        return this.session.realms().getRoleById(id, (RealmModel)this);
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        return role.getContainer().removeRole(role);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = PasswordPolicy.parse((KeycloakSession)this.session, (String)this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }

    public OTPPolicy getOTPPolicy() {
        if (this.otpPolicy == null) {
            this.otpPolicy = new OTPPolicy();
            this.otpPolicy.setDigits(this.realm.getOtpPolicyDigits());
            this.otpPolicy.setAlgorithm(this.realm.getOtpPolicyAlgorithm());
            this.otpPolicy.setInitialCounter(this.realm.getOtpPolicyInitialCounter());
            this.otpPolicy.setLookAheadWindow(this.realm.getOtpPolicyLookAheadWindow());
            this.otpPolicy.setType(this.realm.getOtpPolicyType());
            this.otpPolicy.setPeriod(this.realm.getOtpPolicyPeriod());
        }
        return this.otpPolicy;
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.realm.setOtpPolicyAlgorithm(policy.getAlgorithm());
        this.realm.setOtpPolicyDigits(policy.getDigits());
        this.realm.setOtpPolicyInitialCounter(policy.getInitialCounter());
        this.realm.setOtpPolicyLookAheadWindow(policy.getLookAheadWindow());
        this.realm.setOtpPolicyType(policy.getType());
        this.realm.setOtpPolicyPeriod(policy.getPeriod());
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.em.flush();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.em.flush();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.em.flush();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.em.flush();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.em.flush();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.em.flush();
    }

    public Set<String> getEventsListeners() {
        Set<String> eventsListeners = this.realm.getEventsListeners();
        if (eventsListeners.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(eventsListeners);
        return Collections.unmodifiableSet(copy);
    }

    public void setEventsListeners(Set<String> listeners) {
        this.realm.setEventsListeners(listeners);
        this.em.flush();
    }

    public Set<String> getEnabledEventTypes() {
        Set<String> enabledEventTypes = this.realm.getEnabledEventTypes();
        if (enabledEventTypes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(enabledEventTypes);
        return Collections.unmodifiableSet(copy);
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.realm.setEnabledEventTypes(enabledEventTypes);
        this.em.flush();
    }

    public boolean isAdminEventsEnabled() {
        return this.realm.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.realm.setAdminEventsEnabled(enabled);
        this.em.flush();
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.realm.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.realm.setAdminEventsDetailsEnabled(enabled);
        this.em.flush();
    }

    public ClientModel getMasterAdminClient() {
        ClientEntity masterAdminClient = this.realm.getMasterAdminClient();
        if (masterAdminClient == null) {
            return null;
        }
        RealmAdapter masterRealm = null;
        String masterAdminClientRealmId = masterAdminClient.getRealm().getId();
        masterRealm = masterAdminClientRealmId.equals(this.getId()) ? this : this.session.realms().getRealm(masterAdminClientRealmId);
        return this.session.realms().getClientById(masterAdminClient.getId(), (RealmModel)masterRealm);
    }

    public void setMasterAdminClient(ClientModel client) {
        ClientEntity appEntity = client != null ? (ClientEntity)this.em.getReference(ClientEntity.class, (Object)client.getId()) : null;
        this.realm.setMasterAdminClient(appEntity);
        this.em.flush();
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        List<IdentityProviderEntity> entities = this.realm.getIdentityProviders();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IdentityProviderModel> identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderEntity entity : entities) {
            IdentityProviderModel identityProviderModel = new IdentityProviderModel();
            identityProviderModel.setProviderId(entity.getProviderId());
            identityProviderModel.setAlias(entity.getAlias());
            identityProviderModel.setInternalId(entity.getInternalId());
            Map<String, String> config = entity.getConfig();
            HashMap<String, String> copy = new HashMap<String, String>();
            copy.putAll(config);
            identityProviderModel.setConfig(copy);
            identityProviderModel.setEnabled(entity.isEnabled());
            identityProviderModel.setTrustEmail(entity.isTrustEmail());
            identityProviderModel.setAuthenticateByDefault(entity.isAuthenticateByDefault());
            identityProviderModel.setFirstBrokerLoginFlowId(entity.getFirstBrokerLoginFlowId());
            identityProviderModel.setPostBrokerLoginFlowId(entity.getPostBrokerLoginFlowId());
            identityProviderModel.setStoreToken(entity.isStoreToken());
            identityProviderModel.setAddReadTokenRoleOnCreate(entity.isAddReadTokenRoleOnCreate());
            identityProviders.add(identityProviderModel);
        }
        return Collections.unmodifiableList(identityProviders);
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        IdentityProviderEntity entity = new IdentityProviderEntity();
        entity.setInternalId(KeycloakModelUtils.generateId());
        entity.setAlias(identityProvider.getAlias());
        entity.setProviderId(identityProvider.getProviderId());
        entity.setEnabled(identityProvider.isEnabled());
        entity.setStoreToken(identityProvider.isStoreToken());
        entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
        entity.setTrustEmail(identityProvider.isTrustEmail());
        entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
        entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
        entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
        entity.setConfig(identityProvider.getConfig());
        this.realm.addIdentityProvider(entity);
        identityProvider.setInternalId(entity.getInternalId());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void removeIdentityProviderByAlias(String alias) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getAlias().equals(alias)) continue;
            this.em.remove((Object)entity);
            this.em.flush();
        }
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getInternalId().equals(identityProvider.getInternalId())) continue;
            entity.setAlias(identityProvider.getAlias());
            entity.setEnabled(identityProvider.isEnabled());
            entity.setTrustEmail(identityProvider.isTrustEmail());
            entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
            entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
            entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
            entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
            entity.setStoreToken(identityProvider.isStoreToken());
            entity.setConfig(identityProvider.getConfig());
        }
        this.em.flush();
    }

    public boolean isIdentityFederationEnabled() {
        return !this.realm.getIdentityProviders().isEmpty();
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
        this.em.flush();
    }

    public Set<String> getSupportedLocales() {
        Set<String> supportedLocales = this.realm.getSupportedLocales();
        if (supportedLocales == null || supportedLocales.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(supportedLocales);
        return Collections.unmodifiableSet(copy);
    }

    public void setSupportedLocales(Set<String> locales) {
        this.realm.setSupportedLocales(locales);
        this.em.flush();
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
        this.em.flush();
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        Collection<IdentityProviderMapperEntity> entities = this.realm.getIdentityProviderMappers();
        if (entities.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : entities) {
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return Collections.unmodifiableSet(mappings);
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(brokerAlias)) continue;
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        if (this.getIdentityProviderMapperByName(model.getIdentityProviderAlias(), model.getIdentityProviderMapper()) != null) {
            throw new RuntimeException("identity provider mapper name must be unique per identity provider");
        }
        String id = KeycloakModelUtils.generateId();
        IdentityProviderMapperEntity entity = new IdentityProviderMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setRealm(this.realm);
        entity.setConfig(model.getConfig());
        this.em.persist((Object)entity);
        this.realm.getIdentityProviderMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntity(String id) {
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntityByName(String alias, String name) {
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(alias) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity toDelete = this.getIdentityProviderMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.realm.getIdentityProviderMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(mapping.getId());
        entity.setIdentityProviderAlias(mapping.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(mapping.getIdentityProviderMapper());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntityByName(alias, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperModel entityToModel(IdentityProviderMapperEntity entity) {
        IdentityProviderMapperModel mapping = new IdentityProviderMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        mapping.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        Collection<UserFederationMapperEntity> entities = this.realm.getUserFederationMappers();
        if (entities.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (UserFederationMapperEntity entity : entities) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return Collections.unmodifiableSet(mappers);
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        Set<UserFederationMapperEntity> mapperEntities = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        if (mapperEntities.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (UserFederationMapperEntity entity : mapperEntities) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return Collections.unmodifiableSet(mappers);
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel model) {
        if (this.getUserFederationMapperByName(model.getFederationProviderId(), model.getName()) != null) {
            throw new ModelDuplicateException("User federation mapper must be unique per federation provider. There is already: " + model.getName());
        }
        String id = KeycloakModelUtils.generateId();
        UserFederationMapperEntity entity = new UserFederationMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setFederationProvider(this.getUserFederationProviderEntityById(model.getFederationProviderId()));
        entity.setFederationMapperType(model.getFederationMapperType());
        entity.setRealm(this.realm);
        entity.setConfig(model.getConfig());
        this.em.persist((Object)entity);
        this.realm.getUserFederationMappers().add(entity);
        UserFederationMapperModel mapperModel = this.entityToModel(entity);
        return mapperModel;
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity toDelete = this.getUserFederationMapperEntity(mapper.getId());
        if (toDelete != null) {
            this.realm.getUserFederationMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    protected UserFederationMapperEntity getUserFederationMapperEntity(String id) {
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntityByName(String federationProviderId, String name) {
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProvider().getId()) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    protected Set<UserFederationMapperEntity> getUserFederationMapperEntitiesByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperEntity> mappers = new HashSet<UserFederationMapperEntity>();
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProvider().getId())) continue;
            mappers.add(entity);
        }
        return mappers;
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(mapper.getId());
        entity.setFederationProvider(this.getUserFederationProviderEntityById(mapper.getFederationProviderId()));
        entity.setFederationMapperType(mapper.getFederationMapperType());
        if (entity.getConfig() == null) {
            entity.setConfig(mapper.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapper.getConfig());
        }
        this.em.flush();
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntityByName(federationProviderId, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected UserFederationMapperModel entityToModel(UserFederationMapperEntity entity) {
        UserFederationMapperModel mapper = new UserFederationMapperModel();
        mapper.setId(entity.getId());
        mapper.setName(entity.getName());
        mapper.setFederationProviderId(entity.getFederationProvider().getId());
        mapper.setFederationMapperType(entity.getFederationMapperType());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapper.setConfig(config);
        return mapper;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        String flowId = this.realm.getBrowserFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.realm.setBrowserFlow(flow.getId());
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        String flowId = this.realm.getRegistrationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.realm.setRegistrationFlow(flow.getId());
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        String flowId = this.realm.getDirectGrantFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.realm.setDirectGrantFlow(flow.getId());
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        String flowId = this.realm.getResetCredentialsFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.realm.setResetCredentialsFlow(flow.getId());
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        String flowId = this.realm.getClientAuthenticationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.realm.setClientAuthenticationFlow(flow.getId());
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        TypedQuery query = this.em.createNamedQuery("getAuthenticationFlowsByRealm", AuthenticationFlowEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List flows = query.getResultList();
        if (flows.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticationFlowModel> models = new LinkedList<AuthenticationFlowModel>();
        for (AuthenticationFlowEntity entity : flows) {
            AuthenticationFlowModel model = this.entityToModel(entity);
            models.add(model);
        }
        return Collections.unmodifiableList(models);
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        for (AuthenticationFlowModel flow : this.getAuthenticationFlows()) {
            if (!flow.getAlias().equals(alias)) continue;
            return flow;
        }
        return null;
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        for (AuthenticatorConfigModel config : this.getAuthenticatorConfigs()) {
            if (!config.getAlias().equals(alias)) continue;
            return config;
        }
        return null;
    }

    protected AuthenticationFlowModel entityToModel(AuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setProviderId(entity.getProviderId());
        model.setDescription(entity.getDescription());
        model.setBuiltIn(entity.isBuiltIn());
        model.setTopLevel(entity.isTopLevel());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        AuthenticationFlowEntity entity = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        if (KeycloakModelUtils.isFlowUsed((RealmModel)this, (AuthenticationFlowModel)model)) {
            throw new ModelException("Cannot remove authentication flow, it is currently in use");
        }
        AuthenticationFlowEntity entity = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getId());
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = new AuthenticationFlowEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
        entity.setRealm(this.realm);
        this.realm.getAuthenticationFlows().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        model.setId(entity.getId());
        return model;
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        TypedQuery query = this.em.createNamedQuery("getAuthenticationExecutionsByFlow", AuthenticationExecutionEntity.class);
        AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.getReference(AuthenticationFlowEntity.class, (Object)flowId);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("parentFlow", (Object)flow);
        List queryResult = query.getResultList();
        if (queryResult.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionEntity entity : queryResult) {
            AuthenticationExecutionModel model = this.entityToModel(entity);
            executions.add(model);
        }
        Collections.sort(executions, AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
        return Collections.unmodifiableList(executions);
    }

    public AuthenticationExecutionModel entityToModel(AuthenticationExecutionEntity entity) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setRequirement(entity.getRequirement());
        model.setPriority(entity.getPriority());
        model.setAuthenticator(entity.getAuthenticator());
        model.setFlowId(entity.getFlowId());
        model.setParentFlow(entity.getParentFlow().getId());
        model.setAuthenticatorFlow(entity.isAutheticatorFlow());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        return model;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        AuthenticationExecutionEntity entity = (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = new AuthenticationExecutionEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setFlowId(model.getFlowId());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        AuthenticationFlowEntity flow = (AuthenticationFlowEntity)this.em.find(AuthenticationFlowEntity.class, (Object)model.getParentFlow());
        entity.setParentFlow(flow);
        flow.getExecutions().add(entity);
        entity.setRealm(this.realm);
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        this.em.persist((Object)entity);
        this.em.flush();
        model.setId(entity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        entity.setFlowId(model.getFlowId());
        this.em.flush();
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = (AuthenticationExecutionEntity)this.em.find(AuthenticationExecutionEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity auth = new AuthenticatorConfigEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setRealm(this.realm);
        auth.setConfig(model.getConfig());
        this.realm.getAuthenticatorConfigs().add(auth);
        this.em.persist((Object)auth);
        this.em.flush();
        model.setId(auth.getId());
        return model;
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        AuthenticatorConfigEntity entity = (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticatorConfigModel entityToModel(AuthenticatorConfigEntity entity) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = (AuthenticatorConfigEntity)this.em.find(AuthenticatorConfigEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.em.flush();
    }

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs() {
        Collection<AuthenticatorConfigEntity> entities = this.realm.getAuthenticatorConfigs();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticatorConfigModel> authenticators = new LinkedList<AuthenticatorConfigModel>();
        for (AuthenticatorConfigEntity entity : entities) {
            authenticators.add(this.entityToModel(entity));
        }
        return Collections.unmodifiableList(authenticators);
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity auth = new RequiredActionProviderEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setName(model.getName());
        auth.setRealm(this.realm);
        auth.setProviderId(model.getProviderId());
        auth.setConfig(model.getConfig());
        auth.setEnabled(model.isEnabled());
        auth.setDefaultAction(model.isDefaultAction());
        this.realm.getRequiredActionProviders().add(auth);
        this.em.persist((Object)auth);
        this.em.flush();
        model.setId(auth.getId());
        return model;
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        this.em.remove((Object)entity);
        this.em.flush();
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        RequiredActionProviderEntity entity = (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public RequiredActionProviderModel entityToModel(RequiredActionProviderEntity entity) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setProviderId(entity.getProviderId());
        model.setAlias(entity.getAlias());
        model.setEnabled(entity.isEnabled());
        model.setDefaultAction(entity.isDefaultAction());
        model.setName(entity.getName());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = (RequiredActionProviderEntity)this.em.find(RequiredActionProviderEntity.class, (Object)model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setProviderId(model.getProviderId());
        entity.setEnabled(model.isEnabled());
        entity.setDefaultAction(model.isDefaultAction());
        entity.setName(model.getName());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.em.flush();
    }

    public List<RequiredActionProviderModel> getRequiredActionProviders() {
        Collection<RequiredActionProviderEntity> entities = this.realm.getRequiredActionProviders();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<RequiredActionProviderModel> actions = new LinkedList<RequiredActionProviderModel>();
        for (RequiredActionProviderEntity entity : entities) {
            actions.add(this.entityToModel(entity));
        }
        return Collections.unmodifiableList(actions);
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        for (RequiredActionProviderModel action : this.getRequiredActionProviders()) {
            if (!action.getAlias().equals(alias)) continue;
            return action;
        }
        return null;
    }

    public GroupModel createGroup(String name) {
        return this.session.realms().createGroup((RealmModel)this, name);
    }

    public GroupModel createGroup(String id, String name) {
        return this.session.realms().createGroup((RealmModel)this, id, name);
    }

    public void addTopLevelGroup(GroupModel subGroup) {
        this.session.realms().addTopLevelGroup((RealmModel)this, subGroup);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.session.realms().moveGroup((RealmModel)this, group, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.session.realms().getGroupById(id, (RealmModel)this);
    }

    public List<GroupModel> getGroups() {
        return this.session.realms().getGroups((RealmModel)this);
    }

    public List<GroupModel> getTopLevelGroups() {
        return this.session.realms().getTopLevelGroups((RealmModel)this);
    }

    public boolean removeGroup(GroupModel group) {
        return this.session.realms().removeGroup((RealmModel)this, group);
    }

    public List<ClientTemplateModel> getClientTemplates() {
        Collection<ClientTemplateEntity> entities = this.realm.getClientTemplates();
        if (entities == null || entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ClientTemplateModel> list = new LinkedList<ClientTemplateModel>();
        for (ClientTemplateEntity entity : entities) {
            list.add(this.session.realms().getClientTemplateById(entity.getId(), (RealmModel)this));
        }
        return Collections.unmodifiableList(list);
    }

    public ClientTemplateModel addClientTemplate(String name) {
        return this.addClientTemplate(KeycloakModelUtils.generateId(), name);
    }

    public ClientTemplateModel addClientTemplate(String id, String name) {
        ClientTemplateEntity entity = new ClientTemplateEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealm(this.realm);
        this.realm.getClientTemplates().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        ClientTemplateAdapter resource = new ClientTemplateAdapter(this, this.em, this.session, entity);
        this.em.flush();
        return resource;
    }

    public boolean removeClientTemplate(String id) {
        if (id == null) {
            return false;
        }
        ClientTemplateModel client = this.getClientTemplateById(id);
        if (client == null) {
            return false;
        }
        if (KeycloakModelUtils.isClientTemplateUsed((RealmModel)this, (ClientTemplateModel)client)) {
            throw new ModelException("Cannot remove client template, it is currently in use");
        }
        ClientTemplateEntity clientEntity = null;
        Iterator<ClientTemplateEntity> it = this.realm.getClientTemplates().iterator();
        while (it.hasNext()) {
            ClientTemplateEntity ae = it.next();
            if (!ae.getId().equals(id)) continue;
            clientEntity = ae;
            it.remove();
            break;
        }
        if (client == null) {
            return false;
        }
        this.em.createNamedQuery("deleteTemplateScopeMappingByClient").setParameter("template", clientEntity).executeUpdate();
        this.em.flush();
        this.em.remove((Object)clientEntity);
        this.em.flush();
        return true;
    }

    public ClientTemplateModel getClientTemplateById(String id) {
        return this.session.realms().getClientTemplateById(id, (RealmModel)this);
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        ComponentEntity c = new ComponentEntity();
        if (model.getId() == null) {
            c.setId(KeycloakModelUtils.generateId());
        } else {
            c.setId(model.getId());
        }
        c.setName(model.getName());
        c.setParentId(model.getParentId());
        c.setProviderType(model.getProviderType());
        c.setProviderId(model.getProviderId());
        c.setRealm(this.realm);
        this.em.persist((Object)c);
        this.setConfig(model, c);
        model.setId(c.getId());
        return model;
    }

    protected void setConfig(ComponentModel model, ComponentEntity c) {
        for (String key : model.getConfig().keySet()) {
            List vals = (List)model.getConfig().get((Object)key);
            for (String val : vals) {
                ComponentConfigEntity config = new ComponentConfigEntity();
                config.setId(KeycloakModelUtils.generateId());
                config.setName(key);
                config.setValue(val);
                config.setComponent(c);
                this.em.persist((Object)config);
            }
        }
    }

    public void updateComponent(ComponentModel component) {
        ComponentEntity c = (ComponentEntity)this.em.find(ComponentEntity.class, (Object)component.getId());
        if (c == null) {
            return;
        }
        c.setName(component.getName());
        c.setProviderId(component.getProviderId());
        c.setProviderType(component.getProviderType());
        c.setParentId(component.getParentId());
        this.em.createNamedQuery("deleteComponentConfigByComponent").setParameter("component", (Object)c).executeUpdate();
        this.em.flush();
        this.setConfig(component, c);
    }

    public void removeComponent(ComponentModel component) {
        ComponentEntity c = (ComponentEntity)this.em.find(ComponentEntity.class, (Object)component.getId());
        if (c == null) {
            return;
        }
        this.session.users().preRemove((RealmModel)this, component);
        this.em.createNamedQuery("deleteComponentConfigByComponent").setParameter("component", (Object)c).executeUpdate();
        this.em.remove((Object)c);
    }

    public void removeComponents(String parentId) {
        TypedQuery query = this.em.createNamedQuery("getComponentIdsByParent", String.class).setParameter("realm", (Object)this.realm).setParameter("parentId", (Object)parentId);
        List results = query.getResultList();
        if (results.isEmpty()) {
            return;
        }
        for (String id : results) {
            this.session.users().preRemove((RealmModel)this, this.getComponent(id));
        }
        this.em.createNamedQuery("deleteComponentConfigByParent").setParameter("parentId", (Object)parentId).executeUpdate();
        this.em.createNamedQuery("deleteComponentByParent").setParameter("parentId", (Object)parentId).executeUpdate();
    }

    public List<ComponentModel> getComponents(String parentId, String providerType) {
        if (parentId == null) {
            parentId = this.getId();
        }
        TypedQuery query = this.em.createNamedQuery("getComponentsByParentAndType", ComponentEntity.class).setParameter("realm", (Object)this.realm).setParameter("parentId", (Object)parentId).setParameter("providerType", (Object)providerType);
        List results = query.getResultList();
        LinkedList<ComponentModel> rtn = new LinkedList<ComponentModel>();
        for (ComponentEntity c : results) {
            ComponentModel model = this.entityToModel(c);
            rtn.add(model);
        }
        return rtn;
    }

    public List<ComponentModel> getComponents(String parentId) {
        TypedQuery query = this.em.createNamedQuery("getComponentsByParent", ComponentEntity.class).setParameter("realm", (Object)this.realm).setParameter("parentId", (Object)parentId);
        List results = query.getResultList();
        LinkedList<ComponentModel> rtn = new LinkedList<ComponentModel>();
        for (ComponentEntity c : results) {
            ComponentModel model = this.entityToModel(c);
            rtn.add(model);
        }
        return rtn;
    }

    protected ComponentModel entityToModel(ComponentEntity c) {
        ComponentModel model = new ComponentModel();
        model.setId(c.getId());
        model.setName(c.getName());
        model.setProviderType(c.getProviderType());
        model.setProviderId(c.getProviderId());
        model.setParentId(c.getParentId());
        MultivaluedHashMap config = new MultivaluedHashMap();
        TypedQuery configQuery = this.em.createNamedQuery("getComponentConfig", ComponentConfigEntity.class).setParameter("component", (Object)c);
        List configResults = configQuery.getResultList();
        for (ComponentConfigEntity configEntity : configResults) {
            config.add((Object)configEntity.getName(), (Object)configEntity.getValue());
        }
        model.setConfig(config);
        return model;
    }

    public List<ComponentModel> getComponents() {
        TypedQuery query = this.em.createNamedQuery("getComponents", ComponentEntity.class).setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        LinkedList<ComponentModel> rtn = new LinkedList<ComponentModel>();
        for (ComponentEntity c : results) {
            ComponentModel model = this.entityToModel(c);
            rtn.add(model);
        }
        return rtn;
    }

    public ComponentModel getComponent(String id) {
        ComponentEntity c = (ComponentEntity)this.em.find(ComponentEntity.class, (Object)id);
        if (c == null) {
            return null;
        }
        return this.entityToModel(c);
    }
}

