/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAScopeStore
implements ScopeStore {
    private final EntityManager entityManager;

    public JPAScopeStore(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Scope create(String name, ResourceServer resourceServer) {
        ScopeEntity entity = new ScopeEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setResourceServer((ResourceServerEntity)resourceServer);
        this.entityManager.persist((Object)entity);
        return entity;
    }

    public void delete(String id) {
        Scope scope = (Scope)this.entityManager.find(ScopeEntity.class, (Object)id);
        if (scope != null) {
            this.entityManager.remove((Object)scope);
        }
    }

    public Scope findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        if (resourceServerId == null) {
            return (Scope)this.entityManager.find(ScopeEntity.class, (Object)id);
        }
        Query query = this.entityManager.createQuery("from ScopeEntity where resourceServer.id = :serverId and id = :id");
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("id", (Object)id);
        return (Scope)this.entityManager.find(ScopeEntity.class, (Object)id);
    }

    public Scope findByName(String name, String resourceServerId) {
        try {
            Query query = this.entityManager.createQuery("select s from ScopeEntity s inner join s.resourceServer rs where rs.id = :resourceServerId and name = :name");
            query.setParameter("resourceServerId", (Object)resourceServerId);
            query.setParameter("name", (Object)name);
            return (Scope)query.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<Scope> findByResourceServer(String serverId) {
        Query query = this.entityManager.createQuery("from ScopeEntity where resourceServer.id = :serverId");
        query.setParameter("serverId", (Object)serverId);
        return query.getResultList();
    }

    public List<Scope> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(ScopeEntity.class);
        Root root = querybuilder.from(ScopeEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        attributes.forEach((name, value) -> {
            if ("id".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else {
                predicates.add(builder.like(builder.lower((Expression)root.get(name)), "%" + value[0].toLowerCase() + "%"));
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        return query.getResultList();
    }
}

