/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.IdentityProviderEntity;

@Table(name="CLIENT_IDENTITY_PROV_MAPPING")
@Entity
@IdClass(value=Key.class)
public class ClientIdentityProviderMappingEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CLIENT_ID")
    private ClientEntity client;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="IDENTITY_PROVIDER_ID")
    private IdentityProviderEntity identityProvider;
    @Column(name="RETRIEVE_TOKEN")
    private boolean retrieveToken;

    public ClientEntity getClient() {
        return this.client;
    }

    public void setClient(ClientEntity client) {
        this.client = client;
    }

    public IdentityProviderEntity getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProviderEntity identityProvider) {
        this.identityProvider = identityProvider;
    }

    public void setRetrieveToken(boolean retrieveToken) {
        this.retrieveToken = retrieveToken;
    }

    public boolean isRetrieveToken() {
        return this.retrieveToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClientIdentityProviderMappingEntity)) {
            return false;
        }
        ClientIdentityProviderMappingEntity key = (ClientIdentityProviderMappingEntity)o;
        if (this.identityProvider != null ? !this.identityProvider.getAlias().equals(key.identityProvider.getAlias()) : key.identityProvider != null) {
            return false;
        }
        return !(this.client != null ? !this.client.getId().equals(key.client != null ? key.client.getId() : null) : key.client != null);
    }

    public int hashCode() {
        int result = this.client != null ? this.client.getId().hashCode() : 0;
        result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
        return result;
    }

    public static class Key
    implements Serializable {
        private ClientEntity client;
        private IdentityProviderEntity identityProvider;

        public Key() {
        }

        public Key(ClientEntity client, IdentityProviderEntity identityProvider) {
            this.client = client;
            this.identityProvider = identityProvider;
        }

        public ClientEntity getUser() {
            return this.client;
        }

        public IdentityProviderEntity getIdentityProvider() {
            return this.identityProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.identityProvider != null ? !this.identityProvider.getAlias().equals(key.identityProvider.getAlias()) : key.identityProvider != null) {
                return false;
            }
            return !(this.client != null ? !this.client.getId().equals(key.client != null ? key.client.getId() : null) : key.client != null);
        }

        public int hashCode() {
            int result = this.client != null ? this.client.getId().hashCode() : 0;
            result = 31 * result + (this.identityProvider != null ? this.identityProvider.hashCode() : 0);
            return result;
        }
    }
}

