/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import javax.persistence.EntityManager;
import org.keycloak.authorization.jpa.entities.PermissionTicketEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.jpa.JpaModel;

public class PermissionTicketAdapter
implements PermissionTicket,
JpaModel<PermissionTicketEntity> {
    private PermissionTicketEntity entity;
    private EntityManager em;
    private StoreFactory storeFactory;

    public PermissionTicketAdapter(PermissionTicketEntity entity, EntityManager em, StoreFactory storeFactory) {
        this.entity = entity;
        this.em = em;
        this.storeFactory = storeFactory;
    }

    @Override
    public PermissionTicketEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public String getOwner() {
        return this.entity.getOwner();
    }

    public String getRequester() {
        return this.entity.getRequester();
    }

    public boolean isGranted() {
        return this.entity.isGranted();
    }

    public Long getCreatedTimestamp() {
        return this.entity.getCreatedTimestamp();
    }

    public Long getGrantedTimestamp() {
        return this.entity.getGrantedTimestamp();
    }

    public void setGrantedTimestamp(Long millis) {
        this.entity.setGrantedTimestamp(millis);
    }

    public ResourceServer getResourceServer() {
        return this.storeFactory.getResourceServerStore().findById(this.entity.getResourceServer().getId());
    }

    public Resource getResource() {
        return this.storeFactory.getResourceStore().findById(this.entity.getResource().getId(), this.getResourceServer().getId());
    }

    public Scope getScope() {
        ScopeEntity scope = this.entity.getScope();
        if (scope == null) {
            return null;
        }
        return this.storeFactory.getScopeStore().findById(scope.getId(), this.getResourceServer().getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Policy)) {
            return false;
        }
        PermissionTicket that = (PermissionTicket)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static PermissionTicketEntity toEntity(EntityManager em, PermissionTicket permission) {
        if (permission instanceof PermissionTicketAdapter) {
            return ((PermissionTicketAdapter)permission).getEntity();
        }
        return (PermissionTicketEntity)em.getReference(PermissionTicketEntity.class, (Object)permission.getId());
    }
}

