/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.store.ResourceAdapter;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAResourceStore
implements ResourceStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAResourceStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Resource create(String name, ResourceServer resourceServer, String owner) {
        return this.create(null, name, resourceServer, owner);
    }

    public Resource create(String id, String name, ResourceServer resourceServer, String owner) {
        ResourceEntity entity = new ResourceEntity();
        if (id == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(id);
        }
        entity.setName(name);
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        entity.setOwner(owner);
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        return new ResourceAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void delete(String id) {
        ResourceEntity resource = (ResourceEntity)this.entityManager.getReference(ResourceEntity.class, (Object)id);
        if (resource == null) {
            return;
        }
        resource.getScopes().clear();
        this.entityManager.remove((Object)resource);
    }

    public Resource findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        ResourceEntity entity = (ResourceEntity)this.entityManager.find(ResourceEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new ResourceAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public List<Resource> findByOwner(String ownerId, String resourceServerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByOwner(ownerId, resourceServerId, list::add);
        return list;
    }

    public void findByOwner(String ownerId, String resourceServerId, Consumer<Resource> consumer) {
        String queryName = "findResourceIdByOwner";
        if (resourceServerId == null) {
            queryName = "findAnyResourceIdByOwner";
        }
        TypedQuery query = this.entityManager.createNamedQuery(queryName, ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("owner", (Object)ownerId);
        if (resourceServerId != null) {
            query.setParameter("serverId", (Object)resourceServerId);
        }
        StoreFactory storeFactory = this.provider.getStoreFactory();
        query.getResultList().stream().map(id -> new ResourceAdapter((ResourceEntity)id, this.entityManager, storeFactory)).forEach(consumer);
    }

    public List<Resource> findByUri(String uri, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByUri", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("uri", (Object)uri);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(id, resourceServerId);
            if (resource == null) continue;
            list.add(resource);
        }
        return list;
    }

    public List<Resource> findByResourceServer(String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByServerId", String.class);
        query.setParameter("serverId", (Object)resourceServerId);
        List result = query.getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(id, resourceServerId);
            if (resource == null) continue;
            list.add(resource);
        }
        return list;
    }

    public List<Resource> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(ResourceEntity.class);
        Root root = querybuilder.from(ResourceEntity.class);
        querybuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (resourceServerId != null) {
            predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        }
        attributes.forEach((name, value) -> {
            if ("id".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else if ("scope".equals(name)) {
                predicates.add(root.join("scopes").get("id").in((Object[])value));
            } else if ("ownerManagedAccess".equals(name)) {
                predicates.add(builder.equal((Expression)root.get(name), (Object)Boolean.valueOf(value[0])));
            } else if ("uri".equals(name)) {
                predicates.add(builder.lower((Expression)root.join("uris")).in(new Object[]{value[0].toLowerCase()}));
            } else if ("uri_not_null".equals(name)) {
                Expression urisSize = builder.size((Expression)root.get("uris"));
                predicates.add(builder.notEqual(urisSize, (Object)0));
            } else if ("owner".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else {
                predicates.add(builder.like(builder.lower((Expression)root.get(name)), "%" + value[0].toLowerCase() + "%"));
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        List result = query.getResultList();
        LinkedList<Resource> list = new LinkedList<Resource>();
        ResourceStore resourceStore = this.provider.getStoreFactory().getResourceStore();
        for (String id : result) {
            Resource resource = resourceStore.findById(id, resourceServerId);
            if (resource == null) continue;
            list.add(resource);
        }
        return list;
    }

    public List<Resource> findByScope(List<String> scopes, String resourceServerId) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        this.findByScope(scopes, resourceServerId, result::add);
        return result;
    }

    public void findByScope(List<String> scopes, String resourceServerId, Consumer<Resource> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByScope", ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("scopeIds", scopes);
        query.setParameter("serverId", (Object)resourceServerId);
        StoreFactory storeFactory = this.provider.getStoreFactory();
        query.getResultList().stream().map(id -> new ResourceAdapter((ResourceEntity)id, this.entityManager, storeFactory)).forEach(consumer);
    }

    public Resource findByName(String name, String resourceServerId) {
        return this.findByName(name, resourceServerId, resourceServerId);
    }

    public Resource findByName(String name, String ownerId, String resourceServerId) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByName", ResourceEntity.class);
        query.setParameter("serverId", (Object)resourceServerId);
        query.setParameter("name", (Object)name);
        query.setParameter("ownerId", (Object)ownerId);
        try {
            return new ResourceAdapter((ResourceEntity)query.getSingleResult(), this.entityManager, this.provider.getStoreFactory());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<Resource> findByType(String type, String resourceServerId) {
        LinkedList<Resource> list = new LinkedList<Resource>();
        this.findByType(type, resourceServerId, list::add);
        return list;
    }

    public void findByType(String type, String resourceServerId, Consumer<Resource> consumer) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceIdByType", ResourceEntity.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("type", (Object)type);
        query.setParameter("ownerId", (Object)resourceServerId);
        query.setParameter("serverId", (Object)resourceServerId);
        StoreFactory storeFactory = this.provider.getStoreFactory();
        query.getResultList().stream().map(entity -> new ResourceAdapter((ResourceEntity)entity, this.entityManager, storeFactory)).forEach(consumer);
    }
}

