/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client;

import java.util.LinkedList;
import java.util.UUID;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.models.ClientModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityDelegate;
import org.keycloak.models.map.common.StringKeyConvertor;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapStorage;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapStorageProviderFactory;
import org.keycloak.models.map.storage.jpa.client.JpaClientModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.client.delegate.JpaClientDelegateProvider;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;
import org.keycloak.utils.StreamsUtil;

public class JpaClientMapKeycloakTransaction
extends JpaKeycloakTransaction
implements MapKeycloakTransaction<MapClientEntity, ClientModel> {
    public JpaClientMapKeycloakTransaction(EntityManager em) {
        super(em);
    }

    public MapClientEntity create(MapClientEntity mapEntity) {
        JpaClientEntity jpaEntity = (JpaClientEntity)JpaClientMapStorageProviderFactory.CLONER.from((Object)mapEntity);
        if (mapEntity.getId() == null) {
            jpaEntity.setId(StringKeyConvertor.UUIDKey.INSTANCE.yieldNewUniqueKey().toString());
        }
        jpaEntity.setEntityVersion(JpaClientMapStorage.SUPPORTED_VERSION);
        this.em.persist((Object)jpaEntity);
        return jpaEntity;
    }

    public MapClientEntity read(String key) {
        if (key == null) {
            return null;
        }
        UUID uuid = (UUID)StringKeyConvertor.UUIDKey.INSTANCE.fromStringSafe(key);
        if (uuid == null) {
            return null;
        }
        return (MapClientEntity)this.em.find(JpaClientEntity.class, (Object)uuid);
    }

    public Stream<MapClientEntity> read(QueryParameters<ClientModel> queryParameters) {
        JpaClientModelCriteriaBuilder mcb = (JpaClientModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)new JpaClientModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(JpaClientEntity.class);
        Root root = query.from(JpaClientEntity.class);
        query.select((Selection)cb.construct(JpaClientEntity.class, new Selection[]{root.get("id"), root.get("entityVersion"), root.get("realmId"), root.get("clientId"), root.get("protocol"), root.get("enabled")}));
        if (!queryParameters.getOrderBy().isEmpty()) {
            LinkedList<Order> orderByList = new LinkedList<Order>();
            block4: for (QueryParameters.OrderBy order : queryParameters.getOrderBy()) {
                switch (order.getOrder()) {
                    case ASCENDING: {
                        orderByList.add(cb.asc((Expression)root.get(order.getModelField().getName())));
                        continue block4;
                    }
                    case DESCENDING: {
                        orderByList.add(cb.desc((Expression)root.get(order.getModelField().getName())));
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException("Unknown ordering.");
            }
            query.orderBy(orderByList);
        }
        if (mcb.getPredicateFunc() != null) {
            query.where((Expression)mcb.getPredicateFunc().apply(cb, (Root<JpaClientEntity>)root));
        }
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(query), (Integer)queryParameters.getOffset(), (Integer)queryParameters.getLimit()).getResultStream()).map(c -> new MapClientEntityDelegate(new JpaClientDelegateProvider((JpaClientEntity)c, this.em)));
    }

    public long getCount(QueryParameters<ClientModel> queryParameters) {
        JpaClientModelCriteriaBuilder mcb = (JpaClientModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)new JpaClientModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(JpaClientEntity.class);
        countQuery.select((Selection)cb.count((Expression)root));
        if (mcb.getPredicateFunc() != null) {
            countQuery.where((Expression)mcb.getPredicateFunc().apply(cb, (Root<JpaClientEntity>)root));
        }
        return (Long)this.em.createQuery(countQuery).getSingleResult();
    }

    public boolean delete(String key) {
        if (key == null) {
            return false;
        }
        UUID uuid = (UUID)StringKeyConvertor.UUIDKey.INSTANCE.fromStringSafe(key);
        if (uuid == null) {
            return false;
        }
        this.em.remove(this.em.getReference(JpaClientEntity.class, (Object)uuid));
        return true;
    }

    public long delete(QueryParameters<ClientModel> queryParameters) {
        JpaClientModelCriteriaBuilder mcb = (JpaClientModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)new JpaClientModelCriteriaBuilder());
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaDelete deleteQuery = cb.createCriteriaDelete(JpaClientEntity.class);
        Root root = deleteQuery.from(JpaClientEntity.class);
        if (mcb.getPredicateFunc() != null) {
            deleteQuery.where((Expression)mcb.getPredicateFunc().apply(cb, (Root<JpaClientEntity>)root));
        }
        return this.em.createQuery(deleteQuery).executeUpdate();
    }
}

