/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client.delegate;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityFields;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;

public class JpaClientDelegateProvider<T extends MapClientEntity>
implements DelegateProvider {
    private JpaClientEntity delegate;
    private final EntityManager em;

    public JpaClientDelegateProvider(JpaClientEntity deledate, EntityManager em) {
        this.delegate = deledate;
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JpaClientEntity getDelegate(boolean isRead, Object field, Object ... parameters) {
        if (this.delegate.isMetadataInitialized()) {
            return this.delegate;
        }
        if (isRead) {
            if (!(field instanceof MapClientEntityFields)) throw new IllegalStateException("Not a valid client field: " + field);
            switch ((MapClientEntityFields)field) {
                case ID: 
                case REALM_ID: 
                case CLIENT_ID: 
                case PROTOCOL: 
                case ENABLED: {
                    return this.delegate;
                }
                case ATTRIBUTES: {
                    CriteriaBuilder cb = this.em.getCriteriaBuilder();
                    CriteriaQuery query = cb.createQuery(JpaClientEntity.class);
                    Root root = query.from(JpaClientEntity.class);
                    root.fetch("attributes", JoinType.INNER);
                    query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(this.delegate.getId())));
                    this.delegate = (JpaClientEntity)this.em.createQuery(query).getSingleResult();
                    return this.delegate;
                }
                default: {
                    this.delegate = (JpaClientEntity)this.em.find(JpaClientEntity.class, (Object)UUID.fromString(this.delegate.getId()));
                    return this.delegate;
                }
            }
        } else {
            this.delegate = (JpaClientEntity)this.em.find(JpaClientEntity.class, (Object)UUID.fromString(this.delegate.getId()));
        }
        return this.delegate;
    }
}

