/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client.entity;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.storage.jpa.client.JpaClientMapStorage;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientAttributeEntity;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientMetadata;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;

@Entity
@Table(name="client")
@TypeDefs(value={@TypeDef(name="jsonb", typeClass=JsonbType.class)})
public class JpaClientEntity
extends MapClientEntity.AbstractClientEntity
implements Serializable,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    private UUID id;
    @Type(type="jsonb")
    @Column(columnDefinition="jsonb")
    private final JpaClientMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String clientId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private String protocol;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    private Boolean enabled;
    @OneToMany(mappedBy="client", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    private final Set<JpaClientAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaClientEntity() {
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_metadata(new JpaClientMetadata());
    }

    public JpaClientEntity(UUID id, Integer entityVersion, String realmId, String clientId, String protocol, Boolean enabled) {
        this.$$_hibernate_write_attributes(new HashSet());
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_clientId(clientId);
        this.$$_hibernate_write_protocol(protocol);
        this.$$_hibernate_write_enabled(enabled);
        this.$$_hibernate_write_metadata(null);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    private void checkEntityVersionForUpdate() {
        Integer ev = this.getEntityVersion();
        if (ev != null && ev < JpaClientMapStorage.SUPPORTED_VERSION) {
            this.setEntityVersion(JpaClientMapStorage.SUPPORTED_VERSION);
        }
    }

    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id == null ? null : UUID.fromString(id));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public String getClientId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getClientId();
        }
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setClientId(clientId);
    }

    public void setEnabled(Boolean enabled) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setEnabled(enabled);
    }

    public Boolean isEnabled() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().isEnabled();
        }
        return this.$$_hibernate_read_enabled();
    }

    public Map<String, Boolean> getClientScopes() {
        return this.$$_hibernate_read_metadata().getClientScopes();
    }

    public void setClientScope(String id, Boolean defaultScope) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setClientScope(id, defaultScope);
    }

    public void removeClientScope(String id) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().removeClientScope(id);
    }

    public MapProtocolMapperEntity getProtocolMapper(String id) {
        return this.$$_hibernate_read_metadata().getProtocolMapper(id);
    }

    public Map<String, MapProtocolMapperEntity> getProtocolMappers() {
        return this.$$_hibernate_read_metadata().getProtocolMappers();
    }

    public void removeProtocolMapper(String id) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().removeProtocolMapper(id);
    }

    public void setProtocolMapper(String id, MapProtocolMapperEntity mapping) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setProtocolMapper(id, mapping);
    }

    public void addRedirectUri(String redirectUri) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().addRedirectUri(redirectUri);
    }

    public Set<String> getRedirectUris() {
        return this.$$_hibernate_read_metadata().getRedirectUris();
    }

    public void removeRedirectUri(String redirectUri) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().removeRedirectUri(redirectUri);
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setRedirectUris(redirectUris);
    }

    public void addScopeMapping(String id) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().addScopeMapping(id);
    }

    public void removeScopeMapping(String id) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().removeScopeMapping(id);
    }

    public Collection<String> getScopeMappings() {
        return this.$$_hibernate_read_metadata().getScopeMappings();
    }

    public void addWebOrigin(String webOrigin) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().addWebOrigin(webOrigin);
    }

    public Set<String> getWebOrigins() {
        return this.$$_hibernate_read_metadata().getWebOrigins();
    }

    public void removeWebOrigin(String webOrigin) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().removeWebOrigin(webOrigin);
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setWebOrigins(webOrigins);
    }

    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.$$_hibernate_read_metadata().getAuthenticationFlowBindingOverride(binding);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.$$_hibernate_read_metadata().getAuthenticationFlowBindingOverrides();
    }

    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().removeAuthenticationFlowBindingOverride(binding);
    }

    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setAuthenticationFlowBindingOverride(binding, flowId);
    }

    public String getBaseUrl() {
        return this.$$_hibernate_read_metadata().getBaseUrl();
    }

    public void setBaseUrl(String baseUrl) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setBaseUrl(baseUrl);
    }

    public String getClientAuthenticatorType() {
        return this.$$_hibernate_read_metadata().getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setClientAuthenticatorType(clientAuthenticatorType);
    }

    public String getDescription() {
        return this.$$_hibernate_read_metadata().getDescription();
    }

    public void setDescription(String description) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setDescription(description);
    }

    public String getManagementUrl() {
        return this.$$_hibernate_read_metadata().getManagementUrl();
    }

    public void setManagementUrl(String managementUrl) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setManagementUrl(managementUrl);
    }

    public String getName() {
        return this.$$_hibernate_read_metadata().getName();
    }

    public void setName(String name) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setName(name);
    }

    public Integer getNodeReRegistrationTimeout() {
        return this.$$_hibernate_read_metadata().getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(Integer nodeReRegistrationTimeout) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setNodeReRegistrationTimeout(nodeReRegistrationTimeout);
    }

    public Integer getNotBefore() {
        return this.$$_hibernate_read_metadata().getNotBefore();
    }

    public void setNotBefore(Integer notBefore) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setNotBefore(notBefore);
    }

    public String getProtocol() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getProtocol();
        }
        return this.$$_hibernate_read_protocol();
    }

    public void setProtocol(String protocol) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setProtocol(protocol);
    }

    public String getRegistrationToken() {
        return this.$$_hibernate_read_metadata().getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setRegistrationToken(registrationToken);
    }

    public String getRootUrl() {
        return this.$$_hibernate_read_metadata().getRootUrl();
    }

    public void setRootUrl(String rootUrl) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setRootUrl(rootUrl);
    }

    public Set<String> getScope() {
        return this.$$_hibernate_read_metadata().getScope();
    }

    public void setScope(Set<String> scope) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setScope(scope);
    }

    public String getSecret() {
        return this.$$_hibernate_read_metadata().getSecret();
    }

    public void setSecret(String secret) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setSecret(secret);
    }

    public Boolean isAlwaysDisplayInConsole() {
        return this.$$_hibernate_read_metadata().isAlwaysDisplayInConsole();
    }

    public void setAlwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public Boolean isBearerOnly() {
        return this.$$_hibernate_read_metadata().isBearerOnly();
    }

    public void setBearerOnly(Boolean bearerOnly) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setBearerOnly(bearerOnly);
    }

    public Boolean isConsentRequired() {
        return this.$$_hibernate_read_metadata().isConsentRequired();
    }

    public void setConsentRequired(Boolean consentRequired) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setConsentRequired(consentRequired);
    }

    public Boolean isDirectAccessGrantsEnabled() {
        return this.$$_hibernate_read_metadata().isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public Boolean isFrontchannelLogout() {
        return this.$$_hibernate_read_metadata().isFrontchannelLogout();
    }

    public void setFrontchannelLogout(Boolean frontchannelLogout) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setFrontchannelLogout(frontchannelLogout);
    }

    public Boolean isFullScopeAllowed() {
        return this.$$_hibernate_read_metadata().isFullScopeAllowed();
    }

    public void setFullScopeAllowed(Boolean fullScopeAllowed) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setFullScopeAllowed(fullScopeAllowed);
    }

    public Boolean isImplicitFlowEnabled() {
        return this.$$_hibernate_read_metadata().isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public Boolean isPublicClient() {
        return this.$$_hibernate_read_metadata().isPublicClient();
    }

    public void setPublicClient(Boolean publicClient) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setPublicClient(publicClient);
    }

    public Boolean isServiceAccountsEnabled() {
        return this.$$_hibernate_read_metadata().isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public Boolean isStandardFlowEnabled() {
        return this.$$_hibernate_read_metadata().isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setStandardFlowEnabled(standardFlowEnabled);
    }

    public Boolean isSurrogateAuthRequired() {
        return this.$$_hibernate_read_metadata().isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(Boolean surrogateAuthRequired) {
        this.checkEntityVersionForUpdate();
        this.$$_hibernate_read_metadata().setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public void removeAttribute(String name) {
        this.checkEntityVersionForUpdate();
        Iterator iterator = this.$$_hibernate_read_attributes().iterator();
        while (iterator.hasNext()) {
            JpaClientAttributeEntity attr = (JpaClientAttributeEntity)iterator.next();
            if (!Objects.equals(attr.getName(), name)) continue;
            iterator.remove();
            attr.setClient(null);
        }
    }

    public void setAttribute(String name, List<String> values) {
        this.checkEntityVersionForUpdate();
        this.removeAttribute(name);
        for (String value : values) {
            JpaClientAttributeEntity attribute = new JpaClientAttributeEntity(this, name, value);
            this.$$_hibernate_read_attributes().add(attribute);
        }
    }

    public List<String> getAttribute(String name) {
        return this.$$_hibernate_read_attributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(JpaClientAttributeEntity::getValue).collect(Collectors.toList());
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (JpaClientAttributeEntity attribute : this.$$_hibernate_read_attributes()) {
            List values = result.getOrDefault(attribute.getName(), new LinkedList());
            values.add(attribute.getValue());
            result.put(attribute.getName(), values);
        }
        return result;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.checkEntityVersionForUpdate();
        Iterator iterator = this.$$_hibernate_read_attributes().iterator();
        while (iterator.hasNext()) {
            JpaClientAttributeEntity attr = (JpaClientAttributeEntity)iterator.next();
            iterator.remove();
            attr.setClient(null);
        }
        if (attributes != null) {
            for (Map.Entry<String, List<String>> attrEntry : attributes.entrySet()) {
                this.setAttribute(attrEntry.getKey(), attrEntry.getValue());
            }
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaClientEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaClientEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public JpaClientMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaClientMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public void $$_hibernate_write_metadata(JpaClientMetadata jpaClientMetadata) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaClientMetadata)this.$$_hibernate_getInterceptor().writeObject((Object)this, "metadata", (Object)this.metadata, (Object)jpaClientMetadata);
            return;
        }
        this.metadata = jpaClientMetadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public String $$_hibernate_read_protocol() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "protocol", (Object)this.protocol);
        }
        return this.protocol;
    }

    public void $$_hibernate_write_protocol(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.protocol = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "protocol", (Object)this.protocol, (Object)string);
            return;
        }
        this.protocol = string;
    }

    public Boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = (Boolean)this.$$_hibernate_getInterceptor().readObject((Object)this, "enabled", (Object)this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(Boolean bl) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = (Boolean)this.$$_hibernate_getInterceptor().writeObject((Object)this, "enabled", (Object)this.enabled, (Object)bl);
            return;
        }
        this.enabled = bl;
    }

    public Set $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)set);
            return;
        }
        this.attributes = set;
    }
}

