/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;

public class MapKeycloakTransaction<K, V>
implements KeycloakTransaction {
    private static final Logger log = Logger.getLogger(MapKeycloakTransaction.class);
    private boolean active;
    private boolean rollback;
    private final Map<K, MapTaskWithValue<K, V>> tasks = new LinkedHashMap<K, MapTaskWithValue<K, V>>();
    private final MapStorage<K, V> map;

    public MapKeycloakTransaction(MapStorage<K, V> map) {
        this.map = map;
    }

    public void begin() {
        this.active = true;
    }

    public void commit() {
        if (this.rollback) {
            throw new RuntimeException("Rollback only!");
        }
        for (MapTaskWithValue<K, V> value : this.tasks.values()) {
            value.execute(this.map);
        }
    }

    public void rollback() {
        this.tasks.clear();
    }

    public void setRollbackOnly() {
        this.rollback = true;
    }

    public boolean getRollbackOnly() {
        return this.rollback;
    }

    public boolean isActive() {
        return this.active;
    }

    private void addTask(MapOperation op, K key, V value) {
        log.tracev("Adding operation {0} for {1}", (Object)op, key);
        K taskKey = key;
        this.tasks.merge(taskKey, op.taskFor(key, value), MapTaskCompose::new);
    }

    public V get(K key, Function<K, V> defaultValueFunc) {
        MapTaskWithValue<K, V> current = this.tasks.get(key);
        if (current != null) {
            return current.getValue();
        }
        return defaultValueFunc.apply(key);
    }

    public V getUpdated(Map.Entry<K, V> keyDefaultValue) {
        MapTaskWithValue<K, V> current = this.tasks.get(keyDefaultValue.getKey());
        if (current != null) {
            return current.getValue();
        }
        return keyDefaultValue.getValue();
    }

    public void put(K key, V value) {
        this.addTask(MapOperation.PUT, key, value);
    }

    public void putIfAbsent(K key, V value) {
        this.addTask(MapOperation.PUT_IF_ABSENT, key, value);
    }

    public void putIfChanged(final K key, V value, final Predicate<V> shouldPut) {
        log.tracev("Adding operation PUT_IF_CHANGED for {0}", key);
        K taskKey = key;
        MapTaskWithValue op = new MapTaskWithValue<K, V>(value){

            @Override
            public void execute(MapStorage<K, V> map) {
                if (shouldPut.test(this.getValue())) {
                    map.put(key, this.getValue());
                }
            }
        };
        this.tasks.merge(taskKey, op, MapTaskCompose::new);
    }

    public void replace(K key, V value) {
        this.addTask(MapOperation.REPLACE, key, value);
    }

    public void remove(K key) {
        this.addTask(MapOperation.REMOVE, key, null);
    }

    public Stream<V> valuesStream() {
        return this.tasks.values().stream().map(MapTaskWithValue::getValue).filter(Objects::nonNull);
    }

    public Stream<V> createdValuesStream(Collection<K> existingKeys) {
        return this.tasks.entrySet().stream().filter(me -> !existingKeys.contains(me.getKey())).map(Map.Entry::getValue).map(MapTaskWithValue::getValue).filter(Objects::nonNull);
    }

    private static class MapTaskCompose<K, V>
    extends MapTaskWithValue<K, V> {
        private final MapTaskWithValue<K, V> oldValue;
        private final MapTaskWithValue<K, V> newValue;

        public MapTaskCompose(MapTaskWithValue<K, V> oldValue, MapTaskWithValue<K, V> newValue) {
            super(null);
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void execute(MapStorage<K, V> map) {
            this.oldValue.execute(map);
            this.newValue.execute(map);
        }

        @Override
        public V getValue() {
            return this.newValue.getValue();
        }
    }

    private static abstract class MapTaskWithValue<K, V> {
        protected final V value;

        public MapTaskWithValue(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public abstract void execute(MapStorage<K, V> var1);
    }

    private static enum MapOperation {
        PUT{

            @Override
            protected <K, V> MapTaskWithValue<K, V> taskFor(final K key, V value) {
                return new MapTaskWithValue<K, V>(value){

                    @Override
                    public void execute(MapStorage<K, V> map) {
                        map.put(key, this.getValue());
                    }
                };
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            protected <K, V> MapTaskWithValue<K, V> taskFor(final K key, V value) {
                return new MapTaskWithValue<K, V>(value){

                    @Override
                    public void execute(MapStorage<K, V> map) {
                        map.putIfAbsent(key, this.getValue());
                    }
                };
            }
        }
        ,
        REMOVE{

            @Override
            protected <K, V> MapTaskWithValue<K, V> taskFor(final K key, V value) {
                return new MapTaskWithValue<K, V>(null){

                    @Override
                    public void execute(MapStorage<K, V> map) {
                        map.remove(key);
                    }
                };
            }
        }
        ,
        REPLACE{

            @Override
            protected <K, V> MapTaskWithValue<K, V> taskFor(final K key, V value) {
                return new MapTaskWithValue<K, V>(value){

                    @Override
                    public void execute(MapStorage<K, V> map) {
                        map.replace(key, this.getValue());
                    }
                };
            }
        };


        protected abstract <K, V> MapTaskWithValue<K, V> taskFor(K var1, V var2);
    }
}

