/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.adapter;

import org.keycloak.authorization.UserManagedPermissionUtil;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.map.authorization.adapter.AbstractPermissionTicketModel;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;

public abstract class MapPermissionTicketAdapter<K extends Comparable<K>>
extends AbstractPermissionTicketModel<MapPermissionTicketEntity<K>> {
    public MapPermissionTicketAdapter(MapPermissionTicketEntity<K> entity, StoreFactory storeFactory) {
        super(entity, storeFactory);
    }

    public String getOwner() {
        return ((MapPermissionTicketEntity)this.entity).getOwner();
    }

    public String getRequester() {
        return ((MapPermissionTicketEntity)this.entity).getRequester();
    }

    public Resource getResource() {
        return this.storeFactory.getResourceStore().findById(((MapPermissionTicketEntity)this.entity).getResourceId(), ((MapPermissionTicketEntity)this.entity).getResourceServerId());
    }

    public Scope getScope() {
        if (((MapPermissionTicketEntity)this.entity).getScopeId() == null) {
            return null;
        }
        return this.storeFactory.getScopeStore().findById(((MapPermissionTicketEntity)this.entity).getScopeId(), ((MapPermissionTicketEntity)this.entity).getResourceServerId());
    }

    public boolean isGranted() {
        return ((MapPermissionTicketEntity)this.entity).getGrantedTimestamp() != null;
    }

    public Long getCreatedTimestamp() {
        return ((MapPermissionTicketEntity)this.entity).getCreatedTimestamp();
    }

    public Long getGrantedTimestamp() {
        return ((MapPermissionTicketEntity)this.entity).getGrantedTimestamp();
    }

    public void setGrantedTimestamp(Long millis) {
        ((MapPermissionTicketEntity)this.entity).setGrantedTimestamp(millis);
        UserManagedPermissionUtil.updatePolicy((PermissionTicket)this, (StoreFactory)this.storeFactory);
    }

    public ResourceServer getResourceServer() {
        return this.storeFactory.getResourceServerStore().findById(((MapPermissionTicketEntity)this.entity).getResourceServerId());
    }

    public Policy getPolicy() {
        if (((MapPermissionTicketEntity)this.entity).getPolicyId() == null) {
            return null;
        }
        return this.storeFactory.getPolicyStore().findById(((MapPermissionTicketEntity)this.entity).getPolicyId(), ((MapPermissionTicketEntity)this.entity).getResourceServerId());
    }

    public void setPolicy(Policy policy) {
        if (policy != null) {
            ((MapPermissionTicketEntity)this.entity).setPolicyId(policy.getId());
        }
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

