/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.adapter;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.map.authorization.adapter.AbstractPolicyModel;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public abstract class MapPolicyAdapter<K>
extends AbstractPolicyModel<MapPolicyEntity<K>> {
    public MapPolicyAdapter(MapPolicyEntity<K> entity, StoreFactory storeFactory) {
        super(entity, storeFactory);
    }

    public String getType() {
        return ((MapPolicyEntity)this.entity).getType();
    }

    public DecisionStrategy getDecisionStrategy() {
        return ((MapPolicyEntity)this.entity).getDecisionStrategy();
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setDecisionStrategy(decisionStrategy);
    }

    public Logic getLogic() {
        return ((MapPolicyEntity)this.entity).getLogic();
    }

    public void setLogic(Logic logic) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setLogic(logic);
    }

    public Map<String, String> getConfig() {
        return ((MapPolicyEntity)this.entity).getConfig();
    }

    public void setConfig(Map<String, String> config) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setConfig(config);
    }

    public void removeConfig(String name) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeConfig(name);
    }

    public void putConfig(String name, String value) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).putConfig(name, value);
    }

    public String getName() {
        return ((MapPolicyEntity)this.entity).getName();
    }

    public void setName(String name) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setName(name);
    }

    public String getDescription() {
        return ((MapPolicyEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setDescription(description);
    }

    public ResourceServer getResourceServer() {
        return this.storeFactory.getResourceServerStore().findById(((MapPolicyEntity)this.entity).getResourceServerId());
    }

    public Set<Policy> getAssociatedPolicies() {
        String resourceServerId = ((MapPolicyEntity)this.entity).getResourceServerId();
        return ((MapPolicyEntity)this.entity).getAssociatedPoliciesIds().stream().map(policyId -> this.storeFactory.getPolicyStore().findById(policyId, resourceServerId)).collect(Collectors.toSet());
    }

    public Set<Resource> getResources() {
        String resourceServerId = ((MapPolicyEntity)this.entity).getResourceServerId();
        return ((MapPolicyEntity)this.entity).getResourceIds().stream().map(resourceId -> this.storeFactory.getResourceStore().findById(resourceId, resourceServerId)).collect(Collectors.toSet());
    }

    public Set<Scope> getScopes() {
        String resourceServerId = ((MapPolicyEntity)this.entity).getResourceServerId();
        return ((MapPolicyEntity)this.entity).getScopeIds().stream().map(scopeId -> this.storeFactory.getScopeStore().findById(scopeId, resourceServerId)).collect(Collectors.toSet());
    }

    public String getOwner() {
        return ((MapPolicyEntity)this.entity).getOwner();
    }

    public void setOwner(String owner) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).setOwner(owner);
    }

    public void addScope(Scope scope) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).addScope(scope.getId());
    }

    public void removeScope(Scope scope) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeScope(scope.getId());
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).addAssociatedPolicy(associatedPolicy.getId());
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeAssociatedPolicy(associatedPolicy.getId());
    }

    public void addResource(Resource resource) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).addResource(resource.getId());
    }

    public void removeResource(Resource resource) {
        this.throwExceptionIfReadonly();
        ((MapPolicyEntity)this.entity).removeResource(resource.getId());
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode((Object)this));
    }
}

