/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MapAuthenticatorConfigEntity
implements UpdatableEntity {
    private String id;
    private String alias;
    private Map<String, String> config = new HashMap<String, String>();
    private boolean updated;

    private MapAuthenticatorConfigEntity() {
    }

    public static MapAuthenticatorConfigEntity fromModel(AuthenticatorConfigModel model) {
        if (model == null) {
            return null;
        }
        MapAuthenticatorConfigEntity entity = new MapAuthenticatorConfigEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setConfig(model.getConfig() == null ? null : new HashMap(model.getConfig()));
        return entity;
    }

    public static AuthenticatorConfigModel toModel(MapAuthenticatorConfigEntity entity) {
        if (entity == null) {
            return null;
        }
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setConfig((Map)(entity.getConfig() == null ? null : new HashMap<String, String>(entity.getConfig())));
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.updated = !Objects.equals(this.id, id);
        this.id = id;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.updated = !Objects.equals(this.alias, alias);
        this.alias = alias;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.updated = !Objects.equals(this.config, config);
        this.config = config;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapAuthenticatorConfigEntity)) {
            return false;
        }
        MapAuthenticatorConfigEntity other = (MapAuthenticatorConfigEntity)obj;
        return Objects.equals(other.getId(), this.getId());
    }
}

