/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.serverinfo;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.RandomString;
import org.keycloak.migration.MigrationModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ServerInfoProvider;
import org.keycloak.models.ServerInfoProviderFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class MapServerInfoProviderFactory
implements ServerInfoProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "map";
    private static final String RESOURCES_VERSION_SEED = "resourcesVersionSeed";
    private static final ServerInfoProvider INSTANCE = new ServerInfoProvider(){
        private final MigrationModel INSTANCE = new MigrationModel(){

            public String getStoredVersion() {
                return null;
            }

            public String getResourcesTag() {
                throw new UnsupportedOperationException("Not supported.");
            }

            public void setStoredVersion(String version) {
                throw new UnsupportedOperationException("Not supported.");
            }
        };

        public MigrationModel getMigrationModel() {
            return this.INSTANCE;
        }

        public void close() {
        }
    };

    public ServerInfoProvider create(KeycloakSession session) {
        return INSTANCE;
    }

    public void init(Config.Scope config) {
        String seed = config.get(RESOURCES_VERSION_SEED);
        if (seed == null) {
            Logger.getLogger(ServerInfoProviderFactory.class).warnf("It is recommended to set '%s' property in the %s provider config of serverInfo SPI", (Object)RESOURCES_VERSION_SEED, (Object)PROVIDER_ID);
            seed = RandomString.randomCode((int)10);
        }
        try {
            Version.RESOURCES_VERSION = Base64Url.encode((byte[])MessageDigest.getInstance("MD5").digest((seed + new ModelVersion(Version.VERSION_KEYCLOAK).toString()).getBytes())).substring(0, 5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void close() {
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

