/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.user.MapUserAdapter;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.UserConsentEntity;
import org.keycloak.models.map.user.UserCredentialEntity;
import org.keycloak.models.map.user.UserFederatedIdentityEntity;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.utils.StreamsUtil;

public class MapUserProvider<K>
implements UserProvider.Streams,
UserCredentialStore.Streams {
    private static final Logger LOG = Logger.getLogger(MapUserProvider.class);
    private final KeycloakSession session;
    final MapKeycloakTransaction<K, MapUserEntity<K>, UserModel> tx;
    private final MapStorage<K, MapUserEntity<K>, UserModel> userStore;

    public MapUserProvider(KeycloakSession session, MapStorage<K, MapUserEntity<K>, UserModel> store) {
        this.session = session;
        this.userStore = store;
        this.tx = this.userStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Function<MapUserEntity<K>, UserModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapUserAdapter<K>(this.session, realm, MapStorageUtils.registerEntityForChanges(this.tx, origEntity)){

            public String getId() {
                return MapUserProvider.this.userStore.getKeyConvertor().keyToString(((MapUserEntity)this.entity).getId());
            }

            @Override
            public boolean checkEmailUniqueness(RealmModel realm, String email) {
                return MapUserProvider.this.getUserByEmail(realm, email) != null;
            }

            @Override
            public boolean checkUsernameUniqueness(RealmModel realm, String username) {
                return MapUserProvider.this.getUserByUsername(realm, username) != null;
            }
        };
    }

    private Predicate<MapUserEntity<K>> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return c -> false;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    private ModelException userDoesntExistException() {
        return new ModelException("Specified user doesn't exist.");
    }

    private Optional<MapUserEntity<K>> getEntityById(RealmModel realm, String id) {
        try {
            return this.getEntityById(realm, this.userStore.getKeyConvertor().fromString(id));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private MapUserEntity<K> getRegisteredEntityByIdOrThrow(RealmModel realm, String id) {
        return this.getEntityById(realm, (K)id).map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).orElseThrow(this::userDoesntExistException);
    }

    private Optional<MapUserEntity<K>> getEntityById(RealmModel realm, K id) {
        MapUserEntity<K> mapUserEntity = this.tx.read(id);
        if (mapUserEntity != null && this.entityRealmFilter(realm).test(mapUserEntity)) {
            return Optional.of(mapUserEntity);
        }
        return Optional.empty();
    }

    private Optional<MapUserEntity<K>> getRegisteredEntityById(RealmModel realm, String id) {
        return this.getEntityById(realm, (K)id).map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e));
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        if (user == null || user.getId() == null) {
            return;
        }
        LOG.tracef("addFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialLink.getIdentityProvider(), StackUtil.getShortStackTrace()});
        this.getRegisteredEntityById(realm, user.getId()).ifPresent(userEntity -> userEntity.addFederatedIdentity(UserFederatedIdentityEntity.fromModel(socialLink)));
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        LOG.tracef("removeFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialProvider, StackUtil.getShortStackTrace()});
        return this.getRegisteredEntityById(realm, user.getId()).map(entity -> entity.removeFederatedIdentity(socialProvider)).orElse(false);
    }

    public void preRemove(RealmModel realm, IdentityProviderModel provider) {
        String socialProvider = provider.getAlias();
        LOG.tracef("preRemove[RealmModel realm, IdentityProviderModel provider](%s, %s)%s", (Object)realm, (Object)socialProvider, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, socialProvider);
        this.tx.getUpdatedNotRemoved(mcb).map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(userEntity -> userEntity.removeFederatedIdentity(socialProvider));
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        LOG.tracef("updateFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, federatedUser.getId(), federatedIdentityModel.getIdentityProvider(), StackUtil.getShortStackTrace()});
        this.getRegisteredEntityById(realm, federatedUser.getId()).ifPresent(entity -> entity.updateFederatedIdentity(UserFederatedIdentityEntity.fromModel(federatedIdentityModel)));
    }

    public Stream<FederatedIdentityModel> getFederatedIdentitiesStream(RealmModel realm, UserModel user) {
        LOG.tracef("getFederatedIdentitiesStream(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, (K)user.getId()).map(MapUserEntity::getFederatedIdentities).orElseGet(Stream::empty).map(UserFederatedIdentityEntity::toModel);
    }

    public FederatedIdentityModel getFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        LOG.tracef("getFederatedIdentity(%s, %s, %s)%s", new Object[]{realm, user.getId(), socialProvider, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, (K)user.getId()).map(userEntity -> userEntity.getFederatedIdentity(socialProvider)).map(UserFederatedIdentityEntity::toModel).orElse(null);
    }

    public UserModel getUserByFederatedIdentity(RealmModel realm, FederatedIdentityModel socialLink) {
        LOG.tracef("getUserByFederatedIdentity(%s, %s)%s", (Object)realm, (Object)socialLink, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, socialLink.getIdentityProvider(), socialLink.getUserId());
        return this.tx.getUpdatedNotRemoved(mcb).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("More results found for identityProvider=" + socialLink.getIdentityProvider() + ", userId=" + socialLink.getUserId() + ", results=" + list);
            }
            return this.entityToAdapterFunc(realm).apply((MapUserEntity<K>)list.get(0));
        }));
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        LOG.tracef("addConsent(%s, %s, %s)%s", new Object[]{realm, userId, consent, StackUtil.getShortStackTrace()});
        this.getRegisteredEntityByIdOrThrow(realm, userId).addUserConsent(UserConsentEntity.fromModel(consent));
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        LOG.tracef("getConsentByClient(%s, %s, %s)%s", new Object[]{realm, userId, clientInternalId, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, (K)userId).map(userEntity -> userEntity.getUserConsent(clientInternalId)).map(consent -> UserConsentEntity.toModel(realm, consent)).orElse(null);
    }

    public Stream<UserConsentModel> getConsentsStream(RealmModel realm, String userId) {
        LOG.tracef("getConsentByClientStream(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        return this.getEntityById(realm, (K)userId).map(MapUserEntity::getUserConsents).orElse(Stream.empty()).map(consent -> UserConsentEntity.toModel(realm, consent));
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        LOG.tracef("updateConsent(%s, %s, %s)%s", new Object[]{realm, userId, consent, StackUtil.getShortStackTrace()});
        MapUserEntity<K> user = this.getRegisteredEntityByIdOrThrow(realm, userId);
        UserConsentEntity userConsentEntity = user.getUserConsent(consent.getClient().getId());
        if (userConsentEntity == null) {
            throw new ModelException("Consent not found for client [" + consent.getClient().getId() + "] and user [" + userId + "]");
        }
        userConsentEntity.setGrantedClientScopesIds(consent.getGrantedClientScopes().stream().map(ClientScopeModel::getId).collect(Collectors.toSet()));
        userConsentEntity.setLastUpdatedDate(Time.currentTimeMillis());
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        LOG.tracef("revokeConsentForClient(%s, %s, %s)%s", new Object[]{realm, userId, clientInternalId, StackUtil.getShortStackTrace()});
        return this.getRegisteredEntityById(realm, userId).map(userEntity -> userEntity.removeUserConsent(clientInternalId)).orElse(false);
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        LOG.tracef("setNotBeforeForUser(%s, %s, %d)%s", new Object[]{realm, user.getId(), notBefore, StackUtil.getShortStackTrace()});
        this.getRegisteredEntityByIdOrThrow(realm, user.getId()).setNotBefore(notBefore);
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        LOG.tracef("getNotBeforeOfUser(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, (K)user.getId()).orElseThrow(this::userDoesntExistException).getNotBefore();
    }

    public UserModel getServiceAccount(ClientModel client) {
        LOG.tracef("getServiceAccount(%s)%s", (Object)client.getId(), StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, client.getRealm().getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.EQ, client.getId());
        return this.tx.getUpdatedNotRemoved(mcb).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.isEmpty()) {
                return null;
            }
            if (list.size() != 1) {
                throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + list);
            }
            return this.entityToAdapterFunc(client.getRealm()).apply((MapUserEntity<K>)list.get(0));
        }));
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        K entityId;
        LOG.tracef("addUser(%s, %s, %s, %s, %s)%s", new Object[]{realm, id, username, addDefaultRoles, addDefaultRequiredActions, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.EQ, username);
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("User with username '" + username + "' in realm " + realm.getName() + " already exists");
        }
        K k = entityId = id == null ? this.userStore.getKeyConvertor().yieldNewUniqueKey() : this.userStore.getKeyConvertor().fromString(id);
        if (this.tx.read(entityId) != null) {
            throw new ModelDuplicateException("User exists: " + entityId);
        }
        MapUserEntity<K> entity = new MapUserEntity<K>(entityId, realm.getId());
        entity.setUsername(username.toLowerCase());
        entity.setCreatedTimestamp(Time.currentTimeMillis());
        this.tx.create(entityId, entity);
        UserModel userModel = this.entityToAdapterFunc(realm).apply(entity);
        if (addDefaultRoles) {
            userModel.grantRole(realm.getDefaultRole());
            realm.getDefaultGroupsStream().forEach(arg_0 -> ((UserModel)userModel).joinGroup(arg_0));
        }
        if (addDefaultRequiredActions) {
            realm.getRequiredActionProvidersStream().filter(RequiredActionProviderModel::isEnabled).filter(RequiredActionProviderModel::isDefaultAction).map(RequiredActionProviderModel::getAlias).forEach(arg_0 -> ((UserModel)userModel).addRequiredAction(arg_0));
        }
        return userModel;
    }

    public void preRemove(RealmModel realm) {
        LOG.tracef("preRemove[RealmModel](%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        this.tx.delete(this.userStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        LOG.tracef("removeImportedUsers(%s, %s)%s", (Object)realm, (Object)storageProviderId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.FEDERATION_LINK, ModelCriteriaBuilder.Operator.EQ, storageProviderId);
        this.tx.delete(this.userStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        LOG.tracef("unlinkUsers(%s, %s)%s", (Object)realm, (Object)storageProviderId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.FEDERATION_LINK, ModelCriteriaBuilder.Operator.EQ, storageProviderId);
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            s.map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(userEntity -> userEntity.setFederationLink(null));
        }
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        String roleId = role.getId();
        LOG.tracef("preRemove[RoleModel](%s, %s)%s", (Object)realm, (Object)roleId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, roleId);
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            s.map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(userEntity -> userEntity.removeRolesMembership(roleId));
        }
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        String groupId = group.getId();
        LOG.tracef("preRemove[GroupModel](%s, %s)%s", (Object)realm, (Object)groupId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ASSIGNED_GROUP, ModelCriteriaBuilder.Operator.EQ, groupId);
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            s.map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(userEntity -> userEntity.removeGroupsMembership(groupId));
        }
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        String clientId = client.getId();
        LOG.tracef("preRemove[ClientModel](%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.CONSENT_FOR_CLIENT, ModelCriteriaBuilder.Operator.EQ, clientId);
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            s.map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(userEntity -> userEntity.removeUserConsent(clientId));
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(ClientScopeModel clientScope) {
        String clientScopeId = clientScope.getId();
        LOG.tracef("preRemove[ClientScopeModel](%s)%s", (Object)clientScopeId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, clientScope.getRealm().getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.CONSENT_WITH_CLIENT_SCOPE, ModelCriteriaBuilder.Operator.EQ, clientScopeId);
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            s.flatMap(MapUserEntity::getUserConsents).forEach(consent -> consent.removeGrantedClientScopesIds(clientScopeId));
        }
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        String componentId = component.getId();
        LOG.tracef("preRemove[ComponentModel](%s, %s)%s", (Object)realm, (Object)componentId, StackUtil.getShortStackTrace());
        if (component.getProviderType().equals(UserStorageProvider.class.getName())) {
            this.removeImportedUsers(realm, componentId);
        }
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.CONSENT_CLIENT_FEDERATION_LINK, ModelCriteriaBuilder.Operator.EQ, componentId);
            try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
                String providerIdS = new StorageId(componentId, "").getId();
                s.forEach(this.removeConsentsForExternalClient(providerIdS));
            }
        }
    }

    private Consumer<MapUserEntity<K>> removeConsentsForExternalClient(String idPrefix) {
        return userEntity -> {
            List<String> consentClientIds = userEntity.getUserConsents().map(UserConsentEntity::getClientId).filter(clientId -> clientId != null && clientId.startsWith(idPrefix)).collect(Collectors.toList());
            if (!consentClientIds.isEmpty()) {
                userEntity = MapStorageUtils.registerEntityForChanges(this.tx, userEntity);
                consentClientIds.forEach(userEntity::removeUserConsent);
            }
        };
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        String roleId = role.getId();
        LOG.tracef("grantToAllUsers(%s, %s)%s", (Object)realm, (Object)roleId, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            s.map(e -> MapStorageUtils.registerEntityForChanges(this.tx, e)).forEach(entity -> entity.addRolesMembership(roleId));
        }
    }

    public UserModel getUserById(RealmModel realm, String id) {
        LOG.tracef("getUserById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        return this.getEntityById(realm, (K)id).map(this.entityToAdapterFunc(realm)).orElse(null);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        if (username == null) {
            return null;
        }
        LOG.tracef("getUserByUsername(%s, %s)%s", (Object)realm, (Object)username, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.ILIKE, username);
        try (Stream<MapUserEntity<K>> s = this.tx.getUpdatedNotRemoved(mcb);){
            UserModel userModel = s.findFirst().map(this.entityToAdapterFunc(realm)).orElse(null);
            return userModel;
        }
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        LOG.tracef("getUserByEmail(%s, %s)%s", (Object)realm, (Object)email, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.EMAIL, ModelCriteriaBuilder.Operator.EQ, email);
        List usersWithEmail = this.tx.getUpdatedNotRemoved(mcb).filter(userEntity -> Objects.equals(userEntity.getEmail(), email)).collect(Collectors.toList());
        if (usersWithEmail.isEmpty()) {
            return null;
        }
        if (usersWithEmail.size() > 1) {
            throw new ModelDuplicateException("Multiple users with email '" + email + "' exist in Keycloak.");
        }
        final MapUserEntity userEntity2 = (MapUserEntity)MapStorageUtils.registerEntityForChanges(this.tx, (AbstractEntity)usersWithEmail.get(0));
        if (!realm.isDuplicateEmailsAllowed() && userEntity2.getEmail() != null && !userEntity2.getEmail().equals(userEntity2.getEmailConstraint())) {
            userEntity2.setEmailConstraint(userEntity2.getEmail());
        }
        return new MapUserAdapter<K>(this.session, realm, userEntity2){

            public String getId() {
                return MapUserProvider.this.userStore.getKeyConvertor().keyToString(userEntity2.getId());
            }

            @Override
            public boolean checkEmailUniqueness(RealmModel realm, String email) {
                return MapUserProvider.this.getUserByEmail(realm, email) != null;
            }

            @Override
            public boolean checkUsernameUniqueness(RealmModel realm, String username) {
                return MapUserProvider.this.getUserByUsername(realm, username) != null;
            }
        };
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        LOG.tracef("getUsersCount(%s, %s)%s", (Object)realm, (Object)includeServiceAccount, StackUtil.getShortStackTrace());
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        if (!includeServiceAccount) {
            mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return (int)this.tx.getCount(mcb);
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults, boolean includeServiceAccounts) {
        LOG.tracef("getUsersStream(%s, %d, %d, %s)%s", new Object[]{realm, firstResult, maxResults, includeServiceAccounts, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        if (!includeServiceAccounts) {
            mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return StreamsUtil.paginatedStream(this.tx.getUpdatedNotRemoved(mcb).sorted(MapUserEntity.COMPARE_BY_USERNAME), (Integer)firstResult, (Integer)maxResults).map(this.entityToAdapterFunc(realm));
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        LOG.tracef("getUsersStream(%s, %d, %d)%s", new Object[]{realm, firstResult, maxResults, StackUtil.getShortStackTrace()});
        return this.getUsersStream(realm, firstResult, maxResults, false);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForUserStream(%s, %s, %d, %d)%s", new Object[]{realm, search, firstResult, maxResults, StackUtil.getShortStackTrace()});
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("keycloak.session.realm.users.query.search", search);
        this.session.setAttribute("keycloak.session.realm.users.query.include_service_account", (Object)false);
        return this.searchForUserStream(realm, attributes, firstResult, maxResults);
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForUserStream(%s, %s, %d, %d)%s", new Object[]{realm, attributes, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        if (!((Boolean)this.session.getAttributeOrDefault("keycloak.session.realm.users.query.include_service_account", (Object)true)).booleanValue()) {
            mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        boolean exactSearch = Boolean.parseBoolean(attributes.getOrDefault("keycloak.session.realm.users.query.exact", Boolean.FALSE.toString()));
        block22: for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            value = value.trim();
            String searchedString = exactSearch ? value : "%" + value + "%";
            switch (key) {
                case "keycloak.session.realm.users.query.search": {
                    for (String stringToSearch : value.trim().split("\\s+")) {
                        if (value.isEmpty()) continue;
                        String s = exactSearch ? stringToSearch : "%" + stringToSearch + "%";
                        mcb = mcb.or(this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.ILIKE, s), this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.EMAIL, ModelCriteriaBuilder.Operator.ILIKE, s), this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.FIRST_NAME, ModelCriteriaBuilder.Operator.ILIKE, s), this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.LAST_NAME, ModelCriteriaBuilder.Operator.ILIKE, s));
                    }
                    continue block22;
                }
                case "username": {
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.USERNAME, ModelCriteriaBuilder.Operator.ILIKE, searchedString);
                    break;
                }
                case "firstName": {
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.FIRST_NAME, ModelCriteriaBuilder.Operator.ILIKE, searchedString);
                    break;
                }
                case "lastName": {
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.LAST_NAME, ModelCriteriaBuilder.Operator.ILIKE, searchedString);
                    break;
                }
                case "email": {
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.EMAIL, ModelCriteriaBuilder.Operator.ILIKE, searchedString);
                    break;
                }
                case "emailVerified": {
                    boolean booleanValue = Boolean.parseBoolean(value);
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.EMAIL_VERIFIED, ModelCriteriaBuilder.Operator.EQ, booleanValue);
                    break;
                }
                case "enabled": {
                    boolean booleanValue = Boolean.parseBoolean(value);
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, booleanValue);
                    break;
                }
                case "keycloak.session.realm.users.query.idp_alias": {
                    if (attributes.containsKey("keycloak.session.realm.users.query.idp_user_id")) break;
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, value);
                    break;
                }
                case "keycloak.session.realm.users.query.idp_user_id": {
                    mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.IDP_AND_USER, ModelCriteriaBuilder.Operator.EQ, attributes.get("keycloak.session.realm.users.query.idp_alias"), value);
                }
            }
        }
        Set userGroups = (Set)this.session.getAttribute("keycloak.session.realm.users.query.groups");
        if (userGroups != null) {
            if (userGroups.isEmpty()) {
                return Stream.empty();
            }
            ResourceStore resourceStore = ((AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class)).getStoreFactory().getResourceStore();
            HashSet<String> authorizedGroups = new HashSet<String>(userGroups);
            authorizedGroups.removeIf(id -> {
                EnumMap<Resource.FilterOption, String[]> values = new EnumMap<Resource.FilterOption, String[]>(Resource.FilterOption.class);
                values.put(Resource.FilterOption.EXACT_NAME, new String[]{"group.resource." + id});
                return resourceStore.findByResourceServer(values, null, 0, 1).isEmpty();
            });
            mcb = mcb.compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ASSIGNED_GROUP, ModelCriteriaBuilder.Operator.IN, authorizedGroups);
        }
        Stream<MapUserEntity<?>> usersStream = this.tx.getUpdatedNotRemoved(mcb).sorted(MapUserEntity.COMPARE_BY_USERNAME);
        return StreamsUtil.paginatedStream(usersStream, (Integer)firstResult, (Integer)maxResults).map(this.entityToAdapterFunc(realm)).filter(Objects::nonNull);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupMembersStream(%s, %s, %d, %d)%s", new Object[]{realm, group.getId(), firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ASSIGNED_GROUP, ModelCriteriaBuilder.Operator.EQ, group.getId());
        return StreamsUtil.paginatedStream(this.tx.getUpdatedNotRemoved(mcb).sorted(MapUserEntity.COMPARE_BY_USERNAME), (Integer)firstResult, (Integer)maxResults).map(this.entityToAdapterFunc(realm));
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        LOG.tracef("searchForUserByUserAttributeStream(%s, %s, %s)%s", new Object[]{realm, attrName, attrValue, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, attrName, attrValue);
        return this.tx.getUpdatedNotRemoved(mcb).sorted(MapUserEntity.COMPARE_BY_USERNAME).map(this.entityToAdapterFunc(realm));
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, null, username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        String userId = user.getId();
        Optional<MapUserEntity<String>> userById = this.getEntityById(realm, (K)userId);
        if (userById.isPresent()) {
            this.tx.delete(this.userStore.getKeyConvertor().fromString(userId));
            return true;
        }
        return false;
    }

    public Stream<UserModel> getRoleMembersStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getRoleMembersStream(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<UserModel> mcb = this.userStore.createCriteriaBuilder().compare((SearchableModelField<UserModel>)UserModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserModel>)UserModel.SearchableFields.ASSIGNED_ROLE, ModelCriteriaBuilder.Operator.EQ, role.getId());
        return StreamsUtil.paginatedStream(this.tx.getUpdatedNotRemoved(mcb).sorted(MapUserEntity.COMPARE_BY_USERNAME), (Integer)firstResult, (Integer)maxResults).map(this.entityToAdapterFunc(realm));
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.getRegisteredEntityById(realm, user.getId()).ifPresent(this.updateCredential(cred));
    }

    private Consumer<MapUserEntity<K>> updateCredential(CredentialModel credentialModel) {
        return user -> {
            UserCredentialEntity credentialEntity = user.getCredential(credentialModel.getId());
            if (credentialEntity == null) {
                return;
            }
            credentialEntity.setCreatedDate(credentialModel.getCreatedDate());
            credentialEntity.setUserLabel(credentialModel.getUserLabel());
            credentialEntity.setType(credentialModel.getType());
            credentialEntity.setSecretData(credentialModel.getSecretData());
            credentialEntity.setCredentialData(credentialModel.getCredentialData());
        };
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        LOG.tracef("createCredential(%s, %s, %s)%s", new Object[]{realm, user.getId(), cred.getId(), StackUtil.getShortStackTrace()});
        UserCredentialEntity credentialEntity = UserCredentialEntity.fromModel(cred);
        this.getRegisteredEntityByIdOrThrow(realm, user.getId()).addCredential(credentialEntity);
        return UserCredentialEntity.toModel(credentialEntity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        LOG.tracef("removeStoredCredential(%s, %s, %s)%s", new Object[]{realm, user.getId(), id, StackUtil.getShortStackTrace()});
        return this.getRegisteredEntityById(realm, user.getId()).map(mapUserEntity -> mapUserEntity.removeCredential(id)).orElse(false);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        LOG.tracef("getStoredCredentialById(%s, %s, %s)%s", new Object[]{realm, user.getId(), id, StackUtil.getShortStackTrace()});
        return this.getEntityById(realm, (K)user.getId()).map(mapUserEntity -> mapUserEntity.getCredential(id)).map(UserCredentialEntity::toModel).orElse(null);
    }

    public Stream<CredentialModel> getStoredCredentialsStream(RealmModel realm, UserModel user) {
        LOG.tracef("getStoredCredentialsStream(%s, %s)%s", (Object)realm, (Object)user.getId(), StackUtil.getShortStackTrace());
        return this.getEntityById(realm, (K)user.getId()).map(MapUserEntity::getCredentials).orElseGet(Stream::empty).map(UserCredentialEntity::toModel);
    }

    public Stream<CredentialModel> getStoredCredentialsByTypeStream(RealmModel realm, UserModel user, String type) {
        LOG.tracef("getStoredCredentialsByTypeStream(%s, %s, %s)%s", new Object[]{realm, user.getId(), type, StackUtil.getShortStackTrace()});
        return this.getStoredCredentialsStream(realm, user).filter(credential -> Objects.equals(type, credential.getType()));
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        LOG.tracef("getStoredCredentialByNameAndType(%s, %s, %s, %s)%s", new Object[]{realm, user.getId(), name, type, StackUtil.getShortStackTrace()});
        return this.getStoredCredentialsByType(realm, user, type).stream().filter(credential -> Objects.equals(name, credential.getUserLabel())).findFirst().orElse(null);
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        LOG.tracef("moveCredentialTo(%s, %s, %s, %s)%s", new Object[]{realm, user.getId(), id, newPreviousCredentialId, StackUtil.getShortStackTrace()});
        String userId = user.getId();
        MapUserEntity userEntity = this.getRegisteredEntityById(realm, userId).orElse(null);
        if (userEntity == null) {
            LOG.warnf("User with id: [%s] not found", (Object)userId);
            return false;
        }
        int newPreviousCredentialIdIndex = -1;
        if (newPreviousCredentialId != null && (newPreviousCredentialIdIndex = userEntity.getCredentialIndex(newPreviousCredentialId)) == -1) {
            LOG.warnf("Credential with id: [%s] for user: [%s] not found", (Object)newPreviousCredentialId, (Object)userId);
            return false;
        }
        int currentPositionOfId = userEntity.getCredentialIndex(id);
        if (currentPositionOfId == -1) {
            LOG.warnf("Credential with id: [%s] for user: [%s] not found", (Object)id, (Object)userId);
            return false;
        }
        if (currentPositionOfId < newPreviousCredentialIdIndex) {
            --newPreviousCredentialIdIndex;
        }
        userEntity.moveCredential(currentPositionOfId, newPreviousCredentialIdIndex + 1);
        return true;
    }

    public void close() {
    }
}

