/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapPolicyAdapter;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapPolicyStore<K>
implements PolicyStore {
    private static final Logger LOG = Logger.getLogger(MapPolicyStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<K, MapPolicyEntity<K>, Policy> tx;
    private final MapStorage<K, MapPolicyEntity<K>, Policy> policyStore;

    public MapPolicyStore(KeycloakSession session, MapStorage<K, MapPolicyEntity<K>, Policy> policyStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.policyStore = policyStore;
        this.tx = policyStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Policy entityToAdapter(MapPolicyEntity<K> origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapPolicyAdapter<K>(MapStorageUtils.registerEntityForChanges(this.tx, origEntity), this.authorizationProvider.getStoreFactory()){

            public String getId() {
                return MapPolicyStore.this.policyStore.getKeyConvertor().keyToString(((MapPolicyEntity)this.entity).getId());
            }
        };
    }

    private ModelCriteriaBuilder<Policy> forResourceServer(String resourceServerId) {
        ModelCriteriaBuilder<Policy> mcb = this.policyStore.createCriteriaBuilder();
        return resourceServerId == null ? mcb : mcb.compare((SearchableModelField<Policy>)Policy.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, resourceServerId);
    }

    public Policy create(AbstractPolicyRepresentation representation, ResourceServer resourceServer) {
        LOG.tracef("create(%s, %s, %s)%s", new Object[]{representation.getId(), resourceServer.getId(), resourceServer, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Policy> mcb = this.forResourceServer(resourceServer.getId()).compare((SearchableModelField<Policy>)Policy.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, representation.getName());
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("Policy with name '" + representation.getName() + "' for " + resourceServer.getId() + " already exists");
        }
        K uid = representation.getId() == null ? this.policyStore.getKeyConvertor().yieldNewUniqueKey() : this.policyStore.getKeyConvertor().fromString(representation.getId());
        MapPolicyEntity<K> entity = new MapPolicyEntity<K>(uid);
        entity.setType(representation.getType());
        entity.setName(representation.getName());
        entity.setResourceServerId(resourceServer.getId());
        this.tx.create(uid, entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(this.policyStore.getKeyConvertor().fromString(id));
    }

    public Policy findById(String id, String resourceServerId) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, id)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public Policy findByName(String name, String resourceServerId) {
        LOG.tracef("findByName(%s, %s)%s", (Object)name, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public List<Policy> findByResourceServer(String id) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(id)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Policy> findByResourceServer(Map<Policy.FilterOption, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        LOG.tracef("findByResource(%s, %s, %d, %d)%s", new Object[]{attributes, resourceServerId, firstResult, maxResult, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Policy> mcb = this.forResourceServer(resourceServerId).and((ModelCriteriaBuilder[])attributes.entrySet().stream().map(this::filterEntryToModelCriteriaBuilder).filter(Objects::nonNull).toArray(ModelCriteriaBuilder[]::new));
        if (!attributes.containsKey(Policy.FilterOption.OWNER) && !attributes.containsKey(Policy.FilterOption.ANY_OWNER)) {
            mcb = mcb.compare((SearchableModelField<Policy>)Policy.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]);
        }
        return StreamsUtil.paginatedStream(this.tx.read(mcb).sorted(MapPolicyEntity.COMPARE_BY_NAME), (Integer)firstResult, (Integer)maxResult).map(MapPolicyEntity::getId).map(Object::toString).map(id -> this.authorizationProvider.getStoreFactory().getPolicyStore().findById(id, resourceServerId)).collect(Collectors.toList());
    }

    private ModelCriteriaBuilder<Policy> filterEntryToModelCriteriaBuilder(Map.Entry<Policy.FilterOption, String[]> entry) {
        Policy.FilterOption name = entry.getKey();
        String[] value = entry.getValue();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case RESOURCE_ID: 
            case OWNER: {
                return this.policyStore.createCriteriaBuilder().compare((SearchableModelField<Policy>)name.getSearchableModelField(), ModelCriteriaBuilder.Operator.IN, Arrays.asList(value));
            }
            case PERMISSION: {
                ModelCriteriaBuilder<Policy> mcb = this.policyStore.createCriteriaBuilder().compare((SearchableModelField<Policy>)Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.IN, Arrays.asList("resource", "scope", "uma"));
                if (!Boolean.parseBoolean(value[0])) {
                    mcb = this.policyStore.createCriteriaBuilder().not(mcb);
                }
                return mcb;
            }
            case ANY_OWNER: {
                return null;
            }
            case CONFIG: {
                if (value.length != 2) {
                    throw new IllegalArgumentException("Config filter option requires value with two items: [config_name, expected_config_value]");
                }
                value[1] = "%" + value[1] + "%";
                return this.policyStore.createCriteriaBuilder().compare((SearchableModelField<Policy>)Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.LIKE, value);
            }
            case TYPE: 
            case NAME: {
                return this.policyStore.createCriteriaBuilder().compare((SearchableModelField<Policy>)name.getSearchableModelField(), ModelCriteriaBuilder.Operator.ILIKE, "%" + value[0] + "%");
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public void findByResource(String resourceId, String resourceServerId, Consumer<Policy> consumer) {
        LOG.tracef("findByResource(%s, %s, %s)%s", new Object[]{resourceId, resourceServerId, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, resourceId)).map(this::entityToAdapter).forEach(consumer);
    }

    public void findByResourceType(String type, String resourceServerId, Consumer<Policy> policyConsumer) {
        this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.LIKE, "defaultResourceType", type)).map(this::entityToAdapter).forEach(policyConsumer);
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, scopeIds)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public void findByScopeIds(List<String> scopeIds, String resourceId, String resourceServerId, Consumer<Policy> consumer) {
        ModelCriteriaBuilder<Policy> mcb = this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, "scope").compare((SearchableModelField<Policy>)Policy.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, scopeIds);
        mcb = resourceId != null ? mcb.compare((SearchableModelField<Policy>)Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.EQ, resourceId) : mcb.compare((SearchableModelField<Policy>)Policy.SearchableFields.RESOURCE_ID, ModelCriteriaBuilder.Operator.NOT_EXISTS, new Object[0]).compare((SearchableModelField<Policy>)Policy.SearchableFields.CONFIG, ModelCriteriaBuilder.Operator.NOT_EXISTS, "defaultResourceType");
        this.tx.read(mcb).map(this::entityToAdapter).forEach(consumer);
    }

    public List<Policy> findByType(String type, String resourceServerId) {
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, type)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Policy> findDependentPolicies(String id, String resourceServerId) {
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Policy>)Policy.SearchableFields.ASSOCIATED_POLICY_ID, ModelCriteriaBuilder.Operator.EQ, id)).map(this::entityToAdapter).collect(Collectors.toList());
    }
}

