/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.component.ComponentModelScope;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.StringKeyConvertor;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorageProvider;
import org.keycloak.models.map.storage.chm.UserSessionConcurrentHashMapStorage;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class ConcurrentHashMapStorageProviderFactory
implements AmphibianProviderFactory<MapStorageProvider>,
MapStorageProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "concurrenthashmap";
    private static final Logger LOG = Logger.getLogger(ConcurrentHashMapStorageProviderFactory.class);
    private final ConcurrentHashMap<String, ConcurrentHashMapStorage<?, ?, ?>> storages = new ConcurrentHashMap();
    private final Map<String, StringKeyConvertor> keyConvertors = new HashMap<String, StringKeyConvertor>();
    private File storageDirectory;
    private String suffix;
    private StringKeyConvertor defaultKeyConvertor;
    public static final Map<Class<?>, String> MODEL_TO_NAME = new HashMap();
    private static final Map<String, StringKeyConvertor> KEY_CONVERTORS;

    public MapStorageProvider create(KeycloakSession session) {
        return new ConcurrentHashMapStorageProvider(this);
    }

    public void init(Config.Scope config) {
        this.suffix = config instanceof ComponentModelScope ? "-" + ((ComponentModelScope)config).getComponentId() : "";
        String keyType = config.get("keyType", "uuid");
        this.defaultKeyConvertor = this.getKeyConvertor(keyType);
        for (String name : MODEL_TO_NAME.values()) {
            this.keyConvertors.put(name, this.getKeyConvertor(config.get("keyType." + name, keyType)));
        }
        String dir = config.get("dir");
        try {
            if (dir == null || dir.trim().isEmpty()) {
                LOG.warn((Object)"No directory set, created objects will not survive server restart");
                this.storageDirectory = null;
            } else {
                File f = new File(dir);
                Files.createDirectories(f.toPath(), new FileAttribute[0]);
                if (f.exists()) {
                    this.storageDirectory = f;
                } else {
                    LOG.warnf("Directory cannot be used, created objects will not survive server restart: %s", (Object)dir);
                    this.storageDirectory = null;
                }
            }
        }
        catch (IOException ex) {
            LOG.warnf("Directory cannot be used, created objects will not survive server restart: %s", (Object)dir);
            this.storageDirectory = null;
        }
    }

    private StringKeyConvertor getKeyConvertor(String keyType) throws IllegalArgumentException {
        StringKeyConvertor res = KEY_CONVERTORS.get(keyType);
        if (res == null) {
            throw new IllegalArgumentException("Unknown key type: " + keyType);
        }
        return res;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.storages.forEach(this::storeMap);
    }

    private void storeMap(String mapName, ConcurrentHashMapStorage<?, ?, ?> store) {
        if (mapName != null) {
            File f = this.getFile(mapName);
            try {
                if (this.storageDirectory != null) {
                    LOG.debugf("Storing contents to %s", (Object)f.getCanonicalPath());
                    ModelCriteriaBuilder<?> readAllCriteria = store.createCriteriaBuilder();
                    Serialization.MAPPER.writeValue(f, store.read(readAllCriteria));
                } else {
                    LOG.debugf("Not storing contents of %s because directory not set", (Object)mapName);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private <K, V extends AbstractEntity<K>, M> ConcurrentHashMapStorage<K, V, M> loadMap(final String mapName, Class<V> valueType, Class<M> modelType, EnumSet<MapStorageProviderFactory.Flag> flags) {
        File f;
        ConcurrentHashMapStorage store;
        StringKeyConvertor kc = this.keyConvertors.getOrDefault(mapName, this.defaultKeyConvertor);
        LOG.debugf("Initializing new map storage: %s", (Object)mapName);
        if (modelType == UserSessionModel.class) {
            ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel> clientSessionStore = this.getStorage(MapAuthenticatedClientSessionEntity.class, AuthenticatedClientSessionModel.class, new MapStorageProviderFactory.Flag[0]);
            store = new UserSessionConcurrentHashMapStorage(clientSessionStore, kc){

                public String toString() {
                    return "ConcurrentHashMapStorage(" + mapName + ConcurrentHashMapStorageProviderFactory.this.suffix + ")";
                }
            };
        } else {
            store = new ConcurrentHashMapStorage(modelType, kc){

                public String toString() {
                    return "ConcurrentHashMapStorage(" + mapName + ConcurrentHashMapStorageProviderFactory.this.suffix + ")";
                }
            };
        }
        if (!flags.contains((Object)MapStorageProviderFactory.Flag.INITIALIZE_EMPTY) && (f = this.getFile(mapName)) != null && f.exists()) {
            try {
                LOG.debugf("Restoring contents from %s", (Object)f.getCanonicalPath());
                CollectionType type = Serialization.MAPPER.getTypeFactory().constructCollectionType(List.class, valueType);
                List values = (List)Serialization.MAPPER.readValue(f, (JavaType)type);
                values.forEach(mce -> store.create(mce.getId(), mce));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return store;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public <K, V extends AbstractEntity<K>, M> ConcurrentHashMapStorage<K, V, M> getStorage(Class<V> valueType, Class<M> modelType, MapStorageProviderFactory.Flag ... flags) {
        EnumSet<MapStorageProviderFactory.Flag> f = flags == null || flags.length == 0 ? EnumSet.noneOf(MapStorageProviderFactory.Flag.class) : EnumSet.of(flags[0], flags);
        String name = MODEL_TO_NAME.getOrDefault(modelType, modelType.getSimpleName());
        if (modelType == UserSessionModel.class) {
            this.getStorage(MapAuthenticatedClientSessionEntity.class, AuthenticatedClientSessionModel.class, new MapStorageProviderFactory.Flag[0]);
        }
        return this.storages.computeIfAbsent(name, n -> this.loadMap(name, valueType, modelType, f));
    }

    private File getFile(String fileName) {
        return this.storageDirectory == null ? null : new File(this.storageDirectory, "map-" + fileName + this.suffix + ".json");
    }

    public String getHelpText() {
        return "In-memory ConcurrentHashMap storage";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    static {
        MODEL_TO_NAME.put(AuthenticatedClientSessionModel.class, "client-sessions");
        MODEL_TO_NAME.put(ClientScopeModel.class, "client-scopes");
        MODEL_TO_NAME.put(ClientModel.class, "clients");
        MODEL_TO_NAME.put(GroupModel.class, "groups");
        MODEL_TO_NAME.put(RealmModel.class, "realms");
        MODEL_TO_NAME.put(RoleModel.class, "roles");
        MODEL_TO_NAME.put(RootAuthenticationSessionModel.class, "auth-sessions");
        MODEL_TO_NAME.put(UserLoginFailureModel.class, "user-login-failures");
        MODEL_TO_NAME.put(UserModel.class, "users");
        MODEL_TO_NAME.put(UserSessionModel.class, "user-sessions");
        MODEL_TO_NAME.put(PermissionTicket.class, "authz-permission-tickets");
        MODEL_TO_NAME.put(Policy.class, "authz-policies");
        MODEL_TO_NAME.put(ResourceServer.class, "authz-resource-servers");
        MODEL_TO_NAME.put(Resource.class, "authz-resources");
        MODEL_TO_NAME.put(Scope.class, "authz-scopes");
        KEY_CONVERTORS = new HashMap<String, StringKeyConvertor>();
        KEY_CONVERTORS.put("uuid", StringKeyConvertor.UUIDKey.INSTANCE);
        KEY_CONVERTORS.put("string", StringKeyConvertor.StringKey.INSTANCE);
        KEY_CONVERTORS.put("ulong", StringKeyConvertor.ULongKey.INSTANCE);
    }
}

