/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public class SessionExpiration {
    public static <K> void setClientSessionExpiration(MapAuthenticatedClientSessionEntity<K> entity, RealmModel realm, ClientModel client) {
        if (entity.isOffline()) {
            long sessionExpires = entity.getTimestamp() + realm.getOfflineSessionIdleTimeout();
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                sessionExpires = entity.getTimestamp() + realm.getOfflineSessionMaxLifespan();
                String clientOfflineSessionMaxLifespanPerClient = client.getAttribute("client.offline.session.max.lifespan");
                long clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespanPerClient != null && !clientOfflineSessionMaxLifespanPerClient.trim().isEmpty() ? Long.parseLong(clientOfflineSessionMaxLifespanPerClient) : (long)realm.getClientOfflineSessionMaxLifespan();
                if (clientOfflineSessionMaxLifespan > 0L) {
                    long clientOfflineSessionMaxExpiration = (long)entity.getTimestamp() + clientOfflineSessionMaxLifespan;
                    sessionExpires = Math.min(sessionExpires, clientOfflineSessionMaxExpiration);
                }
            }
            long expiration = entity.getTimestamp() + realm.getOfflineSessionIdleTimeout();
            String clientOfflineSessionIdleTimeoutPerClient = client.getAttribute("client.offline.session.idle.timeout");
            long clientOfflineSessionIdleTimeout = clientOfflineSessionIdleTimeoutPerClient != null && !clientOfflineSessionIdleTimeoutPerClient.trim().isEmpty() ? Long.parseLong(clientOfflineSessionIdleTimeoutPerClient) : (long)realm.getClientOfflineSessionIdleTimeout();
            if (clientOfflineSessionIdleTimeout > 0L) {
                long clientOfflineSessionIdleExpiration = (long)entity.getTimestamp() + clientOfflineSessionIdleTimeout;
                expiration = Math.min(expiration, clientOfflineSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        } else {
            long sessionExpires = (long)entity.getTimestamp() + (long)(realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan());
            String clientSessionMaxLifespanPerClient = client.getAttribute("client.session.max.lifespan");
            long clientSessionMaxLifespan = clientSessionMaxLifespanPerClient != null && !clientSessionMaxLifespanPerClient.trim().isEmpty() ? Long.parseLong(clientSessionMaxLifespanPerClient) : (long)realm.getClientSessionMaxLifespan();
            if (clientSessionMaxLifespan > 0L) {
                long clientSessionMaxExpiration = (long)entity.getTimestamp() + clientSessionMaxLifespan;
                sessionExpires = Math.min(sessionExpires, clientSessionMaxExpiration);
            }
            long expiration = (long)entity.getTimestamp() + (long)(realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? realm.getSsoSessionIdleTimeoutRememberMe() : realm.getSsoSessionIdleTimeout());
            String clientSessionIdleTimeoutPerClient = client.getAttribute("client.session.idle.timeout");
            long clientSessionIdleTimeout = clientSessionIdleTimeoutPerClient != null && !clientSessionIdleTimeoutPerClient.trim().isEmpty() ? Long.parseLong(clientSessionIdleTimeoutPerClient) : (long)realm.getClientSessionIdleTimeout();
            if (clientSessionIdleTimeout > 0L) {
                long clientSessionIdleExpiration = (long)entity.getTimestamp() + clientSessionIdleTimeout;
                expiration = Math.min(expiration, clientSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        }
    }

    public static <K> void setUserSessionExpiration(MapUserSessionEntity<K> entity, RealmModel realm) {
        if (entity.isOffline()) {
            long sessionExpires = entity.getLastSessionRefresh() + realm.getOfflineSessionIdleTimeout();
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                sessionExpires = entity.getStarted() + realm.getOfflineSessionMaxLifespan();
                long clientOfflineSessionMaxLifespan = realm.getClientOfflineSessionMaxLifespan();
                if (clientOfflineSessionMaxLifespan > 0L) {
                    long clientOfflineSessionMaxExpiration = (long)entity.getStarted() + clientOfflineSessionMaxLifespan;
                    sessionExpires = Math.min(sessionExpires, clientOfflineSessionMaxExpiration);
                }
            }
            long expiration = entity.getLastSessionRefresh() + realm.getOfflineSessionIdleTimeout();
            long clientOfflineSessionIdleTimeout = realm.getClientOfflineSessionIdleTimeout();
            if (clientOfflineSessionIdleTimeout > 0L) {
                long clientOfflineSessionIdleExpiration = (long)Time.currentTime() + clientOfflineSessionIdleTimeout;
                expiration = Math.min(expiration, clientOfflineSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        } else {
            long sessionExpires = (long)entity.getStarted() + (long)(entity.isRememberMe() && realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan());
            long clientSessionMaxLifespan = realm.getClientSessionMaxLifespan();
            if (clientSessionMaxLifespan > 0L) {
                long clientSessionMaxExpiration = (long)entity.getStarted() + clientSessionMaxLifespan;
                sessionExpires = Math.min(sessionExpires, clientSessionMaxExpiration);
            }
            long expiration = (long)entity.getLastSessionRefresh() + (long)(entity.isRememberMe() && realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? realm.getSsoSessionIdleTimeoutRememberMe() : realm.getSsoSessionIdleTimeout());
            long clientSessionIdleTimeout = realm.getClientSessionIdleTimeout();
            if (clientSessionIdleTimeout > 0L) {
                long clientSessionIdleExpiration = (long)entity.getLastSessionRefresh() + clientSessionIdleTimeout;
                expiration = Math.min(expiration, clientSessionIdleExpiration);
            }
            entity.setExpiration(Math.min(expiration, sessionExpires));
        }
    }
}

