/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapScopeAdapter;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.storage.SearchableModelField;

public class MapScopeStore
implements ScopeStore {
    private static final Logger LOG = Logger.getLogger(MapScopeStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<MapScopeEntity, Scope> tx;
    private final MapStorage<MapScopeEntity, Scope> scopeStore;

    public MapScopeStore(KeycloakSession session, MapStorage<MapScopeEntity, Scope> scopeStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.scopeStore = scopeStore;
        this.tx = scopeStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Scope entityToAdapter(MapScopeEntity origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapScopeAdapter(origEntity, this.authorizationProvider.getStoreFactory());
    }

    private ModelCriteriaBuilder<Scope> forResourceServer(String resourceServerId) {
        ModelCriteriaBuilder<Scope> mcb = this.scopeStore.createCriteriaBuilder();
        return resourceServerId == null ? mcb : mcb.compare((SearchableModelField<Scope>)Scope.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, resourceServerId);
    }

    public Scope create(String id, String name, ResourceServer resourceServer) {
        LOG.tracef("create(%s, %s, %s)%s", new Object[]{id, name, resourceServer, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Scope> mcb = this.forResourceServer(resourceServer.getId()).compare((SearchableModelField<Scope>)Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name);
        if (this.tx.getCount(QueryParameters.withCriteria(mcb)) > 0L) {
            throw new ModelDuplicateException("Scope with name '" + name + "' for " + resourceServer.getId() + " already exists");
        }
        MapScopeEntity entity = new MapScopeEntity(id);
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        entity = this.tx.create(entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(id);
    }

    public Scope findById(String id, String resourceServerId) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServerId).compare((SearchableModelField<Scope>)Scope.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, id))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public Scope findByName(String name, String resourceServerId) {
        LOG.tracef("findByName(%s, %s)%s", (Object)name, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(resourceServerId).compare((SearchableModelField<Scope>)Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name))).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public List<Scope> findByResourceServer(String id) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        return this.tx.read(QueryParameters.withCriteria(this.forResourceServer(id))).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Scope> findByResourceServer(Map<Scope.FilterOption, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        ModelCriteriaBuilder<Scope> mcb = this.forResourceServer(resourceServerId);
        block4: for (Scope.FilterOption filterOption : attributes.keySet()) {
            String[] value = attributes.get(filterOption);
            switch (filterOption) {
                case ID: {
                    mcb = mcb.compare((SearchableModelField<Scope>)Scope.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, Arrays.asList(value));
                    continue block4;
                }
                case NAME: {
                    mcb = mcb.compare((SearchableModelField<Scope>)Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + value[0] + "%");
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
        }
        return this.tx.read(QueryParameters.withCriteria(mcb).pagination(firstResult, maxResult, (SearchableModelField<Scope>)Scope.SearchableFields.NAME)).map(this::entityToAdapter).collect(Collectors.toList());
    }
}

