/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.Objects;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.map.common.UpdatableEntity;

public class MapOTPPolicyEntity
implements UpdatableEntity {
    private Integer otpPolicyInitialCounter = 0;
    private Integer otpPolicyDigits = 0;
    private Integer otpPolicyLookAheadWindow = 0;
    private Integer otpPolicyPeriod = 0;
    private String otpPolicyType;
    private String otpPolicyAlgorithm;
    private boolean updated;

    private MapOTPPolicyEntity() {
    }

    public static MapOTPPolicyEntity fromModel(OTPPolicy model) {
        if (model == null) {
            return null;
        }
        MapOTPPolicyEntity entity = new MapOTPPolicyEntity();
        entity.setOtpPolicyAlgorithm(model.getAlgorithm());
        entity.setOtpPolicyDigits(model.getDigits());
        entity.setOtpPolicyInitialCounter(model.getInitialCounter());
        entity.setOtpPolicyLookAheadWindow(model.getLookAheadWindow());
        entity.setOtpPolicyType(model.getType());
        entity.setOtpPolicyPeriod(model.getPeriod());
        return entity;
    }

    public static OTPPolicy toModel(MapOTPPolicyEntity entity) {
        if (entity == null) {
            return null;
        }
        OTPPolicy model = new OTPPolicy();
        model.setDigits(entity.getOtpPolicyDigits().intValue());
        model.setAlgorithm(entity.getOtpPolicyAlgorithm());
        model.setInitialCounter(entity.getOtpPolicyInitialCounter().intValue());
        model.setLookAheadWindow(entity.getOtpPolicyLookAheadWindow().intValue());
        model.setType(entity.getOtpPolicyType());
        model.setPeriod(entity.getOtpPolicyPeriod().intValue());
        return model;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public Integer getOtpPolicyInitialCounter() {
        return this.otpPolicyInitialCounter;
    }

    public void setOtpPolicyInitialCounter(int otpPolicyInitialCounter) {
        this.updated = !Objects.equals(this.otpPolicyInitialCounter, otpPolicyInitialCounter);
        this.otpPolicyInitialCounter = otpPolicyInitialCounter;
    }

    public Integer getOtpPolicyDigits() {
        return this.otpPolicyDigits;
    }

    public void setOtpPolicyDigits(int otpPolicyDigits) {
        this.updated = !Objects.equals(this.otpPolicyDigits, otpPolicyDigits);
        this.otpPolicyDigits = otpPolicyDigits;
    }

    public Integer getOtpPolicyLookAheadWindow() {
        return this.otpPolicyLookAheadWindow;
    }

    public void setOtpPolicyLookAheadWindow(int otpPolicyLookAheadWindow) {
        this.updated = !Objects.equals(this.otpPolicyLookAheadWindow, otpPolicyLookAheadWindow);
        this.otpPolicyLookAheadWindow = otpPolicyLookAheadWindow;
    }

    public Integer getOtpPolicyPeriod() {
        return this.otpPolicyPeriod;
    }

    public void setOtpPolicyPeriod(int otpPolicyPeriod) {
        this.updated = !Objects.equals(this.otpPolicyPeriod, otpPolicyPeriod);
        this.otpPolicyPeriod = otpPolicyPeriod;
    }

    public String getOtpPolicyType() {
        return this.otpPolicyType;
    }

    public void setOtpPolicyType(String otpPolicyType) {
        this.updated = !Objects.equals(this.otpPolicyType, otpPolicyType);
        this.otpPolicyType = otpPolicyType;
    }

    public String getOtpPolicyAlgorithm() {
        return this.otpPolicyAlgorithm;
    }

    public void setOtpPolicyAlgorithm(String otpPolicyAlgorithm) {
        this.updated = !Objects.equals(this.otpPolicyAlgorithm, otpPolicyAlgorithm);
        this.otpPolicyAlgorithm = otpPolicyAlgorithm;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + this.otpPolicyInitialCounter;
        hash = 59 * hash + this.otpPolicyDigits;
        hash = 59 * hash + this.otpPolicyLookAheadWindow;
        hash = 59 * hash + this.otpPolicyPeriod;
        hash = 59 * hash + Objects.hashCode(this.otpPolicyType);
        hash = 59 * hash + Objects.hashCode(this.otpPolicyAlgorithm);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapOTPPolicyEntity)) {
            return false;
        }
        MapOTPPolicyEntity other = (MapOTPPolicyEntity)obj;
        return Objects.equals(other.getOtpPolicyAlgorithm(), this.getOtpPolicyAlgorithm()) && Objects.equals(other.getOtpPolicyDigits(), this.getOtpPolicyDigits()) && Objects.equals(other.getOtpPolicyInitialCounter(), this.getOtpPolicyInitialCounter()) && Objects.equals(other.getOtpPolicyLookAheadWindow(), this.getOtpPolicyLookAheadWindow()) && Objects.equals(other.getOtpPolicyPeriod(), this.getOtpPolicyPeriod()) && Objects.equals(other.getOtpPolicyType(), this.getOtpPolicyType());
    }
}

