/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.map.client.MapClientEntity;

public class MapClientEntityImpl
implements MapClientEntity {
    private String id;
    private String realmId;
    private String clientId;
    private String name;
    private String description;
    private Set<String> redirectUris = new HashSet<String>();
    private boolean enabled;
    private boolean alwaysDisplayInConsole;
    private String clientAuthenticatorType;
    private String secret;
    private String registrationToken;
    private String protocol;
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private Map<String, String> authFlowBindings = new HashMap<String, String>();
    private boolean publicClient;
    private boolean fullScopeAllowed;
    private boolean frontchannelLogout;
    private int notBefore;
    private Set<String> scope = new HashSet<String>();
    private Set<String> webOrigins = new HashSet<String>();
    private Map<String, ProtocolMapperModel> protocolMappers = new HashMap<String, ProtocolMapperModel>();
    private Map<String, Boolean> clientScopes = new HashMap<String, Boolean>();
    private Set<String> scopeMappings = new LinkedHashSet<String>();
    private boolean surrogateAuthRequired;
    private String managementUrl;
    private String rootUrl;
    private String baseUrl;
    private boolean bearerOnly;
    private boolean consentRequired;
    private boolean standardFlowEnabled;
    private boolean implicitFlowEnabled;
    private boolean directAccessGrantsEnabled;
    private boolean serviceAccountsEnabled;
    private int nodeReRegistrationTimeout;
    protected boolean updated;

    protected MapClientEntityImpl() {
        this.id = null;
        this.realmId = null;
    }

    public MapClientEntityImpl(String id, String realmId) {
        Objects.requireNonNull(realmId, "realmId");
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(String clientId) {
        this.updated |= !Objects.equals(this.clientId, clientId);
        this.clientId = clientId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.updated |= !Objects.equals(this.description, description);
        this.description = description;
    }

    @Override
    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    @Override
    public void setRedirectUris(Set<String> redirectUris) {
        this.updated |= !Objects.equals(this.redirectUris, redirectUris);
        this.redirectUris = redirectUris;
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.updated |= !Objects.equals(this.enabled, enabled);
        this.enabled = enabled;
    }

    @Override
    public Boolean isAlwaysDisplayInConsole() {
        return this.alwaysDisplayInConsole;
    }

    @Override
    public void setAlwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        this.updated |= !Objects.equals(this.alwaysDisplayInConsole, alwaysDisplayInConsole);
        this.alwaysDisplayInConsole = alwaysDisplayInConsole;
    }

    @Override
    public String getClientAuthenticatorType() {
        return this.clientAuthenticatorType;
    }

    @Override
    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.updated |= !Objects.equals(this.clientAuthenticatorType, clientAuthenticatorType);
        this.clientAuthenticatorType = clientAuthenticatorType;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public void setSecret(String secret) {
        this.updated |= !Objects.equals(this.secret, secret);
        this.secret = secret;
    }

    @Override
    public String getRegistrationToken() {
        return this.registrationToken;
    }

    @Override
    public void setRegistrationToken(String registrationToken) {
        this.updated |= !Objects.equals(this.registrationToken, registrationToken);
        this.registrationToken = registrationToken;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.updated |= !Objects.equals(this.protocol, protocol);
        this.protocol = protocol;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        this.updated |= !Objects.equals(this.attributes.put(name, values), values);
    }

    @Override
    public Map<String, String> getAuthFlowBindings() {
        return this.authFlowBindings;
    }

    @Override
    public void setAuthFlowBindings(Map<String, String> authFlowBindings) {
        this.updated |= !Objects.equals(this.authFlowBindings, authFlowBindings);
        this.authFlowBindings = authFlowBindings;
    }

    @Override
    public Boolean isPublicClient() {
        return this.publicClient;
    }

    @Override
    public void setPublicClient(Boolean publicClient) {
        this.updated |= !Objects.equals(this.publicClient, publicClient);
        this.publicClient = publicClient;
    }

    @Override
    public Boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }

    @Override
    public void setFullScopeAllowed(Boolean fullScopeAllowed) {
        this.updated |= !Objects.equals(this.fullScopeAllowed, fullScopeAllowed);
        this.fullScopeAllowed = fullScopeAllowed;
    }

    @Override
    public Boolean isFrontchannelLogout() {
        return this.frontchannelLogout;
    }

    @Override
    public void setFrontchannelLogout(Boolean frontchannelLogout) {
        this.updated |= !Objects.equals(this.frontchannelLogout, frontchannelLogout);
        this.frontchannelLogout = frontchannelLogout;
    }

    @Override
    public int getNotBefore() {
        return this.notBefore;
    }

    @Override
    public void setNotBefore(int notBefore) {
        this.updated |= !Objects.equals(this.notBefore, notBefore);
        this.notBefore = notBefore;
    }

    @Override
    public Set<String> getScope() {
        return this.scope;
    }

    @Override
    public void setScope(Set<String> scope) {
        this.updated |= !Objects.equals(this.scope, scope);
        this.scope.clear();
        this.scope.addAll(scope);
    }

    @Override
    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    @Override
    public void setWebOrigins(Set<String> webOrigins) {
        this.updated |= !Objects.equals(this.webOrigins, webOrigins);
        this.webOrigins.clear();
        this.webOrigins.addAll(webOrigins);
    }

    @Override
    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        Objects.requireNonNull(model.getId(), "protocolMapper.id");
        this.updated = true;
        this.protocolMappers.put(model.getId(), model);
        return model;
    }

    @Override
    public Collection<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers.values();
    }

    @Override
    public void updateProtocolMapper(String id, ProtocolMapperModel mapping) {
        this.updated = true;
        this.protocolMappers.put(id, mapping);
    }

    @Override
    public void removeProtocolMapper(String id) {
        this.updated |= this.protocolMappers.remove(id) != null;
    }

    @Override
    public void setProtocolMappers(Collection<ProtocolMapperModel> protocolMappers) {
        this.updated |= !Objects.equals(this.protocolMappers, protocolMappers);
        this.protocolMappers.clear();
        this.protocolMappers.putAll(protocolMappers.stream().collect(Collectors.toMap(ProtocolMapperModel::getId, Function.identity())));
    }

    @Override
    public ProtocolMapperModel getProtocolMapperById(String id) {
        return id == null ? null : this.protocolMappers.get(id);
    }

    @Override
    public Boolean isSurrogateAuthRequired() {
        return this.surrogateAuthRequired;
    }

    @Override
    public void setSurrogateAuthRequired(Boolean surrogateAuthRequired) {
        this.updated |= !Objects.equals(this.surrogateAuthRequired, surrogateAuthRequired);
        this.surrogateAuthRequired = surrogateAuthRequired;
    }

    @Override
    public String getManagementUrl() {
        return this.managementUrl;
    }

    @Override
    public void setManagementUrl(String managementUrl) {
        this.updated |= !Objects.equals(this.managementUrl, managementUrl);
        this.managementUrl = managementUrl;
    }

    @Override
    public String getRootUrl() {
        return this.rootUrl;
    }

    @Override
    public void setRootUrl(String rootUrl) {
        this.updated |= !Objects.equals(this.rootUrl, rootUrl);
        this.rootUrl = rootUrl;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.updated |= !Objects.equals(this.baseUrl, baseUrl);
        this.baseUrl = baseUrl;
    }

    @Override
    public Boolean isBearerOnly() {
        return this.bearerOnly;
    }

    @Override
    public void setBearerOnly(Boolean bearerOnly) {
        this.updated |= !Objects.equals(this.bearerOnly, bearerOnly);
        this.bearerOnly = bearerOnly;
    }

    @Override
    public Boolean isConsentRequired() {
        return this.consentRequired;
    }

    @Override
    public void setConsentRequired(Boolean consentRequired) {
        this.updated |= !Objects.equals(this.consentRequired, consentRequired);
        this.consentRequired = consentRequired;
    }

    @Override
    public Boolean isStandardFlowEnabled() {
        return this.standardFlowEnabled;
    }

    @Override
    public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        this.updated |= !Objects.equals(this.standardFlowEnabled, standardFlowEnabled);
        this.standardFlowEnabled = standardFlowEnabled;
    }

    @Override
    public Boolean isImplicitFlowEnabled() {
        return this.implicitFlowEnabled;
    }

    @Override
    public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        this.updated |= !Objects.equals(this.implicitFlowEnabled, implicitFlowEnabled);
        this.implicitFlowEnabled = implicitFlowEnabled;
    }

    @Override
    public Boolean isDirectAccessGrantsEnabled() {
        return this.directAccessGrantsEnabled;
    }

    @Override
    public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        this.updated |= !Objects.equals(this.directAccessGrantsEnabled, directAccessGrantsEnabled);
        this.directAccessGrantsEnabled = directAccessGrantsEnabled;
    }

    @Override
    public Boolean isServiceAccountsEnabled() {
        return this.serviceAccountsEnabled;
    }

    @Override
    public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        this.updated |= !Objects.equals(this.serviceAccountsEnabled, serviceAccountsEnabled);
        this.serviceAccountsEnabled = serviceAccountsEnabled;
    }

    @Override
    public int getNodeReRegistrationTimeout() {
        return this.nodeReRegistrationTimeout;
    }

    @Override
    public void setNodeReRegistrationTimeout(int nodeReRegistrationTimeout) {
        this.updated |= !Objects.equals(this.nodeReRegistrationTimeout, nodeReRegistrationTimeout);
        this.nodeReRegistrationTimeout = nodeReRegistrationTimeout;
    }

    @Override
    public void addWebOrigin(String webOrigin) {
        this.updated = true;
        this.webOrigins.add(webOrigin);
    }

    @Override
    public void removeWebOrigin(String webOrigin) {
        this.updated |= this.webOrigins.remove(webOrigin);
    }

    @Override
    public void addRedirectUri(String redirectUri) {
        this.updated |= !this.redirectUris.contains(redirectUri);
        this.redirectUris.add(redirectUri);
    }

    @Override
    public void removeRedirectUri(String redirectUri) {
        this.updated |= this.redirectUris.remove(redirectUri);
    }

    @Override
    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    @Override
    public List<String> getAttribute(String name) {
        return this.attributes.getOrDefault(name, Collections.EMPTY_LIST);
    }

    @Override
    public String getAuthenticationFlowBindingOverride(String binding) {
        return this.authFlowBindings.get(binding);
    }

    @Override
    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.authFlowBindings;
    }

    @Override
    public void removeAuthenticationFlowBindingOverride(String binding) {
        this.updated |= this.authFlowBindings.remove(binding) != null;
    }

    @Override
    public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        this.updated = true;
        this.authFlowBindings.put(binding, flowId);
    }

    @Override
    public Collection<String> getScopeMappings() {
        return this.scopeMappings;
    }

    @Override
    public void addScopeMapping(String id) {
        if (id != null) {
            this.updated = true;
            this.scopeMappings.add(id);
        }
    }

    @Override
    public void deleteScopeMapping(String id) {
        this.updated |= this.scopeMappings.remove(id);
    }

    @Override
    public void addClientScope(String id, Boolean defaultScope) {
        if (id != null) {
            this.updated = true;
            this.clientScopes.put(id, defaultScope);
        }
    }

    @Override
    public void removeClientScope(String id) {
        if (id != null) {
            this.updated |= this.clientScopes.remove(id) != null;
        }
    }

    @Override
    public Stream<String> getClientScopes(boolean defaultScope) {
        return this.clientScopes.entrySet().stream().filter(me -> Objects.equals(me.getValue(), defaultScope)).map(Map.Entry::getKey);
    }

    @Override
    public String getRealmId() {
        return this.realmId;
    }
}

