/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.Time;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationExecutionEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticationFlowEntity;
import org.keycloak.models.map.realm.entity.MapAuthenticatorConfigEntity;
import org.keycloak.models.map.realm.entity.MapClientInitialAccessEntity;
import org.keycloak.models.map.realm.entity.MapComponentEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderEntity;
import org.keycloak.models.map.realm.entity.MapIdentityProviderMapperEntity;
import org.keycloak.models.map.realm.entity.MapOTPPolicyEntity;
import org.keycloak.models.map.realm.entity.MapRequiredActionProviderEntity;
import org.keycloak.models.map.realm.entity.MapRequiredCredentialEntity;
import org.keycloak.models.map.realm.entity.MapWebAuthnPolicyEntity;

public class MapRealmEntity
implements AbstractEntity,
UpdatableEntity {
    private String id;
    private String name;
    private Boolean enabled = false;
    private Boolean registrationAllowed = false;
    private Boolean registrationEmailAsUsername = false;
    private Boolean verifyEmail = false;
    private Boolean resetPasswordAllowed = false;
    private Boolean loginWithEmailAllowed = false;
    private Boolean duplicateEmailsAllowed = false;
    private Boolean rememberMe = false;
    private Boolean editUsernameAllowed = false;
    private Boolean revokeRefreshToken = false;
    private Boolean adminEventsEnabled = false;
    private Boolean adminEventsDetailsEnabled = false;
    private Boolean internationalizationEnabled = false;
    private Boolean allowUserManagedAccess = false;
    private Boolean offlineSessionMaxLifespanEnabled = false;
    private Boolean eventsEnabled = false;
    private Integer refreshTokenMaxReuse = 0;
    private Integer ssoSessionIdleTimeout = 0;
    private Integer ssoSessionMaxLifespan = 0;
    private Integer ssoSessionIdleTimeoutRememberMe = 0;
    private Integer ssoSessionMaxLifespanRememberMe = 0;
    private Integer offlineSessionIdleTimeout = 0;
    private Integer accessTokenLifespan = 0;
    private Integer accessTokenLifespanForImplicitFlow = 0;
    private Integer accessCodeLifespan = 0;
    private Integer accessCodeLifespanUserAction = 0;
    private Integer accessCodeLifespanLogin = 0;
    private Integer notBefore = 0;
    private Integer clientSessionIdleTimeout = 0;
    private Integer clientSessionMaxLifespan = 0;
    private Integer clientOfflineSessionIdleTimeout = 0;
    private Integer clientOfflineSessionMaxLifespan = 0;
    private Integer actionTokenGeneratedByAdminLifespan = 0;
    private Integer offlineSessionMaxLifespan = 0;
    private Long eventsExpiration = 0L;
    private String displayName;
    private String displayNameHtml;
    private String passwordPolicy;
    private String sslRequired;
    private String loginTheme;
    private String accountTheme;
    private String adminTheme;
    private String emailTheme;
    private String masterAdminClient;
    private String defaultRoleId;
    private String defaultLocale;
    private String browserFlow;
    private String registrationFlow;
    private String directGrantFlow;
    private String resetCredentialsFlow;
    private String clientAuthenticationFlow;
    private String dockerAuthenticationFlow;
    private MapOTPPolicyEntity otpPolicy = MapOTPPolicyEntity.fromModel(OTPPolicy.DEFAULT_POLICY);
    private MapWebAuthnPolicyEntity webAuthnPolicy = MapWebAuthnPolicyEntity.defaultWebAuthnPolicy();
    private MapWebAuthnPolicyEntity webAuthnPolicyPasswordless = MapWebAuthnPolicyEntity.defaultWebAuthnPolicy();
    private Set<String> eventsListeners = new HashSet<String>();
    private Set<String> enabledEventTypes = new HashSet<String>();
    private Set<String> supportedLocales = new HashSet<String>();
    private Map<String, String> browserSecurityHeaders = new HashMap<String, String>();
    private Map<String, String> smtpConfig = new HashMap<String, String>();
    private final Set<String> defaultGroupIds = new HashSet<String>();
    private final Set<String> defaultClientScopes = new HashSet<String>();
    private final Set<String> optionalClientScopes = new HashSet<String>();
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private final Map<String, Map<String, String>> localizationTexts = new HashMap<String, Map<String, String>>();
    private final Map<String, MapClientInitialAccessEntity> clientInitialAccesses = new HashMap<String, MapClientInitialAccessEntity>();
    private final Map<String, MapComponentEntity> components = new HashMap<String, MapComponentEntity>();
    private final Map<String, MapAuthenticationFlowEntity> authenticationFlows = new HashMap<String, MapAuthenticationFlowEntity>();
    private final Map<String, MapAuthenticationExecutionEntity> authenticationExecutions = new HashMap<String, MapAuthenticationExecutionEntity>();
    private final Map<String, MapRequiredCredentialEntity> requiredCredentials = new HashMap<String, MapRequiredCredentialEntity>();
    private final Map<String, MapAuthenticatorConfigEntity> authenticatorConfigs = new HashMap<String, MapAuthenticatorConfigEntity>();
    private final Map<String, MapIdentityProviderEntity> identityProviders = new HashMap<String, MapIdentityProviderEntity>();
    private final Map<String, MapIdentityProviderMapperEntity> identityProviderMappers = new HashMap<String, MapIdentityProviderMapperEntity>();
    private final Map<String, MapRequiredActionProviderEntity> requiredActionProviders = new HashMap<String, MapRequiredActionProviderEntity>();
    protected boolean updated;

    protected MapRealmEntity() {
        this.id = null;
    }

    public MapRealmEntity(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated || this.authenticationExecutions.values().stream().anyMatch(MapAuthenticationExecutionEntity::isUpdated) || this.authenticationFlows.values().stream().anyMatch(MapAuthenticationFlowEntity::isUpdated) || this.authenticatorConfigs.values().stream().anyMatch(MapAuthenticatorConfigEntity::isUpdated) || this.clientInitialAccesses.values().stream().anyMatch(MapClientInitialAccessEntity::isUpdated) || this.components.values().stream().anyMatch(MapComponentEntity::isUpdated) || this.identityProviders.values().stream().anyMatch(MapIdentityProviderEntity::isUpdated) || this.identityProviderMappers.values().stream().anyMatch(MapIdentityProviderMapperEntity::isUpdated) || this.requiredActionProviders.values().stream().anyMatch(MapRequiredActionProviderEntity::isUpdated) || this.requiredCredentials.values().stream().anyMatch(MapRequiredCredentialEntity::isUpdated) || this.otpPolicy.isUpdated() || this.webAuthnPolicy.isUpdated() || this.webAuthnPolicyPasswordless.isUpdated();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.updated |= !Objects.equals(this.displayName, displayName);
        this.displayName = displayName;
    }

    public String getDisplayNameHtml() {
        return this.displayNameHtml;
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.updated |= !Objects.equals(this.displayNameHtml, displayNameHtml);
        this.displayNameHtml = displayNameHtml;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.updated |= !Objects.equals(this.enabled, enabled);
        this.enabled = enabled;
    }

    public Boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public void setRegistrationAllowed(Boolean registrationAllowed) {
        this.updated |= !Objects.equals(this.registrationAllowed, registrationAllowed);
        this.registrationAllowed = registrationAllowed;
    }

    public Boolean isRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    public void setRegistrationEmailAsUsername(Boolean registrationEmailAsUsername) {
        this.updated |= !Objects.equals(this.registrationEmailAsUsername, registrationEmailAsUsername);
        this.registrationEmailAsUsername = registrationEmailAsUsername;
    }

    public Boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public void setVerifyEmail(Boolean verifyEmail) {
        this.updated |= !Objects.equals(this.verifyEmail, verifyEmail);
        this.verifyEmail = verifyEmail;
    }

    public Boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public void setResetPasswordAllowed(Boolean resetPasswordAllowed) {
        this.updated |= !Objects.equals(this.resetPasswordAllowed, resetPasswordAllowed);
        this.resetPasswordAllowed = resetPasswordAllowed;
    }

    public Boolean isLoginWithEmailAllowed() {
        return this.loginWithEmailAllowed;
    }

    public void setLoginWithEmailAllowed(Boolean loginWithEmailAllowed) {
        this.updated |= !Objects.equals(this.loginWithEmailAllowed, loginWithEmailAllowed);
        this.loginWithEmailAllowed = loginWithEmailAllowed;
    }

    public Boolean isDuplicateEmailsAllowed() {
        return this.duplicateEmailsAllowed;
    }

    public void setDuplicateEmailsAllowed(Boolean duplicateEmailsAllowed) {
        this.updated |= !Objects.equals(this.duplicateEmailsAllowed, duplicateEmailsAllowed);
        this.duplicateEmailsAllowed = duplicateEmailsAllowed;
    }

    public Boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(Boolean rememberMe) {
        this.updated |= !Objects.equals(this.rememberMe, rememberMe);
        this.rememberMe = rememberMe;
    }

    public Boolean isEditUsernameAllowed() {
        return this.editUsernameAllowed;
    }

    public void setEditUsernameAllowed(Boolean editUsernameAllowed) {
        this.updated |= !Objects.equals(this.editUsernameAllowed, editUsernameAllowed);
        this.editUsernameAllowed = editUsernameAllowed;
    }

    public Boolean isRevokeRefreshToken() {
        return this.revokeRefreshToken;
    }

    public void setRevokeRefreshToken(Boolean revokeRefreshToken) {
        this.updated |= !Objects.equals(this.revokeRefreshToken, revokeRefreshToken);
        this.revokeRefreshToken = revokeRefreshToken;
    }

    public Boolean isAdminEventsEnabled() {
        return this.adminEventsEnabled;
    }

    public void setAdminEventsEnabled(Boolean adminEventsEnabled) {
        this.updated |= !Objects.equals(this.adminEventsEnabled, adminEventsEnabled);
        this.adminEventsEnabled = adminEventsEnabled;
    }

    public Boolean isAdminEventsDetailsEnabled() {
        return this.adminEventsDetailsEnabled;
    }

    public void setAdminEventsDetailsEnabled(Boolean adminEventsDetailsEnabled) {
        this.updated |= !Objects.equals(this.adminEventsDetailsEnabled, adminEventsDetailsEnabled);
        this.adminEventsDetailsEnabled = adminEventsDetailsEnabled;
    }

    public Boolean isInternationalizationEnabled() {
        return this.internationalizationEnabled;
    }

    public void setInternationalizationEnabled(Boolean internationalizationEnabled) {
        this.updated |= !Objects.equals(this.internationalizationEnabled, internationalizationEnabled);
        this.internationalizationEnabled = internationalizationEnabled;
    }

    public Boolean isAllowUserManagedAccess() {
        return this.allowUserManagedAccess;
    }

    public void setAllowUserManagedAccess(Boolean allowUserManagedAccess) {
        this.updated |= !Objects.equals(this.allowUserManagedAccess, allowUserManagedAccess);
        this.allowUserManagedAccess = allowUserManagedAccess;
    }

    public Boolean isOfflineSessionMaxLifespanEnabled() {
        return this.offlineSessionMaxLifespanEnabled;
    }

    public void setOfflineSessionMaxLifespanEnabled(Boolean offlineSessionMaxLifespanEnabled) {
        this.updated |= !Objects.equals(this.offlineSessionMaxLifespanEnabled, offlineSessionMaxLifespanEnabled);
        this.offlineSessionMaxLifespanEnabled = offlineSessionMaxLifespanEnabled;
    }

    public Boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(Boolean eventsEnabled) {
        this.updated |= !Objects.equals(this.eventsEnabled, eventsEnabled);
        this.eventsEnabled = eventsEnabled;
    }

    public Integer getRefreshTokenMaxReuse() {
        return this.refreshTokenMaxReuse;
    }

    public void setRefreshTokenMaxReuse(Integer refreshTokenMaxReuse) {
        this.updated |= !Objects.equals(this.refreshTokenMaxReuse, refreshTokenMaxReuse);
        this.refreshTokenMaxReuse = refreshTokenMaxReuse;
    }

    public Integer getSsoSessionIdleTimeout() {
        return this.ssoSessionIdleTimeout;
    }

    public void setSsoSessionIdleTimeout(Integer ssoSessionIdleTimeout) {
        this.updated |= !Objects.equals(this.ssoSessionIdleTimeout, ssoSessionIdleTimeout);
        this.ssoSessionIdleTimeout = ssoSessionIdleTimeout;
    }

    public Integer getSsoSessionMaxLifespan() {
        return this.ssoSessionMaxLifespan;
    }

    public void setSsoSessionMaxLifespan(Integer ssoSessionMaxLifespan) {
        this.updated |= !Objects.equals(this.ssoSessionMaxLifespan, ssoSessionMaxLifespan);
        this.ssoSessionMaxLifespan = ssoSessionMaxLifespan;
    }

    public Integer getSsoSessionIdleTimeoutRememberMe() {
        return this.ssoSessionIdleTimeoutRememberMe;
    }

    public void setSsoSessionIdleTimeoutRememberMe(Integer ssoSessionIdleTimeoutRememberMe) {
        this.updated |= !Objects.equals(this.ssoSessionIdleTimeoutRememberMe, ssoSessionIdleTimeoutRememberMe);
        this.ssoSessionIdleTimeoutRememberMe = ssoSessionIdleTimeoutRememberMe;
    }

    public Integer getSsoSessionMaxLifespanRememberMe() {
        return this.ssoSessionMaxLifespanRememberMe;
    }

    public void setSsoSessionMaxLifespanRememberMe(Integer ssoSessionMaxLifespanRememberMe) {
        this.updated |= !Objects.equals(this.ssoSessionMaxLifespanRememberMe, ssoSessionMaxLifespanRememberMe);
        this.ssoSessionMaxLifespanRememberMe = ssoSessionMaxLifespanRememberMe;
    }

    public Integer getOfflineSessionIdleTimeout() {
        return this.offlineSessionIdleTimeout;
    }

    public void setOfflineSessionIdleTimeout(Integer offlineSessionIdleTimeout) {
        this.updated |= !Objects.equals(this.offlineSessionIdleTimeout, offlineSessionIdleTimeout);
        this.offlineSessionIdleTimeout = offlineSessionIdleTimeout;
    }

    public Integer getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public void setAccessTokenLifespan(Integer accessTokenLifespan) {
        this.updated |= !Objects.equals(this.accessTokenLifespan, accessTokenLifespan);
        this.accessTokenLifespan = accessTokenLifespan;
    }

    public Integer getAccessTokenLifespanForImplicitFlow() {
        return this.accessTokenLifespanForImplicitFlow;
    }

    public void setAccessTokenLifespanForImplicitFlow(Integer accessTokenLifespanForImplicitFlow) {
        this.updated |= !Objects.equals(this.accessTokenLifespanForImplicitFlow, accessTokenLifespanForImplicitFlow);
        this.accessTokenLifespanForImplicitFlow = accessTokenLifespanForImplicitFlow;
    }

    public Integer getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public void setAccessCodeLifespan(Integer accessCodeLifespan) {
        this.updated |= !Objects.equals(this.accessCodeLifespan, accessCodeLifespan);
        this.accessCodeLifespan = accessCodeLifespan;
    }

    public Integer getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public void setAccessCodeLifespanUserAction(Integer accessCodeLifespanUserAction) {
        this.updated |= !Objects.equals(this.accessCodeLifespanUserAction, accessCodeLifespanUserAction);
        this.accessCodeLifespanUserAction = accessCodeLifespanUserAction;
    }

    public Integer getAccessCodeLifespanLogin() {
        return this.accessCodeLifespanLogin;
    }

    public void setAccessCodeLifespanLogin(Integer accessCodeLifespanLogin) {
        this.updated |= !Objects.equals(this.accessCodeLifespanLogin, accessCodeLifespanLogin);
        this.accessCodeLifespanLogin = accessCodeLifespanLogin;
    }

    public Integer getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Integer notBefore) {
        this.updated |= !Objects.equals(this.notBefore, notBefore);
        this.notBefore = notBefore;
    }

    public Integer getClientSessionIdleTimeout() {
        return this.clientSessionIdleTimeout;
    }

    public void setClientSessionIdleTimeout(Integer clientSessionIdleTimeout) {
        this.updated |= !Objects.equals(this.clientSessionIdleTimeout, clientSessionIdleTimeout);
        this.clientSessionIdleTimeout = clientSessionIdleTimeout;
    }

    public Integer getClientSessionMaxLifespan() {
        return this.clientSessionMaxLifespan;
    }

    public void setClientSessionMaxLifespan(Integer clientSessionMaxLifespan) {
        this.updated |= !Objects.equals(this.clientSessionMaxLifespan, clientSessionMaxLifespan);
        this.clientSessionMaxLifespan = clientSessionMaxLifespan;
    }

    public Integer getClientOfflineSessionIdleTimeout() {
        return this.clientOfflineSessionIdleTimeout;
    }

    public void setClientOfflineSessionIdleTimeout(Integer clientOfflineSessionIdleTimeout) {
        this.updated |= !Objects.equals(this.clientOfflineSessionIdleTimeout, clientOfflineSessionIdleTimeout);
        this.clientOfflineSessionIdleTimeout = clientOfflineSessionIdleTimeout;
    }

    public Integer getClientOfflineSessionMaxLifespan() {
        return this.clientOfflineSessionMaxLifespan;
    }

    public void setClientOfflineSessionMaxLifespan(Integer clientOfflineSessionMaxLifespan) {
        this.updated |= !Objects.equals(this.clientOfflineSessionMaxLifespan, clientOfflineSessionMaxLifespan);
        this.clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespan;
    }

    public Integer getActionTokenGeneratedByAdminLifespan() {
        return this.actionTokenGeneratedByAdminLifespan;
    }

    public void setActionTokenGeneratedByAdminLifespan(Integer actionTokenGeneratedByAdminLifespan) {
        this.updated |= !Objects.equals(this.actionTokenGeneratedByAdminLifespan, actionTokenGeneratedByAdminLifespan);
        this.actionTokenGeneratedByAdminLifespan = actionTokenGeneratedByAdminLifespan;
    }

    public Integer getOfflineSessionMaxLifespan() {
        return this.offlineSessionMaxLifespan;
    }

    public void setOfflineSessionMaxLifespan(Integer offlineSessionMaxLifespan) {
        this.updated |= !Objects.equals(this.offlineSessionMaxLifespan, offlineSessionMaxLifespan);
        this.offlineSessionMaxLifespan = offlineSessionMaxLifespan;
    }

    public Long getEventsExpiration() {
        return this.eventsExpiration;
    }

    public void setEventsExpiration(Long eventsExpiration) {
        this.updated |= !Objects.equals(this.eventsExpiration, eventsExpiration);
        this.eventsExpiration = eventsExpiration;
    }

    public String getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(String passwordPolicy) {
        this.updated |= !Objects.equals(this.passwordPolicy, passwordPolicy);
        this.passwordPolicy = passwordPolicy;
    }

    public String getSslRequired() {
        return this.sslRequired;
    }

    public void setSslRequired(String sslRequired) {
        this.updated |= !Objects.equals(this.sslRequired, sslRequired);
        this.sslRequired = sslRequired;
    }

    public String getLoginTheme() {
        return this.loginTheme;
    }

    public void setLoginTheme(String loginTheme) {
        this.updated |= !Objects.equals(this.loginTheme, loginTheme);
        this.loginTheme = loginTheme;
    }

    public String getAccountTheme() {
        return this.accountTheme;
    }

    public void setAccountTheme(String accountTheme) {
        this.updated |= !Objects.equals(this.accountTheme, accountTheme);
        this.accountTheme = accountTheme;
    }

    public String getAdminTheme() {
        return this.adminTheme;
    }

    public void setAdminTheme(String adminTheme) {
        this.updated |= !Objects.equals(this.adminTheme, adminTheme);
        this.adminTheme = adminTheme;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public void setEmailTheme(String emailTheme) {
        this.updated |= !Objects.equals(this.emailTheme, emailTheme);
        this.emailTheme = emailTheme;
    }

    public String getMasterAdminClient() {
        return this.masterAdminClient;
    }

    public void setMasterAdminClient(String masterAdminClient) {
        this.updated |= !Objects.equals(this.masterAdminClient, masterAdminClient);
        this.masterAdminClient = masterAdminClient;
    }

    public String getDefaultRoleId() {
        return this.defaultRoleId;
    }

    public void setDefaultRoleId(String defaultRoleId) {
        this.updated |= !Objects.equals(this.defaultRoleId, defaultRoleId);
        this.defaultRoleId = defaultRoleId;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.updated |= !Objects.equals(this.defaultLocale, defaultLocale);
        this.defaultLocale = defaultLocale;
    }

    public String getBrowserFlow() {
        return this.browserFlow;
    }

    public void setBrowserFlow(String browserFlow) {
        this.updated |= !Objects.equals(this.browserFlow, browserFlow);
        this.browserFlow = browserFlow;
    }

    public String getRegistrationFlow() {
        return this.registrationFlow;
    }

    public void setRegistrationFlow(String registrationFlow) {
        this.updated |= !Objects.equals(this.registrationFlow, registrationFlow);
        this.registrationFlow = registrationFlow;
    }

    public String getDirectGrantFlow() {
        return this.directGrantFlow;
    }

    public void setDirectGrantFlow(String directGrantFlow) {
        this.updated |= !Objects.equals(this.directGrantFlow, directGrantFlow);
        this.directGrantFlow = directGrantFlow;
    }

    public String getResetCredentialsFlow() {
        return this.resetCredentialsFlow;
    }

    public void setResetCredentialsFlow(String resetCredentialsFlow) {
        this.updated |= !Objects.equals(this.resetCredentialsFlow, resetCredentialsFlow);
        this.resetCredentialsFlow = resetCredentialsFlow;
    }

    public String getClientAuthenticationFlow() {
        return this.clientAuthenticationFlow;
    }

    public void setClientAuthenticationFlow(String clientAuthenticationFlow) {
        this.updated |= !Objects.equals(this.clientAuthenticationFlow, clientAuthenticationFlow);
        this.clientAuthenticationFlow = clientAuthenticationFlow;
    }

    public String getDockerAuthenticationFlow() {
        return this.dockerAuthenticationFlow;
    }

    public void setDockerAuthenticationFlow(String dockerAuthenticationFlow) {
        this.updated |= !Objects.equals(this.dockerAuthenticationFlow, dockerAuthenticationFlow);
        this.dockerAuthenticationFlow = dockerAuthenticationFlow;
    }

    public MapOTPPolicyEntity getOTPPolicy() {
        return this.otpPolicy;
    }

    public void setOTPPolicy(MapOTPPolicyEntity otpPolicy) {
        this.updated |= !Objects.equals(this.otpPolicy, otpPolicy);
        this.otpPolicy = otpPolicy;
    }

    public MapWebAuthnPolicyEntity getWebAuthnPolicy() {
        return this.webAuthnPolicy;
    }

    public void setWebAuthnPolicy(MapWebAuthnPolicyEntity webAuthnPolicy) {
        this.updated |= !Objects.equals(this.webAuthnPolicy, webAuthnPolicy);
        this.webAuthnPolicy = webAuthnPolicy;
    }

    public MapWebAuthnPolicyEntity getWebAuthnPolicyPasswordless() {
        return this.webAuthnPolicyPasswordless;
    }

    public void setWebAuthnPolicyPasswordless(MapWebAuthnPolicyEntity webAuthnPolicyPasswordless) {
        this.updated |= !Objects.equals(this.webAuthnPolicyPasswordless, webAuthnPolicyPasswordless);
        this.webAuthnPolicyPasswordless = webAuthnPolicyPasswordless;
    }

    public void setAttribute(String name, List<String> values) {
        this.updated |= !Objects.equals(this.attributes.put(name, values), values);
    }

    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public List<String> getAttribute(String name) {
        return this.attributes.getOrDefault(name, Collections.EMPTY_LIST);
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void addDefaultClientScope(String scopeId) {
        this.updated |= this.defaultClientScopes.add(scopeId);
    }

    public Stream<String> getDefaultClientScopeIds() {
        return this.defaultClientScopes.stream();
    }

    public void addOptionalClientScope(String scopeId) {
        this.updated |= this.optionalClientScopes.add(scopeId);
    }

    public Stream<String> getOptionalClientScopeIds() {
        return this.optionalClientScopes.stream();
    }

    public void removeDefaultOrOptionalClientScope(String scopeId) {
        if (this.defaultClientScopes.remove(scopeId)) {
            this.updated = true;
            return;
        }
        this.updated |= this.optionalClientScopes.remove(scopeId);
    }

    public Stream<String> getDefaultGroupIds() {
        return this.defaultGroupIds.stream();
    }

    public void addDefaultGroup(String groupId) {
        this.updated |= this.defaultGroupIds.add(groupId);
    }

    public void removeDefaultGroup(String groupId) {
        this.updated |= this.defaultGroupIds.remove(groupId);
    }

    public Set<String> getEventsListeners() {
        return this.eventsListeners;
    }

    public void setEventsListeners(Set<String> eventsListeners) {
        if (eventsListeners == null) {
            return;
        }
        this.updated |= !Objects.equals(eventsListeners, this.eventsListeners);
        this.eventsListeners = eventsListeners;
    }

    public Set<String> getEnabledEventTypes() {
        return this.enabledEventTypes;
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        if (enabledEventTypes == null) {
            return;
        }
        this.updated |= !Objects.equals(enabledEventTypes, this.enabledEventTypes);
        this.enabledEventTypes = enabledEventTypes;
    }

    public Set<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(Set<String> supportedLocales) {
        if (supportedLocales == null) {
            return;
        }
        this.updated |= !Objects.equals(supportedLocales, this.supportedLocales);
        this.supportedLocales = supportedLocales;
    }

    public Map<String, Map<String, String>> getLocalizationTexts() {
        return this.localizationTexts;
    }

    public Map<String, String> getLocalizationText(String locale) {
        if (this.localizationTexts.containsKey(locale)) {
            return this.localizationTexts.get(locale);
        }
        return Collections.emptyMap();
    }

    public void addLocalizationTexts(String locale, Map<String, String> texts) {
        if (!this.localizationTexts.containsKey(locale)) {
            this.updated = true;
            this.localizationTexts.put(locale, texts);
        }
    }

    public void updateLocalizationTexts(String locale, Map<String, String> texts) {
        this.updated |= this.localizationTexts.replace(locale, texts) != null;
    }

    public boolean removeLocalizationTexts(String locale) {
        boolean removed = this.localizationTexts.remove(locale) != null;
        this.updated |= removed;
        return removed;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.browserSecurityHeaders;
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        this.updated |= !Objects.equals(this.browserSecurityHeaders, headers);
        this.browserSecurityHeaders = headers;
    }

    public Map<String, String> getSmtpConfig() {
        return this.smtpConfig;
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        if (smtpConfig == null) {
            return;
        }
        this.updated |= !Objects.equals(this.smtpConfig, smtpConfig);
        this.smtpConfig = smtpConfig;
    }

    public Stream<MapRequiredCredentialEntity> getRequiredCredentials() {
        return this.requiredCredentials.values().stream();
    }

    public void addRequiredCredential(MapRequiredCredentialEntity requiredCredential) {
        if (this.requiredCredentials.containsKey(requiredCredential.getType())) {
            throw new ModelDuplicateException("An RequiredCredential with given type already exists");
        }
        this.updated = true;
        this.requiredCredentials.put(requiredCredential.getType(), requiredCredential);
    }

    public void updateRequiredCredential(MapRequiredCredentialEntity requiredCredential) {
        this.updated |= this.requiredCredentials.replace(requiredCredential.getType(), requiredCredential) != null;
    }

    public Stream<MapComponentEntity> getComponents() {
        return this.components.values().stream();
    }

    public MapComponentEntity getComponent(String id) {
        return this.components.get(id);
    }

    public void addComponent(MapComponentEntity component) {
        if (this.components.containsKey(component.getId())) {
            throw new ModelDuplicateException("A Component with given id already exists");
        }
        this.updated = true;
        this.components.put(component.getId(), component);
    }

    public void updateComponent(MapComponentEntity component) {
        this.updated |= this.components.replace(component.getId(), component) != null;
    }

    public boolean removeComponent(String id) {
        boolean removed = this.components.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public Stream<MapAuthenticationFlowEntity> getAuthenticationFlows() {
        return this.authenticationFlows.values().stream();
    }

    public MapAuthenticationFlowEntity getAuthenticationFlow(String flowId) {
        return this.authenticationFlows.get(flowId);
    }

    public void addAuthenticationFlow(MapAuthenticationFlowEntity authenticationFlow) {
        if (this.authenticationFlows.containsKey(authenticationFlow.getId())) {
            throw new ModelDuplicateException("An AuthenticationFlow with given id already exists");
        }
        this.updated = true;
        this.authenticationFlows.put(authenticationFlow.getId(), authenticationFlow);
    }

    public boolean removeAuthenticationFlow(String flowId) {
        boolean removed = this.authenticationFlows.remove(flowId) != null;
        this.updated |= removed;
        return removed;
    }

    public void updateAuthenticationFlow(MapAuthenticationFlowEntity authenticationFlow) {
        this.updated |= this.authenticationFlows.replace(authenticationFlow.getId(), authenticationFlow) != null;
    }

    public void addAuthenticatonExecution(MapAuthenticationExecutionEntity authenticationExecution) {
        if (this.authenticationExecutions.containsKey(authenticationExecution.getId())) {
            throw new ModelDuplicateException("An RequiredActionProvider with given id already exists");
        }
        this.updated = true;
        this.authenticationExecutions.put(authenticationExecution.getId(), authenticationExecution);
    }

    public void updateAuthenticatonExecution(MapAuthenticationExecutionEntity authenticationExecution) {
        this.updated |= this.authenticationExecutions.replace(authenticationExecution.getId(), authenticationExecution) != null;
    }

    public boolean removeAuthenticatonExecution(String id) {
        boolean removed = this.authenticationExecutions.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public MapAuthenticationExecutionEntity getAuthenticationExecution(String id) {
        return this.authenticationExecutions.get(id);
    }

    public Stream<MapAuthenticationExecutionEntity> getAuthenticationExecutions() {
        return this.authenticationExecutions.values().stream();
    }

    public Stream<MapAuthenticatorConfigEntity> getAuthenticatorConfigs() {
        return this.authenticatorConfigs.values().stream();
    }

    public void addAuthenticatorConfig(MapAuthenticatorConfigEntity authenticatorConfig) {
        this.updated |= !Objects.equals(this.authenticatorConfigs.put(authenticatorConfig.getId(), authenticatorConfig), authenticatorConfig);
    }

    public void updateAuthenticatorConfig(MapAuthenticatorConfigEntity authenticatorConfig) {
        this.updated |= this.authenticatorConfigs.replace(authenticatorConfig.getId(), authenticatorConfig) != null;
    }

    public boolean removeAuthenticatorConfig(String id) {
        boolean removed = this.authenticatorConfigs.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public MapAuthenticatorConfigEntity getAuthenticatorConfig(String id) {
        return this.authenticatorConfigs.get(id);
    }

    public Stream<MapRequiredActionProviderEntity> getRequiredActionProviders() {
        return this.requiredActionProviders.values().stream();
    }

    public void addRequiredActionProvider(MapRequiredActionProviderEntity requiredActionProvider) {
        if (this.requiredActionProviders.containsKey(requiredActionProvider.getId())) {
            throw new ModelDuplicateException("An RequiredActionProvider with given id already exists");
        }
        this.updated = true;
        this.requiredActionProviders.put(requiredActionProvider.getId(), requiredActionProvider);
    }

    public void updateRequiredActionProvider(MapRequiredActionProviderEntity requiredActionProvider) {
        this.updated |= this.requiredActionProviders.replace(requiredActionProvider.getId(), requiredActionProvider) != null;
    }

    public boolean removeRequiredActionProvider(String id) {
        boolean removed = this.requiredActionProviders.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public MapRequiredActionProviderEntity getRequiredActionProvider(String id) {
        return this.requiredActionProviders.get(id);
    }

    public Stream<MapIdentityProviderEntity> getIdentityProviders() {
        return this.identityProviders.values().stream();
    }

    public void addIdentityProvider(MapIdentityProviderEntity identityProvider) {
        if (this.identityProviders.containsKey(identityProvider.getId())) {
            throw new ModelDuplicateException("An IdentityProvider with given id already exists");
        }
        this.updated = true;
        this.identityProviders.put(identityProvider.getId(), identityProvider);
    }

    public boolean removeIdentityProvider(String id) {
        boolean removed = this.identityProviders.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public void updateIdentityProvider(MapIdentityProviderEntity identityProvider) {
        this.updated |= this.identityProviders.replace(identityProvider.getId(), identityProvider) != null;
    }

    public Stream<MapIdentityProviderMapperEntity> getIdentityProviderMappers() {
        return this.identityProviderMappers.values().stream();
    }

    public void addIdentityProviderMapper(MapIdentityProviderMapperEntity identityProviderMapper) {
        if (this.identityProviderMappers.containsKey(identityProviderMapper.getId())) {
            throw new ModelDuplicateException("An IdentityProviderMapper with given id already exists");
        }
        this.updated = true;
        this.identityProviderMappers.put(identityProviderMapper.getId(), identityProviderMapper);
    }

    public boolean removeIdentityProviderMapper(String id) {
        boolean removed = this.identityProviderMappers.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public void updateIdentityProviderMapper(MapIdentityProviderMapperEntity identityProviderMapper) {
        this.updated |= this.identityProviderMappers.replace(identityProviderMapper.getId(), identityProviderMapper) != null;
    }

    public MapIdentityProviderMapperEntity getIdentityProviderMapper(String id) {
        return this.identityProviderMappers.get(id);
    }

    public boolean hasClientInitialAccess() {
        return !this.clientInitialAccesses.isEmpty();
    }

    public void removeExpiredClientInitialAccesses() {
        this.clientInitialAccesses.values().stream().filter(this::checkIfExpired).map(MapClientInitialAccessEntity::getId).collect(Collectors.toSet()).forEach(this::removeClientInitialAccess);
    }

    private boolean checkIfExpired(MapClientInitialAccessEntity cia) {
        return cia.getRemainingCount() < 1 || cia.getExpiration() > 0 && cia.getTimestamp() + cia.getExpiration() < Time.currentTime();
    }

    public void addClientInitialAccess(MapClientInitialAccessEntity clientInitialAccess) {
        this.updated = true;
        this.clientInitialAccesses.put(clientInitialAccess.getId(), clientInitialAccess);
    }

    public void updateClientInitialAccess(MapClientInitialAccessEntity clientInitialAccess) {
        this.updated |= this.clientInitialAccesses.replace(clientInitialAccess.getId(), clientInitialAccess) != null;
    }

    public MapClientInitialAccessEntity getClientInitialAccess(String id) {
        return this.clientInitialAccesses.get(id);
    }

    public boolean removeClientInitialAccess(String id) {
        boolean removed = this.clientInitialAccesses.remove(id) != null;
        this.updated |= removed;
        return removed;
    }

    public Collection<MapClientInitialAccessEntity> getClientInitialAccesses() {
        return this.clientInitialAccesses.values();
    }
}

