/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.group.MapGroupEntity;

public class MapGroupEntityImpl
extends MapGroupEntity.AbstractGroupEntity
implements MapGroupEntity {
    private final DeepCloner cloner;
    private String fId;
    private Map<String, List<String>> fAttributes;
    private Set<String> fGrantedRoles;
    private String fName;
    private String fParentId;
    private String fRealmId;

    public MapGroupEntityImpl() {
        this(DeepCloner.DUMB_CLONER);
    }

    public MapGroupEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapGroupEntityImpl)) {
            return false;
        }
        MapGroupEntityImpl other = (MapGroupEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getGrantedRoles(), other.getGrantedRoles()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getParentId(), other.getParentId()) && Objects.equals(this.getRealmId(), other.getRealmId());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public void setAttributes(Map<String, List<String>> p0) {
        p0 = p0 == null ? null : (Map)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        this.updated |= !Objects.equals(this.fAttributes, p0);
        this.fAttributes = p0;
    }

    @Override
    public void setAttribute(String p0, List<String> p1) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, List<String>>();
        }
        p1 = p1 == null ? null : new LinkedList(p1);
        LinkedList v = this.fAttributes.put(p0, p1);
        this.updated |= !Objects.equals(v, p1);
    }

    @Override
    public void removeAttribute(String p0) {
        if (this.fAttributes == null) {
            return;
        }
        boolean removed = this.fAttributes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public List<String> getAttribute(String p0) {
        return this.fAttributes == null ? null : this.fAttributes.get(p0);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public Set<String> getGrantedRoles() {
        return this.fGrantedRoles;
    }

    @Override
    public void addGrantedRole(String p0) {
        if (this.fGrantedRoles == null) {
            this.fGrantedRoles = new HashSet<String>();
        }
        this.updated |= this.fGrantedRoles.add(p0);
    }

    @Override
    public void setGrantedRoles(Set<String> p0) {
        p0 = p0 == null ? null : new HashSet<String>(p0);
        this.updated |= !Objects.equals(this.fGrantedRoles, p0);
        this.fGrantedRoles = p0;
    }

    @Override
    public void removeGrantedRole(String p0) {
        if (this.fGrantedRoles == null) {
            return;
        }
        boolean removed = this.fGrantedRoles.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void setName(String p0) {
        this.updated |= !Objects.equals(this.fName, p0);
        this.fName = p0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setParentId(String p0) {
        this.updated |= !Objects.equals(this.fParentId, p0);
        this.fParentId = p0;
    }

    @Override
    public String getParentId() {
        return this.fParentId;
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }
}

