/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.tree;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public interface TreeNode<Self extends TreeNode<? extends Self>> {
    public void addChild(Self var1);

    public void addChild(int var1, Self var2);

    public Optional<Self> getChild(String var1);

    public List<Self> getChildren();

    public Map<String, Object> getEdgeProperties();

    public <V> Optional<V> getEdgeProperty(String var1, Class<V> var2);

    public String getId();

    public Map<String, Object> getNodeProperties();

    public <V> Optional<V> getNodeProperty(String var1, Class<V> var2);

    public Map<String, Object> getTreeProperties();

    public <V> Optional<V> getTreeProperty(String var1, Class<V> var2);

    public Optional<Self> removeChild(Self var1);

    public int removeChild(Predicate<Self> var1);

    public Optional<Self> getParent();

    public void setParent(Self var1);

    public Optional<Self> findFirstDfs(Predicate<Self> var1);

    public Optional<Self> findFirstBottommostDfs(Predicate<Self> var1);

    public Optional<Self> findFirstBfs(Predicate<Self> var1);

    public List<Self> getPathToRoot(PathOrientation var1);

    public static enum PathOrientation {
        BOTTOM_FIRST,
        TOP_FIRST;

    }
}

