/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.DeepCloner;

public class MapClientEntityImpl
extends MapClientEntity.AbstractClientEntity
implements MapClientEntity {
    private final DeepCloner cloner;
    private String fId;
    private Boolean fAlwaysDisplayInConsole;
    private Map<String, List<String>> fAttributes;
    private Map<String, String> fAuthenticationFlowBindingOverrides;
    private String fBaseUrl;
    private Boolean fBearerOnly;
    private String fClientAuthenticatorType;
    private String fClientId;
    private Map<String, Boolean> fClientScopes;
    private Boolean fConsentRequired;
    private String fDescription;
    private Boolean fDirectAccessGrantsEnabled;
    private Boolean fEnabled;
    private Boolean fFrontchannelLogout;
    private Boolean fFullScopeAllowed;
    private Boolean fImplicitFlowEnabled;
    private String fManagementUrl;
    private String fName;
    private Integer fNodeReRegistrationTimeout;
    private Integer fNotBefore;
    private String fProtocol;
    private Map<String, MapProtocolMapperEntity> fProtocolMappers;
    private Boolean fPublicClient;
    private String fRealmId;
    private Set<String> fRedirectUris;
    private String fRegistrationToken;
    private String fRootUrl;
    private Set<String> fScope;
    private Collection<String> fScopeMappings;
    private String fSecret;
    private Boolean fServiceAccountsEnabled;
    private Boolean fStandardFlowEnabled;
    private Boolean fSurrogateAuthRequired;
    private Set<String> fWebOrigins;

    public MapClientEntityImpl() {
        this(DeepCloner.DUMB_CLONER);
    }

    public MapClientEntityImpl(DeepCloner cloner) {
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapClientEntityImpl)) {
            return false;
        }
        MapClientEntityImpl other = (MapClientEntityImpl)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getAuthenticationFlowBindingOverrides(), other.getAuthenticationFlowBindingOverrides()) && Objects.equals(this.getBaseUrl(), other.getBaseUrl()) && Objects.equals(this.getClientAuthenticatorType(), other.getClientAuthenticatorType()) && Objects.equals(this.getClientId(), other.getClientId()) && Objects.equals(this.getClientScopes(), other.getClientScopes()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getManagementUrl(), other.getManagementUrl()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getNodeReRegistrationTimeout(), other.getNodeReRegistrationTimeout()) && Objects.equals(this.getNotBefore(), other.getNotBefore()) && Objects.equals(this.getProtocol(), other.getProtocol()) && Objects.equals(this.getProtocolMappers(), other.getProtocolMappers()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getRedirectUris(), other.getRedirectUris()) && Objects.equals(this.getRegistrationToken(), other.getRegistrationToken()) && Objects.equals(this.getRootUrl(), other.getRootUrl()) && Objects.equals(this.getScope(), other.getScope()) && Objects.equals(this.getScopeMappings(), other.getScopeMappings()) && Objects.equals(this.getSecret(), other.getSecret()) && Objects.equals(this.getWebOrigins(), other.getWebOrigins()) && Objects.equals(this.isAlwaysDisplayInConsole(), other.isAlwaysDisplayInConsole()) && Objects.equals(this.isBearerOnly(), other.isBearerOnly()) && Objects.equals(this.isConsentRequired(), other.isConsentRequired()) && Objects.equals(this.isDirectAccessGrantsEnabled(), other.isDirectAccessGrantsEnabled()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.isFrontchannelLogout(), other.isFrontchannelLogout()) && Objects.equals(this.isFullScopeAllowed(), other.isFullScopeAllowed()) && Objects.equals(this.isImplicitFlowEnabled(), other.isImplicitFlowEnabled()) && Objects.equals(this.isPublicClient(), other.isPublicClient()) && Objects.equals(this.isServiceAccountsEnabled(), other.isServiceAccountsEnabled()) && Objects.equals(this.isStandardFlowEnabled(), other.isStandardFlowEnabled()) && Objects.equals(this.isSurrogateAuthRequired(), other.isSurrogateAuthRequired());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public <V> V deepClone(V obj) {
        return this.cloner.from(obj);
    }

    @Override
    public Boolean isAlwaysDisplayInConsole() {
        return this.fAlwaysDisplayInConsole;
    }

    @Override
    public void setAlwaysDisplayInConsole(Boolean p0) {
        this.updated |= !Objects.equals(this.fAlwaysDisplayInConsole, p0);
        this.fAlwaysDisplayInConsole = p0;
    }

    @Override
    public List<String> getAttribute(String p0) {
        return this.fAttributes == null ? null : this.fAttributes.get(p0);
    }

    @Override
    public void removeAttribute(String p0) {
        if (this.fAttributes == null) {
            return;
        }
        boolean removed = this.fAttributes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public void setAttributes(Map<String, List<String>> p0) {
        p0 = p0 == null ? null : (Map)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        this.updated |= !Objects.equals(this.fAttributes, p0);
        this.fAttributes = p0;
    }

    @Override
    public void setAttribute(String p0, List<String> p1) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, List<String>>();
        }
        p1 = p1 == null ? null : new LinkedList(p1);
        LinkedList v = this.fAttributes.put(p0, p1);
        this.updated |= !Objects.equals(v, p1);
    }

    @Override
    public void setAuthenticationFlowBindingOverride(String p0, String p1) {
        String v;
        if (this.fAuthenticationFlowBindingOverrides == null) {
            this.fAuthenticationFlowBindingOverrides = new HashMap<String, String>();
        }
        this.updated |= !Objects.equals(v = this.fAuthenticationFlowBindingOverrides.put(p0, p1), p1);
    }

    @Override
    public void removeAuthenticationFlowBindingOverride(String p0) {
        if (this.fAuthenticationFlowBindingOverrides == null) {
            return;
        }
        boolean removed = this.fAuthenticationFlowBindingOverrides.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.fAuthenticationFlowBindingOverrides;
    }

    @Override
    public String getAuthenticationFlowBindingOverride(String p0) {
        return this.fAuthenticationFlowBindingOverrides == null ? null : this.fAuthenticationFlowBindingOverrides.get(p0);
    }

    @Override
    public String getBaseUrl() {
        return this.fBaseUrl;
    }

    @Override
    public void setBaseUrl(String p0) {
        this.updated |= !Objects.equals(this.fBaseUrl, p0);
        this.fBaseUrl = p0;
    }

    @Override
    public Boolean isBearerOnly() {
        return this.fBearerOnly;
    }

    @Override
    public void setBearerOnly(Boolean p0) {
        this.updated |= !Objects.equals(this.fBearerOnly, p0);
        this.fBearerOnly = p0;
    }

    @Override
    public void setClientAuthenticatorType(String p0) {
        this.updated |= !Objects.equals(this.fClientAuthenticatorType, p0);
        this.fClientAuthenticatorType = p0;
    }

    @Override
    public String getClientAuthenticatorType() {
        return this.fClientAuthenticatorType;
    }

    @Override
    public String getClientId() {
        return this.fClientId;
    }

    @Override
    public void setClientId(String p0) {
        this.updated |= !Objects.equals(this.fClientId, p0);
        this.fClientId = p0;
    }

    @Override
    public void removeClientScope(String p0) {
        if (this.fClientScopes == null) {
            return;
        }
        boolean removed = this.fClientScopes.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public void setClientScope(String p0, Boolean p1) {
        Boolean v;
        if (this.fClientScopes == null) {
            this.fClientScopes = new HashMap<String, Boolean>();
        }
        this.updated |= !Objects.equals(v = this.fClientScopes.put(p0, p1), p1);
    }

    @Override
    public Map<String, Boolean> getClientScopes() {
        return this.fClientScopes;
    }

    @Override
    public Boolean isConsentRequired() {
        return this.fConsentRequired;
    }

    @Override
    public void setConsentRequired(Boolean p0) {
        this.updated |= !Objects.equals(this.fConsentRequired, p0);
        this.fConsentRequired = p0;
    }

    @Override
    public void setDescription(String p0) {
        this.updated |= !Objects.equals(this.fDescription, p0);
        this.fDescription = p0;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setDirectAccessGrantsEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fDirectAccessGrantsEnabled, p0);
        this.fDirectAccessGrantsEnabled = p0;
    }

    @Override
    public Boolean isDirectAccessGrantsEnabled() {
        return this.fDirectAccessGrantsEnabled;
    }

    @Override
    public void setEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fEnabled, p0);
        this.fEnabled = p0;
    }

    @Override
    public Boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setFrontchannelLogout(Boolean p0) {
        this.updated |= !Objects.equals(this.fFrontchannelLogout, p0);
        this.fFrontchannelLogout = p0;
    }

    @Override
    public Boolean isFrontchannelLogout() {
        return this.fFrontchannelLogout;
    }

    @Override
    public Boolean isFullScopeAllowed() {
        return this.fFullScopeAllowed;
    }

    @Override
    public void setFullScopeAllowed(Boolean p0) {
        this.updated |= !Objects.equals(this.fFullScopeAllowed, p0);
        this.fFullScopeAllowed = p0;
    }

    @Override
    public void setImplicitFlowEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fImplicitFlowEnabled, p0);
        this.fImplicitFlowEnabled = p0;
    }

    @Override
    public Boolean isImplicitFlowEnabled() {
        return this.fImplicitFlowEnabled;
    }

    @Override
    public void setManagementUrl(String p0) {
        this.updated |= !Objects.equals(this.fManagementUrl, p0);
        this.fManagementUrl = p0;
    }

    @Override
    public String getManagementUrl() {
        return this.fManagementUrl;
    }

    @Override
    public void setName(String p0) {
        this.updated |= !Objects.equals(this.fName, p0);
        this.fName = p0;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Integer getNodeReRegistrationTimeout() {
        return this.fNodeReRegistrationTimeout;
    }

    @Override
    public void setNodeReRegistrationTimeout(Integer p0) {
        this.updated |= !Objects.equals(this.fNodeReRegistrationTimeout, p0);
        this.fNodeReRegistrationTimeout = p0;
    }

    @Override
    public void setNotBefore(Integer p0) {
        this.updated |= !Objects.equals(this.fNotBefore, p0);
        this.fNotBefore = p0;
    }

    @Override
    public Integer getNotBefore() {
        return this.fNotBefore;
    }

    @Override
    public String getProtocol() {
        return this.fProtocol;
    }

    @Override
    public void setProtocol(String p0) {
        this.updated |= !Objects.equals(this.fProtocol, p0);
        this.fProtocol = p0;
    }

    @Override
    public Map<String, MapProtocolMapperEntity> getProtocolMappers() {
        return this.fProtocolMappers;
    }

    @Override
    public void removeProtocolMapper(String p0) {
        if (this.fProtocolMappers == null) {
            return;
        }
        boolean removed = this.fProtocolMappers.remove(p0) != null;
        this.updated |= removed;
    }

    @Override
    public MapProtocolMapperEntity getProtocolMapper(String p0) {
        return this.fProtocolMappers == null ? null : this.fProtocolMappers.get(p0);
    }

    @Override
    public void setProtocolMapper(String p0, MapProtocolMapperEntity p1) {
        MapProtocolMapperEntity v;
        if (this.fProtocolMappers == null) {
            this.fProtocolMappers = new HashMap<String, MapProtocolMapperEntity>();
        }
        this.updated |= !Objects.equals(v = this.fProtocolMappers.put(p0, p1 = this.deepClone(p1)), p1);
    }

    @Override
    public Boolean isPublicClient() {
        return this.fPublicClient;
    }

    @Override
    public void setPublicClient(Boolean p0) {
        this.updated |= !Objects.equals(this.fPublicClient, p0);
        this.fPublicClient = p0;
    }

    @Override
    public void setRealmId(String p0) {
        this.updated |= !Objects.equals(this.fRealmId, p0);
        this.fRealmId = p0;
    }

    @Override
    public String getRealmId() {
        return this.fRealmId;
    }

    @Override
    public void setRedirectUris(Set<String> p0) {
        p0 = p0 == null ? null : new HashSet<String>(p0);
        this.updated |= !Objects.equals(this.fRedirectUris, p0);
        this.fRedirectUris = p0;
    }

    @Override
    public Set<String> getRedirectUris() {
        return this.fRedirectUris;
    }

    @Override
    public void addRedirectUri(String p0) {
        if (this.fRedirectUris == null) {
            this.fRedirectUris = new HashSet<String>();
        }
        this.updated |= this.fRedirectUris.add(p0);
    }

    @Override
    public void removeRedirectUri(String p0) {
        if (this.fRedirectUris == null) {
            return;
        }
        boolean removed = this.fRedirectUris.remove(p0);
        this.updated |= removed;
    }

    @Override
    public String getRegistrationToken() {
        return this.fRegistrationToken;
    }

    @Override
    public void setRegistrationToken(String p0) {
        this.updated |= !Objects.equals(this.fRegistrationToken, p0);
        this.fRegistrationToken = p0;
    }

    @Override
    public String getRootUrl() {
        return this.fRootUrl;
    }

    @Override
    public void setRootUrl(String p0) {
        this.updated |= !Objects.equals(this.fRootUrl, p0);
        this.fRootUrl = p0;
    }

    @Override
    public void setScope(Set<String> p0) {
        p0 = p0 == null ? null : new HashSet<String>(p0);
        this.updated |= !Objects.equals(this.fScope, p0);
        this.fScope = p0;
    }

    @Override
    public Set<String> getScope() {
        return this.fScope;
    }

    @Override
    public Collection<String> getScopeMappings() {
        return this.fScopeMappings;
    }

    @Override
    public void removeScopeMapping(String p0) {
        if (this.fScopeMappings == null) {
            return;
        }
        boolean removed = this.fScopeMappings.remove(p0);
        this.updated |= removed;
    }

    @Override
    public void addScopeMapping(String p0) {
        if (this.fScopeMappings == null) {
            this.fScopeMappings = new LinkedList<String>();
        }
        this.fScopeMappings.add(p0);
        this.updated = true;
    }

    @Override
    public void setSecret(String p0) {
        this.updated |= !Objects.equals(this.fSecret, p0);
        this.fSecret = p0;
    }

    @Override
    public String getSecret() {
        return this.fSecret;
    }

    @Override
    public void setServiceAccountsEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fServiceAccountsEnabled, p0);
        this.fServiceAccountsEnabled = p0;
    }

    @Override
    public Boolean isServiceAccountsEnabled() {
        return this.fServiceAccountsEnabled;
    }

    @Override
    public Boolean isStandardFlowEnabled() {
        return this.fStandardFlowEnabled;
    }

    @Override
    public void setStandardFlowEnabled(Boolean p0) {
        this.updated |= !Objects.equals(this.fStandardFlowEnabled, p0);
        this.fStandardFlowEnabled = p0;
    }

    @Override
    public Boolean isSurrogateAuthRequired() {
        return this.fSurrogateAuthRequired;
    }

    @Override
    public void setSurrogateAuthRequired(Boolean p0) {
        this.updated |= !Objects.equals(this.fSurrogateAuthRequired, p0);
        this.fSurrogateAuthRequired = p0;
    }

    @Override
    public void removeWebOrigin(String p0) {
        if (this.fWebOrigins == null) {
            return;
        }
        boolean removed = this.fWebOrigins.remove(p0);
        this.updated |= removed;
    }

    @Override
    public Set<String> getWebOrigins() {
        return this.fWebOrigins;
    }

    @Override
    public void setWebOrigins(Set<String> p0) {
        p0 = p0 == null ? null : new HashSet<String>(p0);
        this.updated |= !Objects.equals(this.fWebOrigins, p0);
        this.fWebOrigins = p0;
    }

    @Override
    public void addWebOrigin(String p0) {
        if (this.fWebOrigins == null) {
            this.fWebOrigins = new HashSet<String>();
        }
        this.updated |= this.fWebOrigins.add(p0);
    }

    public static class Empty
    extends MapClientEntity.AbstractClientEntity
    implements MapClientEntity {
        public static final Empty INSTANCE = new Empty();

        @Override
        public void setId(String id) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public Boolean isAlwaysDisplayInConsole() {
            return null;
        }

        @Override
        public void setAlwaysDisplayInConsole(Boolean alwaysDisplayInConsole) {
        }

        @Override
        public List<String> getAttribute(String name) {
            return null;
        }

        @Override
        public void removeAttribute(String name) {
        }

        @Override
        public Map<String, List<String>> getAttributes() {
            return null;
        }

        @Override
        public void setAttributes(Map<String, List<String>> attributes) {
        }

        @Override
        public void setAttribute(String name, List<String> value) {
        }

        @Override
        public void setAuthenticationFlowBindingOverride(String binding, String flowId) {
        }

        @Override
        public void removeAuthenticationFlowBindingOverride(String binding) {
        }

        @Override
        public Map<String, String> getAuthenticationFlowBindingOverrides() {
            return null;
        }

        @Override
        public String getAuthenticationFlowBindingOverride(String binding) {
            return null;
        }

        @Override
        public String getBaseUrl() {
            return null;
        }

        @Override
        public void setBaseUrl(String baseUrl) {
        }

        @Override
        public Boolean isBearerOnly() {
            return null;
        }

        @Override
        public void setBearerOnly(Boolean bearerOnly) {
        }

        @Override
        public void setClientAuthenticatorType(String clientAuthenticatorType) {
        }

        @Override
        public String getClientAuthenticatorType() {
            return null;
        }

        @Override
        public String getClientId() {
            return null;
        }

        @Override
        public void setClientId(String clientId) {
        }

        @Override
        public void removeClientScope(String id) {
        }

        @Override
        public Stream<String> getClientScopes(boolean defaultScope) {
            return null;
        }

        @Override
        public void setClientScope(String id, Boolean defaultScope) {
        }

        @Override
        public Map<String, Boolean> getClientScopes() {
            return null;
        }

        @Override
        public Boolean isConsentRequired() {
            return null;
        }

        @Override
        public void setConsentRequired(Boolean consentRequired) {
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDirectAccessGrantsEnabled(Boolean directAccessGrantsEnabled) {
        }

        @Override
        public Boolean isDirectAccessGrantsEnabled() {
            return null;
        }

        @Override
        public void setEnabled(Boolean enabled) {
        }

        @Override
        public Boolean isEnabled() {
            return null;
        }

        @Override
        public void setFrontchannelLogout(Boolean frontchannelLogout) {
        }

        @Override
        public Boolean isFrontchannelLogout() {
            return null;
        }

        @Override
        public Boolean isFullScopeAllowed() {
            return null;
        }

        @Override
        public void setFullScopeAllowed(Boolean fullScopeAllowed) {
        }

        @Override
        public void setImplicitFlowEnabled(Boolean implicitFlowEnabled) {
        }

        @Override
        public Boolean isImplicitFlowEnabled() {
            return null;
        }

        @Override
        public void setManagementUrl(String managementUrl) {
        }

        @Override
        public String getManagementUrl() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Integer getNodeReRegistrationTimeout() {
            return null;
        }

        @Override
        public void setNodeReRegistrationTimeout(Integer nodeReRegistrationTimeout) {
        }

        @Override
        public void setNotBefore(Integer notBefore) {
        }

        @Override
        public Integer getNotBefore() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public void setProtocol(String protocol) {
        }

        @Override
        public Map<String, MapProtocolMapperEntity> getProtocolMappers() {
            return null;
        }

        @Override
        public void removeProtocolMapper(String id) {
        }

        @Override
        public MapProtocolMapperEntity getProtocolMapper(String id) {
            return null;
        }

        @Override
        public void setProtocolMapper(String id, MapProtocolMapperEntity mapping) {
        }

        @Override
        public Boolean isPublicClient() {
            return null;
        }

        @Override
        public void setPublicClient(Boolean publicClient) {
        }

        @Override
        public void setRealmId(String realmId) {
        }

        @Override
        public String getRealmId() {
            return null;
        }

        @Override
        public void setRedirectUris(Set<String> redirectUris) {
        }

        @Override
        public Set<String> getRedirectUris() {
            return null;
        }

        @Override
        public void addRedirectUri(String redirectUri) {
        }

        @Override
        public void removeRedirectUri(String redirectUri) {
        }

        @Override
        public String getRegistrationToken() {
            return null;
        }

        @Override
        public void setRegistrationToken(String registrationToken) {
        }

        @Override
        public String getRootUrl() {
            return null;
        }

        @Override
        public void setRootUrl(String rootUrl) {
        }

        @Override
        public void setScope(Set<String> scope) {
        }

        @Override
        public Set<String> getScope() {
            return null;
        }

        @Override
        public Collection<String> getScopeMappings() {
            return null;
        }

        @Override
        public void removeScopeMapping(String id) {
        }

        @Override
        public void addScopeMapping(String id) {
        }

        @Override
        public void setSecret(String secret) {
        }

        @Override
        public String getSecret() {
            return null;
        }

        @Override
        public void setServiceAccountsEnabled(Boolean serviceAccountsEnabled) {
        }

        @Override
        public Boolean isServiceAccountsEnabled() {
            return null;
        }

        @Override
        public Boolean isStandardFlowEnabled() {
            return null;
        }

        @Override
        public void setStandardFlowEnabled(Boolean standardFlowEnabled) {
        }

        @Override
        public Boolean isSurrogateAuthRequired() {
            return null;
        }

        @Override
        public void setSurrogateAuthRequired(Boolean surrogateAuthRequired) {
        }

        @Override
        public void removeWebOrigin(String webOrigin) {
        }

        @Override
        public Set<String> getWebOrigins() {
            return null;
        }

        @Override
        public void setWebOrigins(Set<String> webOrigins) {
        }

        @Override
        public void addWebOrigin(String webOrigin) {
        }

        @Override
        public boolean isUpdated() {
            return false;
        }
    }
}

