/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.ApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;

public class ApplicationAdapter
extends AbstractAdapter
implements ApplicationModel {
    private final ApplicationEntity application;
    private UserAdapter resourceUser;

    public ApplicationAdapter(ApplicationEntity applicationEntity, MongoStoreInvocationContext invContext) {
        this(applicationEntity, null, invContext);
    }

    public ApplicationAdapter(ApplicationEntity applicationEntity, UserAdapter resourceUser, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.application = applicationEntity;
        this.resourceUser = resourceUser;
    }

    public void updateApplication() {
        this.getMongoStore().updateEntity(this.application, this.invocationContext);
    }

    public UserAdapter getApplicationUser() {
        if (this.resourceUser == null) {
            UserEntity userEntity = this.getMongoStore().loadEntity(UserEntity.class, this.application.getResourceUserId(), this.invocationContext);
            if (userEntity == null) {
                throw new IllegalStateException("User " + this.application.getResourceUserId() + " not found");
            }
            this.resourceUser = new UserAdapter(userEntity, this.invocationContext);
        }
        return this.resourceUser;
    }

    public String getId() {
        return this.application.getId();
    }

    public String getName() {
        return this.application.getName();
    }

    public void setName(String name) {
        this.application.setName(name);
    }

    public boolean isEnabled() {
        return this.application.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.application.setEnabled(enabled);
    }

    public boolean isSurrogateAuthRequired() {
        return this.application.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.application.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.application.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.application.setManagementUrl(url);
    }

    public void setBaseUrl(String url) {
        this.application.setBaseUrl(url);
    }

    public String getBaseUrl() {
        return this.application.getBaseUrl();
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("applicationId").is((Object)this.getId()).get();
        RoleEntity role = this.getMongoStore().loadSingleEntity(RoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(role, this.invocationContext);
    }

    public RoleModel getRoleById(String id) {
        RoleEntity role = this.getMongoStore().loadEntity(RoleEntity.class, id, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext);
    }

    public RoleAdapter addRole(String name) {
        RoleAdapter existing = this.getRole(name);
        if (existing != null) {
            return existing;
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setName(name);
        roleEntity.setApplicationId(this.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRoleById(String id) {
        return this.getMongoStore().removeEntity(RoleEntity.class, id, this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("applicationId").is((Object)this.getId()).get();
        List<RoleEntity> roles = this.getMongoStore().loadEntities(RoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (RoleEntity role : roles) {
            result.add(new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getApplicationRoleMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleEntity> roles = MongoModelUtils.getAllRolesOfUser(user, this.invocationContext);
        for (RoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public void addScope(RoleModel role) {
        UserAdapter appUser = this.getApplicationUser();
        this.getMongoStore().pushItemToList(appUser.getUser(), "scopeIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getApplicationScopeMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleEntity> roles = MongoModelUtils.getAllScopesOfUser(user, this.invocationContext);
        for (RoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public List<String> getDefaultRoles() {
        return this.application.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList(this.application, "defaultRoles", name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.application.setDefaultRoles(roleNames);
    }

    @Override
    public AbstractMongoIdentifiableEntity getMongoEntity() {
        return this.application;
    }
}

