/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.utils;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.List;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;

public class MongoModelUtils {
    public static List<RoleEntity> getAllRolesOfUser(UserModel user, MongoStoreInvocationContext invContext) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        List<String> roleIds = userEntity.getRoleIds();
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DBObject query = new QueryBuilder().and("_id").in(roleIds).get();
        return invContext.getMongoStore().loadEntities(RoleEntity.class, query, invContext);
    }

    public static List<RoleEntity> getAllScopesOfUser(UserModel user, MongoStoreInvocationContext invContext) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        List<String> scopeIds = userEntity.getScopeIds();
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        DBObject query = new QueryBuilder().and("_id").in(scopeIds).get();
        return invContext.getMongoStore().loadEntities(RoleEntity.class, query, invContext);
    }
}

