/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.ApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;

public class ApplicationAdapter
extends ClientAdapter<ApplicationEntity>
implements ApplicationModel {
    public ApplicationAdapter(RealmModel realm, ApplicationEntity applicationEntity, MongoStoreInvocationContext invContext) {
        super(realm, applicationEntity, invContext);
    }

    public void updateApplication() {
        this.updateMongoEntity();
    }

    public String getName() {
        return ((ApplicationEntity)this.getMongoEntity()).getName();
    }

    public void setName(String name) {
        ((ApplicationEntity)this.getMongoEntity()).setName(name);
        this.updateMongoEntity();
    }

    public boolean isSurrogateAuthRequired() {
        return ((ApplicationEntity)this.getMongoEntity()).isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        ((ApplicationEntity)this.getMongoEntity()).setSurrogateAuthRequired(surrogateAuthRequired);
        this.updateMongoEntity();
    }

    public String getManagementUrl() {
        return ((ApplicationEntity)this.getMongoEntity()).getManagementUrl();
    }

    public void setManagementUrl(String url) {
        ((ApplicationEntity)this.getMongoEntity()).setManagementUrl(url);
        this.updateMongoEntity();
    }

    public void setBaseUrl(String url) {
        ((ApplicationEntity)this.getMongoEntity()).setBaseUrl(url);
        this.updateMongoEntity();
    }

    public String getBaseUrl() {
        return ((ApplicationEntity)this.getMongoEntity()).getBaseUrl();
    }

    public boolean isBearerOnly() {
        return ((ApplicationEntity)this.getMongoEntity()).isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        ((ApplicationEntity)this.getMongoEntity()).setBearerOnly(only);
        this.updateMongoEntity();
    }

    @Override
    public boolean isPublicClient() {
        return ((ApplicationEntity)this.getMongoEntity()).isPublicClient();
    }

    @Override
    public void setPublicClient(boolean flag) {
        ((ApplicationEntity)this.getMongoEntity()).setPublicClient(flag);
        this.updateMongoEntity();
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("applicationId").is((Object)this.getId()).get();
        RoleEntity role = this.getMongoStore().loadSingleEntity(RoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this.getRealm(), role, this.invocationContext);
    }

    public RoleAdapter addRole(String name) {
        RoleAdapter existing = this.getRole(name);
        if (existing != null) {
            return existing;
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setName(name);
        roleEntity.setApplicationId(this.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(this.getRealm(), roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        return this.getMongoStore().removeEntity(RoleEntity.class, role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("applicationId").is((Object)this.getId()).get();
        List<RoleEntity> roles = this.getMongoStore().loadEntities(RoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (RoleEntity role : roles) {
            result.add(new RoleAdapter(this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getApplicationRoleMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleEntity> roles = MongoModelUtils.getAllRolesOfUser(user, this.invocationContext);
        for (RoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public void addScope(RoleModel role) {
        this.getMongoStore().pushItemToList(this.getMongoEntity(), "scopeIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getApplicationScopeMappings(ClientModel client) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleEntity> roles = MongoModelUtils.getAllScopesOfClient(client, this.invocationContext);
        for (RoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public List<String> getDefaultRoles() {
        return ((ApplicationEntity)this.getMongoEntity()).getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList(this.getMongoEntity(), "defaultRoles", name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        ((ApplicationEntity)this.getMongoEntity()).setDefaultRoles(roleNames);
        this.updateMongoEntity();
    }
}

