/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;

public class ApplicationAdapter
extends ClientAdapter<MongoApplicationEntity>
implements ApplicationModel {
    public ApplicationAdapter(RealmAdapter realm, MongoApplicationEntity applicationEntity, MongoStoreInvocationContext invContext) {
        super(realm, applicationEntity, invContext);
    }

    public void updateApplication() {
        this.updateMongoEntity();
    }

    public String getName() {
        return ((MongoApplicationEntity)this.getMongoEntity()).getName();
    }

    public void setName(String name) {
        ((MongoApplicationEntity)this.getMongoEntity()).setName(name);
        this.updateMongoEntity();
    }

    public boolean isSurrogateAuthRequired() {
        return ((MongoApplicationEntity)this.getMongoEntity()).isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        ((MongoApplicationEntity)this.getMongoEntity()).setSurrogateAuthRequired(surrogateAuthRequired);
        this.updateMongoEntity();
    }

    public String getManagementUrl() {
        return ((MongoApplicationEntity)this.getMongoEntity()).getManagementUrl();
    }

    public void setManagementUrl(String url) {
        ((MongoApplicationEntity)this.getMongoEntity()).setManagementUrl(url);
        this.updateMongoEntity();
    }

    public void setBaseUrl(String url) {
        ((MongoApplicationEntity)this.getMongoEntity()).setBaseUrl(url);
        this.updateMongoEntity();
    }

    public String getBaseUrl() {
        return ((MongoApplicationEntity)this.getMongoEntity()).getBaseUrl();
    }

    public boolean isBearerOnly() {
        return ((MongoApplicationEntity)this.getMongoEntity()).isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        ((MongoApplicationEntity)this.getMongoEntity()).setBearerOnly(only);
        this.updateMongoEntity();
    }

    @Override
    public boolean isPublicClient() {
        return ((MongoApplicationEntity)this.getMongoEntity()).isPublicClient();
    }

    @Override
    public void setPublicClient(boolean flag) {
        ((MongoApplicationEntity)this.getMongoEntity()).setPublicClient(flag);
        this.updateMongoEntity();
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("applicationId").is((Object)this.getId()).get();
        MongoRoleEntity role = this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this.getRealm(), role, this.invocationContext);
    }

    public RoleAdapter addRole(String name) {
        return this.addRole(null, name);
    }

    public RoleAdapter addRole(String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setApplicationId(this.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(this.getRealm(), roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("applicationId").is((Object)this.getId()).get();
        List<MongoRoleEntity> roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getApplicationRoleMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllRolesOfUser(user, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getApplicationScopeMappings(ClientModel client) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(client, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public List<String> getDefaultRoles() {
        return ((MongoApplicationEntity)this.getMongoEntity()).getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getMongoEntity(), "defaultRoles", name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        ((MongoApplicationEntity)this.getMongoEntity()).setDefaultRoles(roleNames);
        this.updateMongoEntity();
    }
}

