/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserSessionAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserSessionEntity;

public class ClientAdapter<T extends MongoIdentifiableEntity>
extends AbstractMongoAdapter<T>
implements ClientModel {
    protected final T clientEntity;
    private final RealmAdapter realm;

    public ClientAdapter(RealmAdapter realm, T clientEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.clientEntity = clientEntity;
        this.realm = realm;
    }

    @Override
    public T getMongoEntity() {
        return this.clientEntity;
    }

    public ClientEntity getMongoEntityAsClient() {
        return (ClientEntity)this.getMongoEntity();
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getClientId() {
        return this.getMongoEntityAsClient().getName();
    }

    public long getAllowedClaimsMask() {
        return this.getMongoEntityAsClient().getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        this.getMongoEntityAsClient().setAllowedClaimsMask(mask);
        this.updateMongoEntity();
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntityAsClient().getWebOrigins() != null) {
            result.addAll(this.getMongoEntityAsClient().getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.getMongoEntityAsClient().setWebOrigins(result);
        this.updateMongoEntity();
    }

    public void addWebOrigin(String webOrigin) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.clientEntity, "webOrigins", webOrigin, true, this.invocationContext);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.clientEntity, "webOrigins", webOrigin, this.invocationContext);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntityAsClient().getRedirectUris() != null) {
            result.addAll(this.getMongoEntityAsClient().getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.getMongoEntityAsClient().setRedirectUris(result);
        this.updateMongoEntity();
    }

    public void addRedirectUri(String redirectUri) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.clientEntity, "redirectUris", redirectUri, true, this.invocationContext);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.clientEntity, "redirectUris", redirectUri, this.invocationContext);
    }

    public boolean isEnabled() {
        return this.getMongoEntityAsClient().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getMongoEntityAsClient().setEnabled(enabled);
        this.updateMongoEntity();
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.getMongoEntityAsClient().getSecret());
    }

    public String getSecret() {
        return this.getMongoEntityAsClient().getSecret();
    }

    public void setSecret(String secret) {
        this.getMongoEntityAsClient().setSecret(secret);
        this.updateMongoEntity();
    }

    public boolean isPublicClient() {
        return this.getMongoEntityAsClient().isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getMongoEntityAsClient().setPublicClient(flag);
        this.updateMongoEntity();
    }

    public RealmAdapter getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return this.getMongoEntityAsClient().getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getMongoEntityAsClient().setNotBefore(notBefore);
        this.updateMongoEntity();
    }

    public Set<UserSessionModel> getUserSessions() {
        DBObject query = new QueryBuilder().and("associatedClientIds").is((Object)this.getId()).get();
        List<MongoUserSessionEntity> sessions = this.getMongoStore().loadEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        HashSet<UserSessionModel> result = new HashSet<UserSessionModel>();
        for (MongoUserSessionEntity session : sessions) {
            result.add(new UserSessionAdapter(session, this.realm, this.invocationContext));
        }
        return result;
    }

    public int getActiveUserSessions() {
        return this.getUserSessions().size();
    }
}

