/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import org.keycloak.models.entities.OAuthClientEntity;
import org.keycloak.models.mongo.api.MongoCollection;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.MongoIndex;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.entities.MongoUserSessionEntity;

@MongoCollection(collectionName="oauthClients")
@MongoIndex(fields={"realmId", "name"}, unique=true)
public class MongoOAuthClientEntity
extends OAuthClientEntity
implements MongoIdentifiableEntity {
    @Override
    public void afterRemove(MongoStoreInvocationContext context) {
        DBObject query = new QueryBuilder().and("associatedClientIds").is((Object)this.getId()).get();
        List<MongoUserSessionEntity> sessions = context.getMongoStore().loadEntities(MongoUserSessionEntity.class, query, context);
        for (MongoUserSessionEntity session : sessions) {
            context.getMongoStore().pullItemFromList(session, "associatedClientIds", this.getId(), context);
        }
    }
}

