/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.UserFederationProviderEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ApplicationAdapter;
import org.keycloak.models.mongo.keycloak.adapters.OAuthClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoOAuthClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RealmAdapter
extends AbstractMongoAdapter<MongoRealmEntity>
implements RealmModel {
    private static final Logger logger = Logger.getLogger(RealmAdapter.class);
    private final MongoRealmEntity realm;
    private final RealmProvider model;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    private volatile transient PasswordPolicy passwordPolicy;
    private volatile transient KeycloakSession session;

    public RealmAdapter(KeycloakSession session, MongoRealmEntity realmEntity, MongoStoreInvocationContext invocationContext) {
        super(invocationContext);
        this.realm = realmEntity;
        this.session = session;
        this.model = session.realms();
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.updateRealm();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.updateRealm();
    }

    public SslRequired getSslRequired() {
        return SslRequired.valueOf((String)this.realm.getSslRequired());
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.updateRealm();
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.realm.isPasswordCredentialGrantAllowed();
    }

    public void setPasswordCredentialGrantAllowed(boolean passwordCredentialGrantAllowed) {
        this.realm.setPasswordCredentialGrantAllowed(passwordCredentialGrantAllowed);
        this.updateRealm();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.updateRealm();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.updateRealm();
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
        this.updateRealm();
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
        this.updateRealm();
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
        this.updateRealm();
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
        this.updateRealm();
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
        this.updateRealm();
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
        this.updateRealm();
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
        this.updateRealm();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.updateRealm();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
        this.updateRealm();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.updateRealm();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.updateRealm();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.updateRealm();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
        this.updateRealm();
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
        this.updateRealm();
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
        this.updateRealm();
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.updateRealm();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
        this.updateRealm();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
        this.updateRealm();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.updateRealm();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.updateRealm();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.updateRealm();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.updateRealm();
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("realmId").is((Object)this.getId()).get();
        MongoRoleEntity role = (MongoRoleEntity)this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this.session, this, role, (RoleContainerModel)this, this.invocationContext);
    }

    public RoleModel addRole(String name) {
        return this.addRole(null, name);
    }

    public RoleModel addRole(String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)roleEntity, this.invocationContext);
        return new RoleAdapter(this.session, this, roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        return this.removeRoleById(role.getId());
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        this.session.users().preRemove((RealmModel)this, role);
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, id, this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        if (roles == null) {
            return result;
        }
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this.session, this, role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public RoleModel getRoleById(String id) {
        return this.model.getRoleById(id, (RealmModel)this);
    }

    public List<String> getDefaultRoles() {
        return this.realm.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.realm, "defaultRoles", (Object)name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
        this.updateRealm();
    }

    public ClientModel findClient(String clientId) {
        ApplicationModel model = this.getApplicationByName(clientId);
        if (model != null) {
            return model;
        }
        return this.getOAuthClient(clientId);
    }

    public ClientModel findClientById(String id) {
        ApplicationModel model = this.getApplicationById(id);
        if (model != null) {
            return model;
        }
        return this.getOAuthClientById(id);
    }

    public ApplicationModel getApplicationById(String id) {
        return this.model.getApplicationById(id, (RealmModel)this);
    }

    public ApplicationModel getApplicationByName(String name) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("name").is((Object)name).get();
        MongoApplicationEntity appEntity = (MongoApplicationEntity)this.getMongoStore().loadSingleEntity(MongoApplicationEntity.class, query, this.invocationContext);
        return appEntity == null ? null : new ApplicationAdapter(this.session, (RealmModel)this, appEntity, this.invocationContext);
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> resourceMap = new HashMap<String, ApplicationModel>();
        for (ApplicationModel resource : this.getApplications()) {
            resourceMap.put(resource.getName(), resource);
        }
        return resourceMap;
    }

    public List<ApplicationModel> getApplications() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List appDatas = this.getMongoStore().loadEntities(MongoApplicationEntity.class, query, this.invocationContext);
        ArrayList<ApplicationModel> result = new ArrayList<ApplicationModel>();
        for (MongoApplicationEntity appData : appDatas) {
            result.add(new ApplicationAdapter(this.session, (RealmModel)this, appData, this.invocationContext));
        }
        return result;
    }

    public ApplicationModel addApplication(String name) {
        return this.addApplication(null, name);
    }

    public ApplicationModel addApplication(String id, String name) {
        MongoApplicationEntity appData = new MongoApplicationEntity();
        appData.setId(id);
        appData.setName(name);
        appData.setRealmId(this.getId());
        appData.setEnabled(true);
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)appData, this.invocationContext);
        return new ApplicationAdapter(this.session, (RealmModel)this, appData, this.invocationContext);
    }

    public boolean removeApplication(String id) {
        return this.getMongoStore().removeEntity(MongoApplicationEntity.class, id, this.invocationContext);
    }

    public OAuthClientModel addOAuthClient(String name) {
        return this.addOAuthClient(null, name);
    }

    public OAuthClientModel addOAuthClient(String id, String name) {
        MongoOAuthClientEntity oauthClient = new MongoOAuthClientEntity();
        oauthClient.setId(id);
        oauthClient.setRealmId(this.getId());
        oauthClient.setName(name);
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)oauthClient, this.invocationContext);
        return new OAuthClientAdapter(this.session, (RealmModel)this, oauthClient, this.invocationContext);
    }

    public boolean removeOAuthClient(String id) {
        return this.getMongoStore().removeEntity(MongoOAuthClientEntity.class, id, this.invocationContext);
    }

    public OAuthClientModel getOAuthClient(String name) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("name").is((Object)name).get();
        MongoOAuthClientEntity oauthClient = (MongoOAuthClientEntity)this.getMongoStore().loadSingleEntity(MongoOAuthClientEntity.class, query, this.invocationContext);
        return oauthClient == null ? null : new OAuthClientAdapter(this.session, (RealmModel)this, oauthClient, this.invocationContext);
    }

    public OAuthClientModel getOAuthClientById(String id) {
        return this.model.getOAuthClientById(id, (RealmModel)this);
    }

    public List<OAuthClientModel> getOAuthClients() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List results = this.getMongoStore().loadEntities(MongoOAuthClientEntity.class, query, this.invocationContext);
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (MongoOAuthClientEntity data : results) {
            list.add(new OAuthClientAdapter(this.session, (RealmModel)this, data, this.invocationContext));
        }
        return list;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredCredentials());
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
        this.updateRealm();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            logger.info((Object)("updating cred: " + cred));
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
        this.updateRealm();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        ArrayList<RequiredCredentialModel> result = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setInput(entity.isInput());
            model.setSecret(entity.isSecret());
            model.setType(entity.getType());
            result.add(model);
        }
        return result;
    }

    protected void updateRealm() {
        super.updateMongoEntity();
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.realm.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.realm.setBrowserSecurityHeaders(headers);
        this.updateRealm();
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.updateRealm();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.updateRealm();
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setPriority(priority);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        if (displayName == null) {
            displayName = entity.getId();
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.realm.getUserFederationProviders().add(entity);
        this.updateRealm();
        return new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = (UserFederationProviderEntity)it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            it.remove();
        }
        this.updateRealm();
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
        }
        this.updateRealm();
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List entities = this.realm.getUserFederationProviders();
        LinkedList<UserFederationProviderEntity> copy = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        LinkedList<UserFederationProviderModel> result = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return result;
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        LinkedList<UserFederationProviderEntity> entities = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderModel model : providers) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                entity.setId(KeycloakModelUtils.generateId());
            }
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName == null) {
                entity.setDisplayName(entity.getId());
            }
            entity.setDisplayName(displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            entities.add(entity);
        }
        this.realm.setUserFederationProviders(entities);
        this.updateRealm();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.updateRealm();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.updateRealm();
    }

    public Set<String> getEventsListeners() {
        return new HashSet<String>(this.realm.getEventsListeners());
    }

    public void setEventsListeners(Set<String> listeners) {
        if (listeners != null) {
            this.realm.setEventsListeners(new ArrayList<String>(listeners));
        } else {
            this.realm.setEventsListeners(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public ApplicationModel getMasterAdminApp() {
        MongoApplicationEntity appData = (MongoApplicationEntity)this.getMongoStore().loadEntity(MongoApplicationEntity.class, this.realm.getAdminAppId(), this.invocationContext);
        return appData != null ? new ApplicationAdapter(this.session, (RealmModel)this, appData, this.invocationContext) : null;
    }

    public void setMasterAdminApp(ApplicationModel app) {
        String adminAppId = app != null ? app.getId() : null;
        this.realm.setAdminAppId(adminAppId);
        this.updateRealm();
    }

    @Override
    public MongoRealmEntity getMongoEntity() {
        return this.realm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

