/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.entities.PersistentClientSessionEntity;
import org.keycloak.models.entities.PersistentUserSessionEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoOfflineUserSessionEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoOnlineUserSessionEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserSessionEntity;
import org.keycloak.models.session.PersistentClientSessionAdapter;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;

public class MongoUserSessionPersisterProvider
implements UserSessionPersisterProvider {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoUserSessionPersisterProvider(KeycloakSession session, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.invocationContext = invocationContext;
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    private MongoUserSessionEntity loadUserSession(String userSessionId, boolean offline) {
        Class clazz = offline ? MongoOfflineUserSessionEntity.class : MongoOnlineUserSessionEntity.class;
        return this.getMongoStore().loadEntity(clazz, userSessionId, this.invocationContext);
    }

    public void createUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        MongoUserSessionEntity entity = offline ? new MongoOfflineUserSessionEntity() : new MongoOnlineUserSessionEntity();
        entity.setId(model.getUserSessionId());
        entity.setRealmId(adapter.getRealm().getId());
        entity.setUserId(adapter.getUser().getId());
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        entity.setClientSessions(new ArrayList());
        this.getMongoStore().insertEntity(entity, this.invocationContext);
    }

    public void createClientSession(ClientSessionModel clientSession, boolean offline) {
        PersistentClientSessionAdapter adapter = new PersistentClientSessionAdapter(clientSession);
        PersistentClientSessionModel model = adapter.getUpdatedModel();
        MongoUserSessionEntity userSession = this.loadUserSession(model.getUserSessionId(), offline);
        if (userSession == null) {
            throw new ModelException("Not userSession found with ID " + clientSession.getUserSession().getId() + ". Requested by clientSession: " + clientSession.getId());
        }
        PersistentClientSessionEntity entity = new PersistentClientSessionEntity();
        entity.setClientSessionId(clientSession.getId());
        entity.setClientId(clientSession.getClient().getId());
        entity.setData(model.getData());
        userSession.getClientSessions().add(entity);
        this.getMongoStore().updateEntity(userSession, this.invocationContext);
    }

    public void updateUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = userSession instanceof PersistentUserSessionAdapter ? (PersistentUserSessionAdapter)userSession : new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        MongoUserSessionEntity entity = this.loadUserSession(model.getUserSessionId(), offline);
        if (entity == null) {
            throw new ModelException("UserSession with ID " + userSession.getId() + ", offline: " + offline + " not found");
        }
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        this.getMongoStore().updateEntity(entity, this.invocationContext);
    }

    public void removeUserSession(String userSessionId, boolean offline) {
        MongoUserSessionEntity entity = this.loadUserSession(userSessionId, offline);
        if (entity != null) {
            this.getMongoStore().removeEntity(entity, this.invocationContext);
        }
    }

    public void removeClientSession(String clientSessionId, boolean offline) {
        DBObject query = new QueryBuilder().and("clientSessions.clientSessionId").is((Object)clientSessionId).get();
        Class clazz = offline ? MongoOfflineUserSessionEntity.class : MongoOnlineUserSessionEntity.class;
        MongoUserSessionEntity userSession = this.getMongoStore().loadSingleEntity(clazz, query, this.invocationContext);
        if (userSession != null) {
            PersistentClientSessionEntity found = null;
            for (PersistentClientSessionEntity clientSession : userSession.getClientSessions()) {
                if (!clientSession.getClientSessionId().equals(clientSessionId)) continue;
                found = clientSession;
                break;
            }
            if (found != null) {
                userSession.getClientSessions().remove(found);
                if (userSession.getClientSessions().size() == 0) {
                    this.getMongoStore().removeEntity(userSession, this.invocationContext);
                } else {
                    this.getMongoStore().updateEntity(userSession, this.invocationContext);
                }
            }
        }
    }

    public void onRealmRemoved(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        this.getMongoStore().removeEntities(MongoOnlineUserSessionEntity.class, query, false, this.invocationContext);
        this.getMongoStore().removeEntities(MongoOfflineUserSessionEntity.class, query, false, this.invocationContext);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        DBObject query = new QueryBuilder().and("clientSessions.clientId").is((Object)client.getId()).get();
        List<MongoOnlineUserSessionEntity> userSessions = this.getMongoStore().loadEntities(MongoOnlineUserSessionEntity.class, query, this.invocationContext);
        for (MongoOnlineUserSessionEntity userSession : userSessions) {
            this.removeClientSessionOfClient(userSession, client.getId());
        }
        List<MongoOfflineUserSessionEntity> userSessions2 = this.getMongoStore().loadEntities(MongoOfflineUserSessionEntity.class, query, this.invocationContext);
        for (MongoOfflineUserSessionEntity userSession : userSessions2) {
            this.removeClientSessionOfClient(userSession, client.getId());
        }
    }

    private void removeClientSessionOfClient(MongoUserSessionEntity userSession, String clientId) {
        PersistentClientSessionEntity found = null;
        for (PersistentClientSessionEntity clientSession : userSession.getClientSessions()) {
            if (!clientSession.getClientId().equals(clientId)) continue;
            found = clientSession;
            break;
        }
        if (found != null) {
            userSession.getClientSessions().remove(found);
            if (userSession.getClientSessions().size() == 0) {
                this.getMongoStore().removeEntity(userSession, this.invocationContext);
            } else {
                this.getMongoStore().updateEntity(userSession, this.invocationContext);
            }
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.onUserRemoved(realm, user.getId());
    }

    private void onUserRemoved(RealmModel realm, String userId) {
        DBObject query = new QueryBuilder().and("userId").is((Object)userId).get();
        this.getMongoStore().removeEntities(MongoOnlineUserSessionEntity.class, query, false, this.invocationContext);
        this.getMongoStore().removeEntities(MongoOfflineUserSessionEntity.class, query, false, this.invocationContext);
    }

    public void clearDetachedUserSessions() {
        DBObject query = new QueryBuilder().and("clientSessions").is(Collections.emptyList()).get();
        this.getMongoStore().removeEntities(MongoOnlineUserSessionEntity.class, query, false, this.invocationContext);
        this.getMongoStore().removeEntities(MongoOfflineUserSessionEntity.class, query, false, this.invocationContext);
    }

    public int getUserSessionsCount(boolean offline) {
        DBObject query = new QueryBuilder().get();
        Class clazz = offline ? MongoOfflineUserSessionEntity.class : MongoOnlineUserSessionEntity.class;
        return this.getMongoStore().countEntities(clazz, query, this.invocationContext);
    }

    public void updateAllTimestamps(int time) {
        DBObject timestampSubquery = new QueryBuilder().and("timestamp").notEquals((Object)time).get();
        DBObject query = new QueryBuilder().and("clientSessions").elemMatch(timestampSubquery).get();
        DBObject update = new QueryBuilder().and("$set").is((Object)new BasicDBObject("clientSessions.$.timestamp", (Object)time)).get();
        int countModified = 1;
        while (countModified > 0) {
            countModified = this.getMongoStore().updateEntities(MongoOfflineUserSessionEntity.class, query, update, this.invocationContext);
        }
        countModified = 1;
        while (countModified > 0) {
            countModified = this.getMongoStore().updateEntities(MongoOnlineUserSessionEntity.class, query, update, this.invocationContext);
        }
        query = new QueryBuilder().get();
        update = new QueryBuilder().and("$set").is((Object)new BasicDBObject("lastSessionRefresh", (Object)time)).get();
        this.getMongoStore().updateEntities(MongoOfflineUserSessionEntity.class, query, update, this.invocationContext);
        this.getMongoStore().updateEntities(MongoOnlineUserSessionEntity.class, query, update, this.invocationContext);
    }

    public List<UserSessionModel> loadUserSessions(int firstResult, int maxResults, boolean offline) {
        DBObject query = new QueryBuilder().get();
        BasicDBObject sort = new BasicDBObject("id", (Object)1);
        Class clazz = offline ? MongoOfflineUserSessionEntity.class : MongoOnlineUserSessionEntity.class;
        List<MongoOfflineUserSessionEntity> entities = this.getMongoStore().loadEntities(clazz, query, (DBObject)sort, firstResult, maxResults, this.invocationContext);
        LinkedList<UserSessionModel> results = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity mongoUserSessionEntity : entities) {
            RealmModel realm = this.session.realms().getRealm(mongoUserSessionEntity.getRealmId());
            UserModel user = this.session.users().getUserById(mongoUserSessionEntity.getUserId(), realm);
            if (user == null) {
                this.onUserRemoved(realm, mongoUserSessionEntity.getUserId());
                return this.loadUserSessions(firstResult, maxResults, offline);
            }
            PersistentUserSessionAdapter userSession = this.toAdapter(realm, user, mongoUserSessionEntity);
            results.add((UserSessionModel)userSession);
        }
        return results;
    }

    private PersistentUserSessionAdapter toAdapter(RealmModel realm, UserModel user, PersistentUserSessionEntity entity) {
        PersistentUserSessionModel model = new PersistentUserSessionModel();
        model.setUserSessionId(entity.getId());
        model.setLastSessionRefresh(entity.getLastSessionRefresh());
        model.setData(entity.getData());
        LinkedList<PersistentClientSessionAdapter> clientSessions = new LinkedList<PersistentClientSessionAdapter>();
        PersistentUserSessionAdapter userSessionAdapter = new PersistentUserSessionAdapter(model, realm, user, clientSessions);
        for (PersistentClientSessionEntity clientSessEntity : entity.getClientSessions()) {
            PersistentClientSessionAdapter clientSessAdapter = this.toAdapter(realm, userSessionAdapter, clientSessEntity);
            clientSessions.add(clientSessAdapter);
        }
        return userSessionAdapter;
    }

    private PersistentClientSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionAdapter userSession, PersistentClientSessionEntity entity) {
        ClientModel client = realm.getClientById(entity.getClientId());
        PersistentClientSessionModel model = new PersistentClientSessionModel();
        model.setClientSessionId(entity.getClientSessionId());
        model.setClientId(entity.getClientId());
        model.setUserSessionId(userSession.getId());
        model.setUserId(userSession.getUser().getId());
        model.setTimestamp(entity.getTimestamp());
        model.setData(entity.getData());
        return new PersistentClientSessionAdapter(model, realm, client, (UserSessionModel)userSession);
    }

    public void close() {
    }
}

