/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl.updates;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Collections;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.KeycloakModelUtils;

public class Update2_3_0
extends Update {
    @Override
    public String getId() {
        return "2.3.0";
    }

    @Override
    public void update(KeycloakSession session) {
        DBCollection realms = this.db.getCollection("realms");
        DBCursor cursor = realms.find();
        while (cursor.hasNext()) {
            BasicDBObject realm = (BasicDBObject)cursor.next();
            String realmId = realm.getString("_id");
            String privateKeyPem = realm.getString("privateKeyPem");
            String certificatePem = realm.getString("certificatePem");
            BasicDBList entities = (BasicDBList)realm.get("componentEntities");
            BasicDBObject component = new BasicDBObject();
            component.put((Object)"id", (Object)KeycloakModelUtils.generateId());
            component.put((Object)"name", (Object)"rsa");
            component.put((Object)"providerType", (Object)KeyProvider.class.getName());
            component.put((Object)"providerId", (Object)"rsa");
            component.put((Object)"parentId", (Object)realmId);
            BasicDBObject config = new BasicDBObject();
            config.put((Object)"priority", Collections.singletonList("100"));
            config.put((Object)"privateKey", Collections.singletonList(privateKeyPem));
            config.put((Object)"certificate", Collections.singletonList(certificatePem));
            component.put((Object)"config", (Object)config);
            entities.add((Object)component);
            realm.remove((Object)"privateKeyPem");
            realm.remove((Object)"certificatePem");
            realm.remove((Object)"publicKeyPem");
            realm.remove((Object)"codeSecret");
            realms.update((DBObject)new BasicDBObject().append("_id", (Object)realmId), (DBObject)realm);
        }
    }
}

