/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl.updates;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.models.KeycloakSession;
import org.keycloak.storage.UserStorageProvider;

public class Update2_4_0
extends Update {
    private final Logger logger = Logger.getLogger(this.getClass());

    @Override
    public String getId() {
        return "2.4.0";
    }

    @Override
    public void update(KeycloakSession session) {
        this.portUserFedMappersToComponent("ldap", "org.keycloak.storage.ldap.mappers.LDAPStorageMapper");
        this.portUserFedToComponent("ldap");
    }

    public void portUserFedToComponent(String providerId) {
        DBCollection realms = this.db.getCollection("realms");
        DBCursor cursor = realms.find();
        while (cursor.hasNext()) {
            BasicDBObject realm = (BasicDBObject)cursor.next();
            String realmId = realm.getString("_id");
            HashSet<String> removedProviders = new HashSet<String>();
            BasicDBList componentEntities = (BasicDBList)realm.get("componentEntities");
            BasicDBList federationProviders = (BasicDBList)realm.get("userFederationProviders");
            for (Object obj : federationProviders) {
                BasicDBObject fedProvider = (BasicDBObject)obj;
                if (!fedProvider.getString("providerName").equals(providerId)) continue;
                String id = fedProvider.getString("id");
                removedProviders.add(id);
                int priority = fedProvider.getInt("priority");
                String displayName = fedProvider.getString("displayName");
                int fullSyncPeriod = fedProvider.getInt("fullSyncPeriod");
                int changedSyncPeriod = fedProvider.getInt("changedSyncPeriod");
                int lastSync = fedProvider.getInt("lastSync");
                BasicDBObject component = new BasicDBObject();
                component.put((Object)"id", (Object)id);
                component.put((Object)"name", (Object)displayName);
                component.put((Object)"providerType", (Object)UserStorageProvider.class.getName());
                component.put((Object)"providerId", (Object)providerId);
                component.put((Object)"parentId", (Object)realmId);
                BasicDBObject config = new BasicDBObject();
                config.put((Object)"priority", Collections.singletonList(Integer.toString(priority)));
                config.put((Object)"fullSyncPeriod", Collections.singletonList(Integer.toString(fullSyncPeriod)));
                config.put((Object)"changedSyncPeriod", Collections.singletonList(Integer.toString(changedSyncPeriod)));
                config.put((Object)"lastSync", Collections.singletonList(Integer.toString(lastSync)));
                BasicDBObject fedConfig = (BasicDBObject)fedProvider.get("config");
                if (fedConfig != null) {
                    for (Map.Entry attr : new HashSet(fedConfig.entrySet())) {
                        String attrName = (String)attr.getKey();
                        String attrValue = attr.getValue().toString();
                        config.put((Object)attrName, Collections.singletonList(attrValue));
                    }
                }
                component.put((Object)"config", (Object)config);
                componentEntities.add((Object)component);
            }
            Iterator it = federationProviders.iterator();
            while (it.hasNext()) {
                BasicDBObject fedProvider = (BasicDBObject)it.next();
                String id = fedProvider.getString("id");
                if (!removedProviders.contains(id)) continue;
                it.remove();
            }
            realms.update((DBObject)new BasicDBObject().append("_id", (Object)realmId), (DBObject)realm);
        }
    }

    public void portUserFedMappersToComponent(String providerId, String mapperType) {
        DBCollection realms = this.db.getCollection("realms");
        DBCursor cursor = realms.find();
        while (cursor.hasNext()) {
            BasicDBObject realm = (BasicDBObject)cursor.next();
            String realmId = realm.getString("_id");
            HashSet<String> removedProviders = new HashSet<String>();
            BasicDBList componentEntities = (BasicDBList)realm.get("componentEntities");
            BasicDBList federationProviders = (BasicDBList)realm.get("userFederationProviders");
            BasicDBList fedMappers = (BasicDBList)realm.get("userFederationMappers");
            for (Object obj : federationProviders) {
                BasicDBObject fedProvider = (BasicDBObject)obj;
                String providerName = fedProvider.getString("providerName");
                if (!providerName.equals(providerId)) continue;
                String id = fedProvider.getString("id");
                for (Object obj2 : fedMappers) {
                    BasicDBObject fedMapper = (BasicDBObject)obj2;
                    String federationProviderId = fedMapper.getString("federationProviderId");
                    if (!federationProviderId.equals(id)) continue;
                    String name = fedMapper.getString("name");
                    String mapperId = fedMapper.getString("id");
                    removedProviders.add(mapperId);
                    String mapperProviderId = fedMapper.getString("federationMapperType");
                    BasicDBObject component = new BasicDBObject();
                    component.put((Object)"id", (Object)mapperId);
                    component.put((Object)"name", (Object)name);
                    component.put((Object)"providerType", (Object)mapperType);
                    component.put((Object)"providerId", (Object)mapperProviderId);
                    component.put((Object)"parentId", (Object)id);
                    BasicDBObject fedConfig = (BasicDBObject)fedMapper.get("config");
                    BasicDBObject config = new BasicDBObject();
                    if (fedConfig != null) {
                        for (Map.Entry attr : new HashSet(fedConfig.entrySet())) {
                            String attrName = (String)attr.getKey();
                            String attrValue = attr.getValue().toString();
                            config.put((Object)attrName, Collections.singletonList(attrValue));
                        }
                    }
                    component.put((Object)"config", (Object)config);
                    componentEntities.add((Object)component);
                }
            }
            Iterator it = fedMappers.iterator();
            while (it.hasNext()) {
                BasicDBObject fedMapper = (BasicDBObject)it.next();
                String id = fedMapper.getString("id");
                if (!removedProviders.contains(id)) continue;
                it.remove();
            }
            realms.update((DBObject)new BasicDBObject().append("_id", (Object)realmId), (DBObject)realm);
        }
    }
}

