/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.picketlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.picketlink.RealmAdapter;
import org.keycloak.models.picketlink.RoleAdapter;
import org.keycloak.models.picketlink.UserAdapter;
import org.keycloak.models.picketlink.mappings.ApplicationData;
import org.keycloak.models.picketlink.relationships.ScopeRelationship;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.sample.Grant;
import org.picketlink.idm.model.sample.Role;
import org.picketlink.idm.model.sample.SampleModel;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;

public class ApplicationAdapter
implements ApplicationModel {
    protected ApplicationData applicationData;
    protected RealmAdapter realm;
    protected IdentityManager idm;
    protected PartitionManager partitionManager;
    protected RelationshipManager relationshipManager;

    public ApplicationAdapter(ApplicationData applicationData, RealmAdapter realm, PartitionManager partitionManager) {
        this.applicationData = applicationData;
        this.realm = realm;
        this.partitionManager = partitionManager;
    }

    protected IdentityManager getIdm() {
        if (this.idm == null) {
            this.idm = this.partitionManager.createIdentityManager((Partition)this.applicationData);
        }
        return this.idm;
    }

    protected RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = this.partitionManager.createRelationshipManager();
        }
        return this.relationshipManager;
    }

    public void updateApplication() {
        this.partitionManager.update((Partition)this.applicationData);
    }

    public UserAdapter getApplicationUser() {
        return new UserAdapter(this.applicationData.getResourceUser(), this.realm.getIdm());
    }

    public String getId() {
        return this.applicationData.getName();
    }

    public String getName() {
        return this.applicationData.getResourceName();
    }

    public void setName(String name) {
        this.applicationData.setResourceName(name);
        this.updateApplication();
    }

    public boolean isEnabled() {
        return this.applicationData.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.applicationData.setEnabled(enabled);
        this.updateApplication();
    }

    public boolean isSurrogateAuthRequired() {
        return this.applicationData.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.applicationData.setSurrogateAuthRequired(surrogateAuthRequired);
        this.updateApplication();
    }

    public String getManagementUrl() {
        return this.applicationData.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.applicationData.setManagementUrl(url);
        this.updateApplication();
    }

    public String getBaseUrl() {
        return this.applicationData.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.applicationData.setBaseUrl(url);
        this.updateApplication();
    }

    public RoleAdapter getRole(String name) {
        Role role = SampleModel.getRole((IdentityManager)this.getIdm(), (String)name);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(role, this.getIdm());
    }

    public RoleModel getRoleById(String id) {
        IdentityQuery query = this.getIdm().createIdentityQuery(Role.class);
        query.setParameter(IdentityType.ID, new Object[]{id});
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter((Role)roles.get(0), this.getIdm());
    }

    public void grantRole(UserModel user, RoleModel role) {
        SampleModel.grantRole((RelationshipManager)this.getRelationshipManager(), (IdentityType)((UserAdapter)user).getUser(), (Role)((RoleAdapter)role).getRole());
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        return SampleModel.hasRole((RelationshipManager)this.getRelationshipManager(), (IdentityType)((UserAdapter)user).getUser(), (Role)((RoleAdapter)role).getRole());
    }

    public boolean hasRole(UserModel user, String role) {
        RoleAdapter roleModel = this.getRole(role);
        return this.hasRole(user, roleModel);
    }

    public RoleAdapter addRole(String name) {
        Role role = new Role(name);
        this.getIdm().add((IdentityType)role);
        return new RoleAdapter(role, this.getIdm());
    }

    public boolean removeRoleById(String id) {
        try {
            this.getIdm().remove(this.getIdm().lookupIdentityById(Role.class, id));
            return true;
        }
        catch (IdentityManagementException e) {
            return false;
        }
    }

    public List<RoleModel> getRoles() {
        IdentityQuery query = this.getIdm().createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{this.applicationData});
        List roles = query.getResultList();
        ArrayList<RoleModel> roleModels = new ArrayList<RoleModel>();
        for (Role role : roles) {
            roleModels.add(new RoleAdapter(role, this.idm));
        }
        return roleModels;
    }

    public Set<String> getRoleMappingValues(UserModel user) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{((UserAdapter)user).getUser()});
        List grants = query.getResultList();
        HashSet<String> set = new HashSet<String>();
        for (Grant grant : grants) {
            if (!grant.getRole().getPartition().getId().equals(this.applicationData.getId())) continue;
            set.add(grant.getRole().getName());
        }
        return set;
    }

    public List<RoleModel> getRoleMappings(UserModel user) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{((UserAdapter)user).getUser()});
        List grants = query.getResultList();
        ArrayList<RoleModel> set = new ArrayList<RoleModel>();
        for (Grant grant : grants) {
            if (!grant.getRole().getPartition().getId().equals(this.applicationData.getId())) continue;
            set.add(new RoleAdapter(grant.getRole(), this.getIdm()));
        }
        return set;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{((UserAdapter)user).getUser()});
        query.setParameter((QueryParameter)Grant.ROLE, new Object[]{((RoleAdapter)role).getRole()});
        List grants = query.getResultList();
        for (Grant grant : grants) {
            this.getRelationshipManager().remove((Relationship)grant);
        }
    }

    public void addScopeMapping(UserModel agent, String roleName) {
        IdentityManager idm = this.getIdm();
        Role role = SampleModel.getRole((IdentityManager)idm, (String)roleName);
        if (role == null) {
            throw new RuntimeException("role not found");
        }
        this.addScopeMapping(agent, new RoleAdapter(role, idm));
    }

    public void addScopeMapping(UserModel agent, RoleModel role) {
        ScopeRelationship scope = new ScopeRelationship();
        scope.setClient(((UserAdapter)agent).getUser());
        scope.setScope(((RoleAdapter)role).getRole());
        this.getRelationshipManager().add((Relationship)scope);
    }

    public void deleteScopeMapping(UserModel user, RoleModel role) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ScopeRelationship.class);
        query.setParameter((QueryParameter)ScopeRelationship.CLIENT, new Object[]{((UserAdapter)user).getUser()});
        query.setParameter((QueryParameter)ScopeRelationship.SCOPE, new Object[]{((RoleAdapter)role).getRole()});
        List grants = query.getResultList();
        for (ScopeRelationship grant : grants) {
            this.getRelationshipManager().remove((Relationship)grant);
        }
    }

    public Set<String> getScopeMappingValues(UserModel agent) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ScopeRelationship.class);
        query.setParameter((QueryParameter)ScopeRelationship.CLIENT, new Object[]{((UserAdapter)agent).getUser()});
        List scope = query.getResultList();
        HashSet<String> set = new HashSet<String>();
        for (ScopeRelationship rel : scope) {
            if (!rel.getScope().getPartition().getId().equals(this.applicationData.getId())) continue;
            set.add(rel.getScope().getName());
        }
        return set;
    }

    public List<RoleModel> getScopeMappings(UserModel agent) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ScopeRelationship.class);
        query.setParameter((QueryParameter)ScopeRelationship.CLIENT, new Object[]{((UserAdapter)agent).getUser()});
        List scope = query.getResultList();
        ArrayList<RoleModel> roles = new ArrayList<RoleModel>();
        for (ScopeRelationship rel : scope) {
            if (!rel.getScope().getPartition().getId().equals(this.applicationData.getId())) continue;
            roles.add(new RoleAdapter(rel.getScope(), this.getIdm()));
        }
        return roles;
    }

    public List<String> getDefaultRoles() {
        if (this.applicationData.getDefaultRoles() != null) {
            return Arrays.asList(this.applicationData.getDefaultRoles());
        }
        return Collections.emptyList();
    }

    public void addDefaultRole(String name) {
        String[] defaultRoles;
        if (this.getRole(name) == null) {
            this.addRole(name);
        }
        defaultRoles = (defaultRoles = this.applicationData.getDefaultRoles()) == null ? new String[1] : Arrays.copyOf(defaultRoles, defaultRoles.length + 1);
        defaultRoles[defaultRoles.length - 1] = name;
        this.applicationData.setDefaultRoles(defaultRoles);
        this.updateApplication();
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        for (String name : defaultRoles) {
            if (this.getRole(name) != null) continue;
            this.addRole(name);
        }
        this.applicationData.setDefaultRoles(defaultRoles);
        this.updateApplication();
    }
}

