/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.picketlink;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.picketlink.PicketlinkKeycloakTransaction;
import org.keycloak.models.picketlink.RealmAdapter;
import org.keycloak.models.picketlink.mappings.RealmData;
import org.keycloak.models.picketlink.relationships.RealmListingRelationship;
import org.keycloak.models.utils.KeycloakSessionUtils;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.RelationshipQuery;

public class PicketlinkKeycloakSession
implements KeycloakSession {
    public static ThreadLocal<EntityManager> currentEntityManager = new ThreadLocal();
    public static ThreadLocal<Exception> setWhere = new ThreadLocal();
    protected PartitionManager partitionManager;
    protected EntityManager entityManager;

    public PicketlinkKeycloakSession(PartitionManager partitionManager, EntityManager entityManager) {
        this.partitionManager = partitionManager;
        this.entityManager = entityManager;
        if (currentEntityManager.get() != null) {
            setWhere.get().printStackTrace();
            throw new IllegalStateException("Thread local was leaked!");
        }
        currentEntityManager.set(entityManager);
        setWhere.set(new Exception());
    }

    public KeycloakTransaction getTransaction() {
        return new PicketlinkKeycloakTransaction(this.entityManager.getTransaction());
    }

    public RealmAdapter createRealm(String name) {
        return this.createRealm(KeycloakSessionUtils.generateId(), name);
    }

    public RealmAdapter createRealm(String id, String name) {
        RealmData newRealm = new RealmData(id);
        newRealm.setId(id);
        newRealm.setRealmName(name);
        this.partitionManager.add((Partition)newRealm);
        RealmListingRelationship rel = new RealmListingRelationship();
        rel.setRealm(newRealm.getName());
        this.partitionManager.createRelationshipManager().add((Relationship)rel);
        RealmAdapter realm = new RealmAdapter(this, newRealm, this.partitionManager);
        return realm;
    }

    public List<RealmModel> getRealms(UserModel admin) {
        RelationshipManager relationshipManager = this.partitionManager.createRelationshipManager();
        RelationshipQuery query = relationshipManager.createRelationshipQuery(RealmListingRelationship.class);
        List results = query.getResultList();
        ArrayList<RealmModel> realmModels = new ArrayList<RealmModel>();
        for (RealmListingRelationship relationship : results) {
            String realmName = relationship.getRealm();
            RealmAdapter model = this.getRealm(realmName);
            if (model == null) {
                relationshipManager.remove((Relationship)relationship);
                continue;
            }
            realmModels.add(model);
        }
        return realmModels;
    }

    public RealmAdapter getRealm(String id) {
        RealmData existing = (RealmData)this.partitionManager.getPartition(RealmData.class, id);
        if (existing == null) {
            return null;
        }
        return new RealmAdapter(this, existing, this.partitionManager);
    }

    public RealmModel getRealmByName(String name) {
        throw new RuntimeException("NOT IMPLEMENTED YET");
    }

    public boolean removeRealm(String id) {
        RealmData partition = (RealmData)this.partitionManager.getPartition(RealmData.class, id);
        if (partition == null) {
            return false;
        }
        this.partitionManager.remove((Partition)partition);
        return true;
    }

    public void close() {
        setWhere.set(null);
        currentEntityManager.set(null);
        if (this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().rollback();
        }
        if (this.entityManager.isOpen()) {
            this.entityManager.close();
        }
    }
}

