/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.picketlink;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openssl.PEMWriter;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.IdGenerator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.picketlink.ApplicationAdapter;
import org.keycloak.models.picketlink.OAuthClientAdapter;
import org.keycloak.models.picketlink.RoleAdapter;
import org.keycloak.models.picketlink.UserAdapter;
import org.keycloak.models.picketlink.mappings.ApplicationData;
import org.keycloak.models.picketlink.mappings.RealmData;
import org.keycloak.models.picketlink.relationships.ApplicationRelationship;
import org.keycloak.models.picketlink.relationships.OAuthClientRelationship;
import org.keycloak.models.picketlink.relationships.OAuthClientRequiredCredentialRelationship;
import org.keycloak.models.picketlink.relationships.RequiredApplicationCredentialRelationship;
import org.keycloak.models.picketlink.relationships.RequiredCredentialRelationship;
import org.keycloak.models.picketlink.relationships.ScopeRelationship;
import org.keycloak.models.picketlink.relationships.SocialLinkRelationship;
import org.keycloak.util.PemUtils;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.TOTPCredential;
import org.picketlink.idm.credential.TOTPCredentials;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.X509CertificateCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.sample.Grant;
import org.picketlink.idm.model.sample.Role;
import org.picketlink.idm.model.sample.SampleModel;
import org.picketlink.idm.model.sample.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;

public class RealmAdapter
implements RealmModel {
    protected RealmData realm;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected IdentityManager idm;
    protected PartitionManager partitionManager;
    protected RelationshipManager relationshipManager;
    protected KeycloakSession session;
    private PasswordPolicy passwordPolicy;

    public RealmAdapter(KeycloakSession session, RealmData realm, PartitionManager partitionManager) {
        this.session = session;
        this.realm = realm;
        this.partitionManager = partitionManager;
    }

    protected IdentityManager getIdm() {
        if (this.idm == null) {
            this.idm = this.partitionManager.createIdentityManager((Partition)this.realm);
        }
        return this.idm;
    }

    protected RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = this.partitionManager.createRelationshipManager();
        }
        return this.relationshipManager;
    }

    protected void updateRealm() {
        this.partitionManager.update((Partition)this.realm);
    }

    public String getId() {
        return this.realm.getName();
    }

    public String getName() {
        return this.realm.getRealmName();
    }

    public void setName(String name) {
        this.realm.setRealmName(name);
        this.updateRealm();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.updateRealm();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.updateRealm();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.updateRealm();
    }

    public boolean isSslNotRequired() {
        return this.realm.isSslNotRequired();
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.realm.setSslNotRequired(sslNotRequired);
        this.updateRealm();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.updateRealm();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.updateRealm();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
        this.updateRealm();
    }

    public int getTokenLifespan() {
        return this.realm.getTokenLifespan();
    }

    public void setTokenLifespan(int tokenLifespan) {
        this.realm.setTokenLifespan(tokenLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.updateRealm();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
        this.updateRealm();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
        this.updateRealm();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        String pem = this.getPublicKeyPem();
        if (pem != null) {
            try {
                this.publicKey = PemUtils.decodePublicKey((String)pem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)publicKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.setPublicKeyPem(PemUtils.removeBeginEnd((String)s));
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        String pem = this.getPrivateKeyPem();
        if (pem != null) {
            try {
                this.privateKey = PemUtils.decodePrivateKey((String)pem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)privateKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.setPrivateKeyPem(PemUtils.removeBeginEnd((String)s));
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        List<RequiredCredentialRelationship> results = this.getRequiredCredentialRelationships();
        return this.getRequiredCredentialModels(results);
    }

    protected List<RequiredCredentialRelationship> getRequiredCredentialRelationships() {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(RequiredCredentialRelationship.class);
        query.setParameter((QueryParameter)RequiredCredentialRelationship.REALM, new Object[]{this.realm.getName()});
        return query.getResultList();
    }

    public void addRequiredApplicationCredential(RequiredCredentialModel cred) {
        RequiredApplicationCredentialRelationship relationship = new RequiredApplicationCredentialRelationship();
        this.addRequiredCredential(cred, relationship);
    }

    public List<RequiredCredentialModel> getRequiredApplicationCredentials() {
        List<RequiredApplicationCredentialRelationship> results = this.getResourceRequiredCredentialRelationships();
        return this.getRequiredCredentialModels(results);
    }

    protected List<RequiredApplicationCredentialRelationship> getResourceRequiredCredentialRelationships() {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(RequiredApplicationCredentialRelationship.class);
        query.setParameter((QueryParameter)RequiredApplicationCredentialRelationship.REALM, new Object[]{this.realm.getName()});
        return query.getResultList();
    }

    public void addRequiredOAuthClientCredential(RequiredCredentialModel cred) {
        OAuthClientRequiredCredentialRelationship relationship = new OAuthClientRequiredCredentialRelationship();
        this.addRequiredCredential(cred, relationship);
    }

    public List<RequiredCredentialModel> getRequiredOAuthClientCredentials() {
        List<OAuthClientRequiredCredentialRelationship> results = this.getOAuthClientRequiredCredentialRelationships();
        return this.getRequiredCredentialModels(results);
    }

    protected List<OAuthClientRequiredCredentialRelationship> getOAuthClientRequiredCredentialRelationships() {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(OAuthClientRequiredCredentialRelationship.class);
        query.setParameter((QueryParameter)RequiredApplicationCredentialRelationship.REALM, new Object[]{this.realm.getName()});
        return query.getResultList();
    }

    public void addRequiredCredential(RequiredCredentialModel cred) {
        RequiredCredentialRelationship relationship = new RequiredCredentialRelationship();
        this.addRequiredCredential(cred, relationship);
    }

    protected List<RequiredCredentialModel> getRequiredCredentialModels(List<? extends RequiredCredentialRelationship> results) {
        ArrayList<RequiredCredentialModel> rtn = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialRelationship requiredCredentialRelationship : results) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setInput(requiredCredentialRelationship.isInput());
            model.setSecret(requiredCredentialRelationship.isSecret());
            model.setType(requiredCredentialRelationship.getCredentialType());
            model.setFormLabel(requiredCredentialRelationship.getFormLabel());
            rtn.add(model);
        }
        return rtn;
    }

    protected void addRequiredCredential(RequiredCredentialModel cred, RequiredCredentialRelationship relationship) {
        relationship.setCredentialType(cred.getType());
        relationship.setInput(cred.isInput());
        relationship.setSecret(cred.isSecret());
        relationship.setRealm(this.realm.getName());
        relationship.setFormLabel(cred.getFormLabel());
        this.getRelationshipManager().add((Relationship)relationship);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        List<RequiredCredentialRelationship> relationships = this.getRequiredCredentialRelationships();
        RelationshipManager rm = this.getRelationshipManager();
        HashSet<String> already = new HashSet<String>();
        for (RequiredCredentialRelationship rel : relationships) {
            if (!creds.contains(rel.getCredentialType())) {
                rm.remove((Relationship)rel);
                continue;
            }
            already.add(rel.getCredentialType());
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
    }

    public void updateRequiredOAuthClientCredentials(Set<String> creds) {
        List<OAuthClientRequiredCredentialRelationship> relationships = this.getOAuthClientRequiredCredentialRelationships();
        RelationshipManager rm = this.getRelationshipManager();
        HashSet<String> already = new HashSet<String>();
        for (RequiredCredentialRelationship requiredCredentialRelationship : relationships) {
            if (!creds.contains(requiredCredentialRelationship.getCredentialType())) {
                rm.remove((Relationship)requiredCredentialRelationship);
                continue;
            }
            already.add(requiredCredentialRelationship.getCredentialType());
        }
        for (String string : creds) {
            if (already.contains(string)) continue;
            this.addRequiredOAuthClientCredential(string);
        }
    }

    public void updateRequiredApplicationCredentials(Set<String> creds) {
        List<RequiredApplicationCredentialRelationship> relationships = this.getResourceRequiredCredentialRelationships();
        RelationshipManager rm = this.getRelationshipManager();
        HashSet<String> already = new HashSet<String>();
        for (RequiredCredentialRelationship requiredCredentialRelationship : relationships) {
            if (!creds.contains(requiredCredentialRelationship.getCredentialType())) {
                rm.remove((Relationship)requiredCredentialRelationship);
                continue;
            }
            already.add(requiredCredentialRelationship.getCredentialType());
        }
        for (String string : creds) {
            if (already.contains(string)) continue;
            this.addRequiredResourceCredential(string);
        }
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
    }

    public void addRequiredOAuthClientCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredOAuthClientCredential(model);
    }

    public void addRequiredResourceCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredApplicationCredential(model);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public boolean validatePassword(UserModel user, String password) {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(user.getLoginName(), new Password(password));
        this.getIdm().validateCredentials((Credentials)creds);
        return creds.getStatus() == Credentials.Status.VALID;
    }

    public boolean validateTOTP(UserModel user, String password, String token) {
        TOTPCredentials creds = new TOTPCredentials();
        creds.setToken(token);
        creds.setUsername(user.getLoginName());
        creds.setPassword(new Password(password));
        this.getIdm().validateCredentials((Credentials)creds);
        return creds.getStatus() == Credentials.Status.VALID;
    }

    public void updateCredential(UserModel user, UserCredentialModel cred) {
        IdentityManager idm = this.getIdm();
        if (cred.getType().equals("password")) {
            Password password = new Password(cred.getValue());
            idm.updateCredential((Account)((UserAdapter)user).getUser(), (Object)password);
        } else if (cred.getType().equals("totp")) {
            TOTPCredential totp = new TOTPCredential(cred.getValue());
            totp.setDevice(cred.getDevice());
            idm.updateCredential((Account)((UserAdapter)user).getUser(), (Object)totp);
        } else if (cred.getType().equals("cert")) {
            X509Certificate cert = null;
            try {
                cert = PemUtils.decodeCertificate((String)cred.getValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            X509CertificateCredentials creds = new X509CertificateCredentials(cert);
            idm.updateCredential((Account)((UserAdapter)user).getUser(), (Object)creds);
        }
    }

    public UserAdapter getUser(String name) {
        User user = this.findPicketlinkUser(name);
        if (user == null) {
            return null;
        }
        return new UserAdapter(user, this.getIdm());
    }

    public UserModel getUserByEmail(String email) {
        IdentityQuery query = this.getIdm().createIdentityQuery(User.class);
        query.setParameter(User.EMAIL, new Object[]{email});
        List users = query.getResultList();
        return users.isEmpty() ? null : new UserAdapter((User)users.get(0), this.getIdm());
    }

    protected User findPicketlinkUser(String name) {
        return SampleModel.getUser((IdentityManager)this.getIdm(), (String)name);
    }

    public UserAdapter addUser(String username) {
        User user = this.findPicketlinkUser(username);
        if (user != null) {
            throw new IllegalStateException("User already exists");
        }
        user = new User(username);
        this.getIdm().add((IdentityType)user);
        UserAdapter userModel = new UserAdapter(user, this.getIdm());
        for (String r : this.getDefaultRoles()) {
            this.grantRole(userModel, this.getRole(r));
        }
        for (ApplicationModel application : this.getApplications()) {
            for (String r : application.getDefaultRoles()) {
                application.grantRole((UserModel)userModel, application.getRole(r));
            }
        }
        return userModel;
    }

    public boolean removeUser(String name) {
        User user = this.findPicketlinkUser(name);
        if (user == null) {
            return false;
        }
        this.getIdm().remove((IdentityType)user);
        return true;
    }

    public RoleAdapter getRole(String name) {
        Role role = SampleModel.getRole((IdentityManager)this.getIdm(), (String)name);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(role, this.getIdm());
    }

    public RoleModel getRoleById(String id) {
        IdentityQuery query = this.getIdm().createIdentityQuery(Role.class);
        query.setParameter(IdentityType.ID, new Object[]{id});
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter((Role)roles.get(0), this.getIdm());
    }

    public RoleAdapter addRole(String name) {
        Role role = new Role(name);
        this.getIdm().add((IdentityType)role);
        return new RoleAdapter(role, this.getIdm());
    }

    public boolean removeRoleById(String id) {
        try {
            this.getIdm().remove(this.getIdm().lookupIdentityById(Role.class, id));
            return true;
        }
        catch (IdentityManagementException e) {
            return false;
        }
    }

    public List<RoleModel> getRoles() {
        IdentityManager idm = this.getIdm();
        IdentityQuery query = idm.createIdentityQuery(Role.class);
        query.setParameter(Role.PARTITION, new Object[]{this.realm});
        List roles = query.getResultList();
        ArrayList<RoleModel> roleModels = new ArrayList<RoleModel>();
        for (Role role : roles) {
            roleModels.add(new RoleAdapter(role, idm));
        }
        return roleModels;
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> resourceMap = new HashMap<String, ApplicationModel>();
        for (ApplicationModel resource : this.getApplications()) {
            resourceMap.put(resource.getName(), resource);
        }
        return resourceMap;
    }

    public ApplicationModel getApplicationById(String id) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ApplicationRelationship.class);
        query.setParameter((QueryParameter)ApplicationRelationship.REALM, new Object[]{this.realm.getName()});
        query.setParameter((QueryParameter)ApplicationRelationship.APPLICATION, new Object[]{id});
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        ApplicationData resource = (ApplicationData)this.partitionManager.getPartition(ApplicationData.class, id);
        ApplicationAdapter model = new ApplicationAdapter(resource, this, this.partitionManager);
        return model;
    }

    public ApplicationModel getApplicationByName(String name) {
        return this.getApplicationNameMap().get(name);
    }

    public List<ApplicationModel> getApplications() {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ApplicationRelationship.class);
        query.setParameter((QueryParameter)ApplicationRelationship.REALM, new Object[]{this.realm.getName()});
        List results = query.getResultList();
        ArrayList<ApplicationModel> resources = new ArrayList<ApplicationModel>();
        for (ApplicationRelationship relationship : results) {
            ApplicationData resource = (ApplicationData)this.partitionManager.getPartition(ApplicationData.class, relationship.getApplication());
            ApplicationAdapter model = new ApplicationAdapter(resource, this, this.partitionManager);
            resources.add(model);
        }
        return resources;
    }

    public ApplicationModel addApplication(String name) {
        ApplicationData applicationData = new ApplicationData(IdGenerator.generateId());
        User resourceUser = new User(name);
        this.idm.add((IdentityType)resourceUser);
        applicationData.setResourceUser(resourceUser);
        applicationData.setResourceName(name);
        this.partitionManager.add((Partition)applicationData);
        ApplicationRelationship resourceRelationship = new ApplicationRelationship();
        resourceRelationship.setRealm(this.realm.getName());
        resourceRelationship.setApplication(applicationData.getName());
        this.getRelationshipManager().add((Relationship)resourceRelationship);
        ApplicationAdapter resource = new ApplicationAdapter(applicationData, this, this.partitionManager);
        return resource;
    }

    public boolean removeApplication(String id) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ApplicationRelationship.class);
        query.setParameter((QueryParameter)ApplicationRelationship.REALM, new Object[]{this.realm.getName()});
        query.setParameter((QueryParameter)ApplicationRelationship.APPLICATION, new Object[]{id});
        List results = query.getResultList();
        if (results.size() == 0) {
            return false;
        }
        ApplicationRelationship relationship = (ApplicationRelationship)((Object)results.get(0));
        ApplicationData application = (ApplicationData)this.partitionManager.getPartition(ApplicationData.class, relationship.getApplication());
        this.partitionManager.remove((Partition)application);
        return true;
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        return SampleModel.hasRole((RelationshipManager)this.getRelationshipManager(), (IdentityType)((UserAdapter)user).getUser(), (Role)((RoleAdapter)role).getRole());
    }

    public boolean hasRole(UserModel user, String role) {
        RoleAdapter roleModel = this.getRole(role);
        return this.hasRole(user, roleModel);
    }

    public void grantRole(UserModel user, RoleModel role) {
        SampleModel.grantRole((RelationshipManager)this.getRelationshipManager(), (IdentityType)((UserAdapter)user).getUser(), (Role)((RoleAdapter)role).getRole());
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{((UserAdapter)user).getUser()});
        query.setParameter((QueryParameter)Grant.ROLE, new Object[]{((RoleAdapter)role).getRole()});
        List grants = query.getResultList();
        for (Grant grant : grants) {
            this.getRelationshipManager().remove((Relationship)grant);
        }
    }

    public Set<String> getRoleMappingValues(UserModel user) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{((UserAdapter)user).getUser()});
        List grants = query.getResultList();
        HashSet<String> set = new HashSet<String>();
        for (Grant grant : grants) {
            if (!grant.getRole().getPartition().getId().equals(this.realm.getId())) continue;
            set.add(grant.getRole().getName());
        }
        return set;
    }

    public List<RoleModel> getRoleMappings(UserModel user) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(Grant.class);
        query.setParameter((QueryParameter)Grant.ASSIGNEE, new Object[]{((UserAdapter)user).getUser()});
        List grants = query.getResultList();
        ArrayList<RoleModel> set = new ArrayList<RoleModel>();
        for (Grant grant : grants) {
            if (!grant.getRole().getPartition().getId().equals(this.realm.getId())) continue;
            set.add(new RoleAdapter(grant.getRole(), this.getIdm()));
        }
        return set;
    }

    public void addScopeMapping(UserModel agent, String roleName) {
        IdentityManager idm = this.getIdm();
        Role role = SampleModel.getRole((IdentityManager)idm, (String)roleName);
        if (role == null) {
            throw new RuntimeException("role not found");
        }
        ScopeRelationship scope = new ScopeRelationship();
        scope.setClient(((UserAdapter)agent).getUser());
        scope.setScope(role);
        this.getRelationshipManager().add((Relationship)scope);
    }

    public void addScopeMapping(UserModel agent, RoleModel role) {
        ScopeRelationship scope = new ScopeRelationship();
        scope.setClient(((UserAdapter)agent).getUser());
        scope.setScope(((RoleAdapter)role).getRole());
        this.getRelationshipManager().add((Relationship)scope);
    }

    public void deleteScopeMapping(UserModel user, RoleModel role) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ScopeRelationship.class);
        query.setParameter((QueryParameter)ScopeRelationship.CLIENT, new Object[]{((UserAdapter)user).getUser()});
        query.setParameter((QueryParameter)ScopeRelationship.SCOPE, new Object[]{((RoleAdapter)role).getRole()});
        List grants = query.getResultList();
        for (ScopeRelationship grant : grants) {
            this.getRelationshipManager().remove((Relationship)grant);
        }
    }

    public OAuthClientModel addOAuthClient(String name) {
        User client = new User(name);
        this.getIdm().add((IdentityType)client);
        OAuthClientRelationship rel = new OAuthClientRelationship();
        rel.setOauthAgent(client);
        rel.setRealm(this.realm.getName());
        this.getRelationshipManager().add((Relationship)rel);
        return new OAuthClientAdapter(rel, this.getIdm(), this.getRelationshipManager());
    }

    public boolean removeOAuthClient(String id) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(OAuthClientRelationship.class);
        query.setParameter((QueryParameter)OAuthClientRelationship.REALM, new Object[]{this.realm.getName()});
        query.setParameter(OAuthClientRelationship.ID, new Object[]{id});
        List results = query.getResultList();
        if (results.size() == 0) {
            return false;
        }
        OAuthClientRelationship relationship = (OAuthClientRelationship)((Object)results.get(0));
        this.getRelationshipManager().remove((Relationship)relationship);
        return true;
    }

    public OAuthClientModel getOAuthClient(String name) {
        User user = this.findPicketlinkUser(name);
        if (user == null) {
            return null;
        }
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(OAuthClientRelationship.class);
        query.setParameter((QueryParameter)OAuthClientRelationship.OAUTH_AGENT, new Object[]{user});
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new OAuthClientAdapter((OAuthClientRelationship)((Object)results.get(0)), this.getIdm(), this.getRelationshipManager());
    }

    public OAuthClientModel getOAuthClientById(String id) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(OAuthClientRelationship.class);
        query.setParameter((QueryParameter)OAuthClientRelationship.REALM, new Object[]{this.realm.getName()});
        query.setParameter(OAuthClientRelationship.ID, new Object[]{id});
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new OAuthClientAdapter((OAuthClientRelationship)((Object)results.get(0)), this.getIdm(), this.getRelationshipManager());
    }

    public List<OAuthClientModel> getOAuthClients() {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(OAuthClientRelationship.class);
        query.setParameter((QueryParameter)OAuthClientRelationship.REALM, new Object[]{this.realm.getName()});
        List results = query.getResultList();
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (OAuthClientRelationship rel : results) {
            list.add(new OAuthClientAdapter(rel, this.getIdm(), this.getRelationshipManager()));
        }
        return list;
    }

    public List<RoleModel> getScopeMappings(UserModel agent) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ScopeRelationship.class);
        query.setParameter((QueryParameter)ScopeRelationship.CLIENT, new Object[]{((UserAdapter)agent).getUser()});
        List scope = query.getResultList();
        ArrayList<RoleModel> roles = new ArrayList<RoleModel>();
        for (ScopeRelationship rel : scope) {
            if (!rel.getScope().getPartition().getId().equals(this.realm.getId())) continue;
            roles.add(new RoleAdapter(rel.getScope(), this.getIdm()));
        }
        return roles;
    }

    public Set<String> getScopeMappingValues(UserModel agent) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(ScopeRelationship.class);
        query.setParameter((QueryParameter)ScopeRelationship.CLIENT, new Object[]{((UserAdapter)agent).getUser()});
        List scope = query.getResultList();
        HashSet<String> set = new HashSet<String>();
        for (ScopeRelationship rel : scope) {
            if (!rel.getScope().getPartition().getId().equals(this.realm.getId())) continue;
            set.add(rel.getScope().getName());
        }
        return set;
    }

    public List<String> getDefaultRoles() {
        if (this.realm.getDefaultRoles() == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String role : this.realm.getDefaultRoles()) {
            RoleAdapter model = this.getRole(role);
            if (model == null) {
                throw new RuntimeException("default role missing");
            }
            list.add(role);
        }
        return list;
    }

    public void addDefaultRole(String name) {
        String[] defaultRoles;
        if (this.getRole(name) == null) {
            this.addRole(name);
        }
        defaultRoles = (defaultRoles = this.realm.getDefaultRoles()) == null ? new String[1] : Arrays.copyOf(defaultRoles, defaultRoles.length + 1);
        defaultRoles[defaultRoles.length - 1] = name;
        this.realm.setDefaultRoles(defaultRoles);
        this.updateRealm();
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        for (String name : defaultRoles) {
            if (this.getRole(name) != null) continue;
            this.addRole(name);
        }
        this.realm.setDefaultRoles(defaultRoles);
        this.updateRealm();
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(SocialLinkRelationship.class);
        query.setParameter((QueryParameter)SocialLinkRelationship.SOCIAL_PROVIDER, new Object[]{socialLink.getSocialProvider()});
        query.setParameter((QueryParameter)SocialLinkRelationship.SOCIAL_USERNAME, new Object[]{socialLink.getSocialUsername()});
        query.setParameter((QueryParameter)SocialLinkRelationship.REALM, new Object[]{this.realm.getName()});
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for socialProvider=" + socialLink.getSocialProvider() + ", socialUsername=" + socialLink.getSocialUsername() + ", results=" + results);
        }
        User user = ((SocialLinkRelationship)((Object)results.get(0))).getUser();
        return new UserAdapter(user, this.getIdm());
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user) {
        RelationshipQuery query = this.getRelationshipManager().createRelationshipQuery(SocialLinkRelationship.class);
        query.setParameter((QueryParameter)SocialLinkRelationship.USER, new Object[]{((UserAdapter)user).getUser()});
        List plSocialLinks = query.getResultList();
        HashSet<SocialLinkModel> results = new HashSet<SocialLinkModel>();
        for (SocialLinkRelationship relationship : plSocialLinks) {
            results.add(new SocialLinkModel(relationship.getSocialProvider(), relationship.getSocialUsername()));
        }
        return results;
    }

    public void addSocialLink(UserModel user, SocialLinkModel socialLink) {
        SocialLinkRelationship relationship = new SocialLinkRelationship();
        relationship.setUser(((UserAdapter)user).getUser());
        relationship.setSocialProvider(socialLink.getSocialProvider());
        relationship.setSocialUsername(socialLink.getSocialUsername());
        relationship.setRealm(this.realm.getName());
        this.getRelationshipManager().add((Relationship)relationship);
    }

    public void removeSocialLink(UserModel user, SocialLinkModel socialLink) {
        SocialLinkRelationship relationship = new SocialLinkRelationship();
        relationship.setUser(((UserAdapter)user).getUser());
        relationship.setSocialProvider(socialLink.getSocialProvider());
        relationship.setSocialUsername(socialLink.getSocialUsername());
        relationship.setRealm(this.realm.getName());
        this.getRelationshipManager().remove((Relationship)relationship);
    }

    public List<UserModel> getUsers() {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        IdentityQuery query = this.getIdm().createIdentityQuery(User.class);
        for (User u : query.getResultList()) {
            userModels.add(new UserAdapter(u, this.idm));
        }
        return userModels;
    }

    public List<UserModel> searchForUser(String search) {
        QueryParameter[] params = new QueryParameter[]{User.LOGIN_NAME, User.FIRST_NAME, User.LAST_NAME, User.EMAIL};
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (QueryParameter p : params) {
            IdentityQuery query = this.getIdm().createIdentityQuery(User.class);
            query.setParameter(p, new Object[]{search.toLowerCase()});
            for (User u : query.getResultList()) {
                userModels.add(new UserAdapter(u, this.idm));
            }
        }
        return userModels;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes) {
        IdentityQuery query = this.getIdm().createIdentityQuery(User.class);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equals("username")) {
                query.setParameter(User.LOGIN_NAME, new Object[]{entry.getValue()});
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                query.setParameter(User.FIRST_NAME, new Object[]{entry.getValue()});
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                query.setParameter(User.LAST_NAME, new Object[]{entry.getValue()});
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            query.setParameter(User.EMAIL, new Object[]{entry.getValue()});
        }
        List users = query.getResultList();
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (User user : users) {
            userModels.add(new UserAdapter(user, this.idm));
        }
        return userModels;
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.updateRealm();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.updateRealm();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.updateRealm();
    }
}

