/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.picketlink;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.UserModel;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.sample.User;

public class UserAdapter
implements UserModel {
    private static final String EMAIL_VERIFIED_ATTR = "emailVerified";
    private static final String KEYCLOAK_TOTP_ATTR = "totpEnabled";
    private static final String REQUIRED_ACTIONS_ATTR = "requiredActions";
    private static final String REDIRECT_URIS = "redirectUris";
    private static final String WEB_ORIGINS = "webOrigins";
    protected User user;
    protected IdentityManager idm;

    public UserAdapter(User user, IdentityManager idm) {
        this.user = user;
        this.idm = idm;
    }

    protected User getUser() {
        return this.user;
    }

    public String getLoginName() {
        return this.user.getLoginName();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
        this.idm.update((IdentityType)this.user);
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
        this.idm.update((IdentityType)this.user);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
        this.idm.update((IdentityType)this.user);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
        this.idm.update((IdentityType)this.user);
    }

    public boolean isEmailVerified() {
        Attribute a = this.user.getAttribute(EMAIL_VERIFIED_ATTR);
        return a != null ? (Boolean)a.getValue() : false;
    }

    public void setEmailVerified(boolean verified) {
        this.user.setAttribute(new Attribute(EMAIL_VERIFIED_ATTR, (Serializable)Boolean.valueOf(verified)));
        this.idm.update((IdentityType)this.user);
    }

    public void setAttribute(String name, String value) {
        this.user.setAttribute(new Attribute(name, (Serializable)((Object)value)));
        this.idm.update((IdentityType)this.user);
    }

    public void removeAttribute(String name) {
        this.user.removeAttribute(name);
        this.idm.update((IdentityType)this.user);
    }

    public String getAttribute(String name) {
        Attribute attribute = this.user.getAttribute(name);
        if (attribute == null || attribute.getValue() == null) {
            return null;
        }
        return ((String)((Object)attribute.getValue())).toString();
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Attribute attribute : this.user.getAttributes()) {
            if (attribute.getValue() == null) continue;
            attributes.put(attribute.getName(), attribute.getValue().toString());
        }
        return attributes;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        return this.getAttributeSet(REQUIRED_ACTIONS_ATTR);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.addToAttributeSet(REQUIRED_ACTIONS_ATTR, action);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.removeFromAttributeSet(REQUIRED_ACTIONS_ATTR, action);
    }

    public Set<String> getRedirectUris() {
        return this.getAttributeSet(REDIRECT_URIS);
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.setAttributeSet(REDIRECT_URIS, redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.addToAttributeSet(REDIRECT_URIS, redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.removeFromAttributeSet(REDIRECT_URIS, redirectUri);
    }

    public Set<String> getWebOrigins() {
        return this.getAttributeSet(WEB_ORIGINS);
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.setAttributeSet(WEB_ORIGINS, webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.addToAttributeSet(WEB_ORIGINS, webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.removeFromAttributeSet(WEB_ORIGINS, webOrigin);
    }

    public boolean isTotp() {
        Attribute a = this.user.getAttribute(KEYCLOAK_TOTP_ATTR);
        return a != null ? (Boolean)a.getValue() : false;
    }

    public void setTotp(boolean totp) {
        this.user.setAttribute(new Attribute(KEYCLOAK_TOTP_ATTR, (Serializable)Boolean.valueOf(totp)));
        this.idm.update((IdentityType)this.user);
    }

    private <T extends Serializable> Set<T> getAttributeSet(String name) {
        Attribute a = this.user.getAttribute(name);
        HashSet<Serializable> s = new HashSet<Serializable>();
        if (a != null) {
            Serializable o = a.getValue();
            if (o instanceof Serializable[]) {
                for (Serializable t : (Serializable[])o) {
                    s.add(t);
                }
            } else {
                s.add(o);
            }
        }
        return s;
    }

    private <T extends Serializable> void setAttributeSet(String name, Set<T> set) {
        if (set.isEmpty()) {
            this.user.removeAttribute(name);
        } else {
            this.user.setAttribute(new Attribute(name, (Serializable)set.toArray(new Serializable[set.size()])));
        }
        this.idm.update((IdentityType)this.user);
    }

    private <T extends Serializable> void addToAttributeSet(String name, T t) {
        Set<T> set = this.getAttributeSet(name);
        if (set == null) {
            set = new HashSet<T>();
        }
        if (set.add(t)) {
            this.setAttributeSet(name, set);
            this.idm.update((IdentityType)this.user);
        }
    }

    private <T extends Serializable> void removeFromAttributeSet(String name, T t) {
        Set<T> set = this.getAttributeSet(name);
        if (set == null) {
            return;
        }
        if (set.remove(t)) {
            this.setAttributeSet(name, set);
            this.idm.update((IdentityType)this.user);
        }
    }
}

