/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.mapreduce;

import java.io.Serializable;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientSessionMapper
implements Mapper<String, SessionEntity, String, Object>,
Serializable {
    private String realm;
    private EmitValue emit = EmitValue.ENTITY;
    private String client;
    private String userSession;
    private Long expiredRefresh;
    private Boolean requireNullUserSession = false;

    public ClientSessionMapper(String realm) {
        this.realm = realm;
    }

    public static ClientSessionMapper create(String realm) {
        return new ClientSessionMapper(realm);
    }

    public ClientSessionMapper emitKey() {
        this.emit = EmitValue.KEY;
        return this;
    }

    public ClientSessionMapper emitUserSessionAndTimestamp() {
        this.emit = EmitValue.USER_SESSION_AND_TIMESTAMP;
        return this;
    }

    public ClientSessionMapper client(String client) {
        this.client = client;
        return this;
    }

    public ClientSessionMapper userSession(String userSession) {
        this.userSession = userSession;
        return this;
    }

    public ClientSessionMapper expiredRefresh(long expiredRefresh) {
        this.expiredRefresh = expiredRefresh;
        return this;
    }

    public ClientSessionMapper requireNullUserSession(boolean requireNullUserSession) {
        this.requireNullUserSession = requireNullUserSession;
        return this;
    }

    public void map(String key, SessionEntity e, Collector collector) {
        if (!this.realm.equals(e.getRealm())) {
            return;
        }
        if (!(e instanceof ClientSessionEntity)) {
            return;
        }
        ClientSessionEntity entity = (ClientSessionEntity)e;
        if (this.client != null && !entity.getClient().equals(this.client)) {
            return;
        }
        if (this.userSession != null && !this.userSession.equals(entity.getUserSession())) {
            return;
        }
        if (this.requireNullUserSession.booleanValue() && entity.getUserSession() != null) {
            return;
        }
        if (this.expiredRefresh != null && (long)entity.getTimestamp() > this.expiredRefresh) {
            return;
        }
        switch (this.emit) {
            case KEY: {
                collector.emit((Object)key, (Object)key);
                break;
            }
            case ENTITY: {
                collector.emit((Object)key, (Object)entity);
                break;
            }
            case USER_SESSION_AND_TIMESTAMP: {
                if (entity.getUserSession() == null) break;
                collector.emit((Object)entity.getUserSession(), (Object)entity.getTimestamp());
            }
        }
    }

    private static enum EmitValue {
        KEY,
        ENTITY,
        USER_SESSION_AND_TIMESTAMP;

    }
}

