/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.mapreduce;

import java.io.Serializable;
import java.util.Map;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionNoteMapper
implements Mapper<String, SessionEntity, String, Object>,
Serializable {
    private String realm;
    private EmitValue emit = EmitValue.ENTITY;
    private Map<String, String> notes;

    public UserSessionNoteMapper(String realm) {
        this.realm = realm;
    }

    public static UserSessionNoteMapper create(String realm) {
        return new UserSessionNoteMapper(realm);
    }

    public UserSessionNoteMapper emitKey() {
        this.emit = EmitValue.KEY;
        return this;
    }

    public UserSessionNoteMapper notes(Map<String, String> notes) {
        this.notes = notes;
        return this;
    }

    public void map(String key, SessionEntity e, Collector collector) {
        if (!(e instanceof UserSessionEntity)) {
            return;
        }
        UserSessionEntity entity = (UserSessionEntity)e;
        if (!this.realm.equals(entity.getRealm())) {
            return;
        }
        for (Map.Entry<String, String> entry : this.notes.entrySet()) {
            String note = entity.getNotes().get(entry.getKey());
            if (note == null) {
                return;
            }
            if (note.equals(entry.getValue())) continue;
            return;
        }
        switch (this.emit) {
            case KEY: {
                collector.emit((Object)key, (Object)key);
                break;
            }
            case ENTITY: {
                collector.emit((Object)key, (Object)entity);
            }
        }
    }

    private static enum EmitValue {
        KEY,
        ENTITY;

    }
}

