/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.ClientInitialAccessAdapter;
import org.keycloak.models.sessions.infinispan.ClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.entities.ClientInitialAccessEntity;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.mapreduce.ClientInitialAccessMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.ClientSessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.FirstResultReducer;
import org.keycloak.models.sessions.infinispan.mapreduce.LargestResultReducer;
import org.keycloak.models.sessions.infinispan.mapreduce.SessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserLoginFailureMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserSessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserSessionNoteMapper;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;

public class InfinispanUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    private final KeycloakSession session;
    private final Cache<String, SessionEntity> sessionCache;
    private final Cache<String, SessionEntity> offlineSessionCache;
    private final Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache;
    private final InfinispanKeycloakTransaction tx;

    public InfinispanUserSessionProvider(KeycloakSession session, Cache<String, SessionEntity> sessionCache, Cache<String, SessionEntity> offlineSessionCache, Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache) {
        this.session = session;
        this.sessionCache = sessionCache;
        this.offlineSessionCache = offlineSessionCache;
        this.loginFailureCache = loginFailureCache;
        this.tx = new InfinispanKeycloakTransaction();
        session.getTransaction().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    protected Cache<String, SessionEntity> getCache(boolean offline) {
        return offline ? this.offlineSessionCache : this.sessionCache;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client) {
        String id = KeycloakModelUtils.generateId();
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setTimestamp(Time.currentTime());
        entity.setClient(client.getId());
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity, false);
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        String id = KeycloakModelUtils.generateId();
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity, false);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        return this.getClientSession(realm, id, false);
    }

    protected ClientSessionModel getClientSession(RealmModel realm, String id, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        ClientSessionEntity entity = (ClientSessionEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (ClientSessionEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity, offline);
    }

    public ClientSessionModel getClientSession(String id) {
        ClientSessionEntity entity = (ClientSessionEntity)this.sessionCache.get((Object)id);
        if (entity == null) {
            entity = (ClientSessionEntity)this.tx.get(this.sessionCache, id);
        }
        if (entity != null) {
            RealmModel realm = this.session.realms().getRealm(entity.getRealm());
            return this.wrap(realm, entity, false);
        }
        return null;
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    protected UserSessionAdapter getUserSession(RealmModel realm, String id, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        UserSessionEntity entity = (UserSessionEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (UserSessionEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity, offline);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values(), false);
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).brokerUserId(brokerUserId)).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values(), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).brokerSessionId(brokerSessionId)).reducedWith((Reducer)new FirstResultReducer()).execute();
        List<UserSessionModel> userSessionModels = this.wrapUserSessions(realm, sessions.values(), false);
        if (userSessionModels.isEmpty()) {
            return null;
        }
        return userSessionModels.get(0);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessions(realm, client, firstResult, maxResults, false);
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitUserSessionAndTimestamp()).reducedWith((Reducer)new LargestResultReducer()).execute();
        List sessionTimestamps = new LinkedList(map.entrySet());
        Collections.sort(sessionTimestamps, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> e1, Map.Entry<String, Integer> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        });
        if (firstResult != -1 || maxResults == -1) {
            if (firstResult == -1) {
                firstResult = 0;
            }
            if (maxResults == -1) {
                maxResults = Integer.MAX_VALUE;
            }
            if (firstResult > sessionTimestamps.size()) {
                return Collections.emptyList();
            }
            int toIndex = firstResult + maxResults < sessionTimestamps.size() ? firstResult + maxResults : sessionTimestamps.size();
            sessionTimestamps = sessionTimestamps.subList(firstResult, toIndex);
        }
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (Map.Entry entry : sessionTimestamps) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)cache.get(entry.getKey());
            if (userSessionEntity == null) continue;
            userSessions.add(this.wrap(realm, userSessionEntity, offline));
        }
        return userSessions;
    }

    public List<UserSessionModel> getUserSessionsByNote(RealmModel realm, String noteName, String noteValue) {
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put(noteName, noteValue);
        return this.getUserSessionsByNotes(realm, notes);
    }

    public List<UserSessionModel> getUserSessionsByNotes(RealmModel realm, Map<String, String> notes) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionNoteMapper.create(realm.getId()).notes(notes)).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values(), false);
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    protected int getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitUserSessionAndTimestamp()).reducedWith((Reducer)new LargestResultReducer()).execute();
        return map.size();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        this.removeUserSession(realm, session.getId());
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map sessions = new MapReduceTask(cache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : sessions.keySet()) {
            this.removeUserSession(realm, id, offline);
        }
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        int expired = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int expiredRefresh = Time.currentTime() - realm.getSsoSessionIdleTimeout();
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout();
        int expiredDettachedClientSession = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).expired(expired, expiredRefresh).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.removeUserSession(realm, id);
        }
        map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).expiredRefresh(expiredDettachedClientSession).requireNullUserSession(true).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
        Map map2 = new MapReduceTask(this.offlineSessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).expired(null, expiredOffline)).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (Map.Entry entry : map2.entrySet()) {
            String userSessionId = (String)entry.getKey();
            this.tx.remove(this.offlineSessionCache, userSessionId);
            persister.removeUserSession(userSessionId, true);
            UserSessionEntity entity = (UserSessionEntity)entry.getValue();
            for (String clientSessionId : entity.getClientSessions()) {
                this.tx.remove(this.offlineSessionCache, clientSessionId);
            }
        }
        map = new MapReduceTask(this.offlineSessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).expiredRefresh(expiredOffline).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String clientSessionId : map.keySet()) {
            this.tx.remove(this.offlineSessionCache, clientSessionId);
            persister.removeClientSession(clientSessionId, true);
        }
        map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientInitialAccessMapper.create(realm.getId()).expired(Time.currentTime()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
    }

    public void removeUserSessions(RealmModel realm) {
        this.removeUserSessions(realm, false);
    }

    protected void removeUserSessions(RealmModel realm, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map ids = new MapReduceTask(cache).mappedWith((Mapper)SessionMapper.create(realm.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : ids.keySet()) {
            cache.remove((Object)id);
        }
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        return this.wrap(key, (LoginFailureEntity)this.loginFailureCache.get((Object)key));
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        LoginFailureEntity entity = new LoginFailureEntity();
        entity.setRealm(realm.getId());
        entity.setUsername(username);
        this.tx.put(this.loginFailureCache, key, entity);
        return this.wrap(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        this.tx.remove(this.loginFailureCache, key);
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        Map sessions = new MapReduceTask(this.loginFailureCache).mappedWith((Mapper)UserLoginFailureMapper.create(realm.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (LoginFailureKey id : sessions.keySet()) {
            this.tx.remove(this.loginFailureCache, id);
        }
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm, true);
        this.removeUserSessions(realm, false);
        this.removeAllUserLoginFailures(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(realm, client, true);
        this.onClientRemoved(realm, client, false);
    }

    private void onClientRemoved(RealmModel realm, ClientModel client, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (Map.Entry entry : map.entrySet()) {
            ClientSessionAdapter adapter = this.wrap(realm, (ClientSessionEntity)entry.getValue(), offline);
            adapter.setUserSession(null);
            this.tx.remove(cache, entry.getKey());
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getUsername()));
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getEmail()));
    }

    public void close() {
    }

    void attachSession(UserSessionAdapter userSession, ClientSessionModel clientSession) {
        UserSessionEntity entity = userSession.getEntity();
        String clientSessionId = clientSession.getId();
        if (entity.getClientSessions() == null) {
            entity.setClientSessions(new HashSet<String>());
        }
        if (!entity.getClientSessions().contains(clientSessionId)) {
            entity.getClientSessions().add(clientSessionId);
            userSession.update();
        }
    }

    public void removeClientSession(RealmModel realm, ClientSessionModel clientSession) {
        this.removeClientSession(realm, clientSession, false);
    }

    protected void removeClientSession(RealmModel realm, ClientSessionModel clientSession, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession != null) {
            UserSessionEntity entity = ((UserSessionAdapter)userSession).getEntity();
            if (entity.getClientSessions() != null) {
                entity.getClientSessions().remove(clientSession.getId());
            }
            this.tx.replace(cache, entity.getId(), entity);
        }
        this.tx.remove(cache, clientSession.getId());
    }

    void dettachSession(UserSessionAdapter userSession, ClientSessionModel clientSession) {
        UserSessionEntity entity = userSession.getEntity();
        String clientSessionId = clientSession.getId();
        if (entity.getClientSessions() != null && entity.getClientSessions().contains(clientSessionId)) {
            entity.getClientSessions().remove(clientSessionId);
            if (entity.getClientSessions().isEmpty()) {
                entity.setClientSessions(null);
            }
            userSession.update();
        }
    }

    protected void removeUserSession(RealmModel realm, String userSessionId) {
        this.removeUserSession(realm, userSessionId, false);
    }

    protected void removeUserSession(RealmModel realm, String userSessionId, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.remove(cache, userSessionId);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).userSession(userSessionId).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(cache, id);
        }
    }

    InfinispanKeycloakTransaction getTx() {
        return this.tx;
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return entity != null ? new UserSessionAdapter(this.session, this, cache, realm, entity, offline) : null;
    }

    List<UserSessionModel> wrapUserSessions(RealmModel realm, Collection<UserSessionEntity> entities, boolean offline) {
        LinkedList<UserSessionModel> models = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : entities) {
            models.add(this.wrap(realm, e, offline));
        }
        return models;
    }

    List<ClientInitialAccessModel> wrapClientInitialAccess(RealmModel realm, Collection<ClientInitialAccessEntity> entities) {
        LinkedList<ClientInitialAccessModel> models = new LinkedList<ClientInitialAccessModel>();
        for (ClientInitialAccessEntity e : entities) {
            models.add(this.wrap(realm, e));
        }
        return models;
    }

    ClientSessionAdapter wrap(RealmModel realm, ClientSessionEntity entity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return entity != null ? new ClientSessionAdapter(this.session, this, cache, realm, entity, offline) : null;
    }

    ClientInitialAccessAdapter wrap(RealmModel realm, ClientInitialAccessEntity entity) {
        Cache<String, SessionEntity> cache = this.getCache(false);
        return entity != null ? new ClientInitialAccessAdapter(this.session, this, cache, realm, entity) : null;
    }

    UsernameLoginFailureModel wrap(LoginFailureKey key, LoginFailureEntity entity) {
        return entity != null ? new UsernameLoginFailureAdapter(this, this.loginFailureCache, key, entity) : null;
    }

    List<ClientSessionModel> wrapClientSessions(RealmModel realm, Collection<ClientSessionEntity> entities, boolean offline) {
        LinkedList<ClientSessionModel> models = new LinkedList<ClientSessionModel>();
        for (ClientSessionEntity e : entities) {
            models.add(this.wrap(realm, e, offline));
        }
        return models;
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter offlineUserSession = this.importUserSession(userSession, true);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.setLastSessionRefresh(currentTime);
        return offlineUserSession;
    }

    public UserSessionModel getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public void removeOfflineUserSession(RealmModel realm, String userSessionId) {
        this.removeUserSession(realm, userSessionId, true);
    }

    public ClientSessionModel createOfflineClientSession(ClientSessionModel clientSession) {
        ClientSessionAdapter offlineClientSession = this.importClientSession(clientSession, true);
        offlineClientSession.setTimestamp(Time.currentTime());
        return offlineClientSession;
    }

    public ClientSessionModel getOfflineClientSession(RealmModel realm, String clientSessionId) {
        return this.getClientSession(realm, clientSessionId, true);
    }

    public List<ClientSessionModel> getOfflineClientSessions(RealmModel realm, UserModel user) {
        Map sessions = new MapReduceTask(this.offlineSessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        LinkedList<ClientSessionEntity> clientSessions = new LinkedList<ClientSessionEntity>();
        for (UserSessionEntity userSession : sessions.values()) {
            Set<String> currClientSessions = userSession.getClientSessions();
            for (String clientSessionId : currClientSessions) {
                ClientSessionEntity cls = (ClientSessionEntity)this.offlineSessionCache.get((Object)clientSessionId);
                if (cls == null) continue;
                clientSessions.add(cls);
            }
        }
        return this.wrapClientSessions(realm, clientSessions, true);
    }

    public void removeOfflineClientSession(RealmModel realm, String clientSessionId) {
        ClientSessionModel clientSession = this.getOfflineClientSession(realm, clientSessionId);
        this.removeClientSession(realm, clientSession, true);
    }

    public int getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getUserSessions(realm, client, first, max, true);
    }

    public UserSessionAdapter importUserSession(UserSessionModel userSession, boolean offline) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(userSession.getId());
        entity.setRealm(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setLoginUsername(userSession.getLoginUsername());
        entity.setNotes(userSession.getNotes());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        entity.setUser(userSession.getUser().getId());
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.put(cache, userSession.getId(), entity);
        return this.wrap(userSession.getRealm(), entity, offline);
    }

    public ClientSessionAdapter importClientSession(ClientSessionModel clientSession, boolean offline) {
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(clientSession.getId());
        entity.setRealm(clientSession.getRealm().getId());
        entity.setAction(clientSession.getAction());
        entity.setAuthenticatorStatus(clientSession.getExecutionStatus());
        entity.setAuthMethod(clientSession.getAuthMethod());
        if (clientSession.getAuthenticatedUser() != null) {
            entity.setAuthUserId(clientSession.getAuthenticatedUser().getId());
        }
        entity.setClient(clientSession.getClient().getId());
        entity.setNotes(clientSession.getNotes());
        entity.setProtocolMappers(clientSession.getProtocolMappers());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setRoles(clientSession.getRoles());
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setUserSessionNotes(clientSession.getUserSessionNotes());
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.put(cache, clientSession.getId(), entity);
        return this.wrap(clientSession.getRealm(), entity, offline);
    }

    public ClientInitialAccessModel createClientInitialAccessModel(RealmModel realm, int expiration, int count) {
        String id = KeycloakModelUtils.generateId();
        ClientInitialAccessEntity entity = new ClientInitialAccessEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setTimestamp(Time.currentTime());
        entity.setExpiration(expiration);
        entity.setCount(count);
        entity.setRemainingCount(count);
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(RealmModel realm, String id) {
        Cache<String, SessionEntity> cache = this.getCache(false);
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (ClientInitialAccessEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity);
    }

    public void removeClientInitialAccessModel(RealmModel realm, String id) {
        this.tx.remove(this.getCache(false), id);
    }

    public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel realm) {
        Map entities = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientInitialAccessMapper.create(realm.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapClientInitialAccess(realm, entities.values());
    }

    public static enum CacheOperation {
        ADD,
        REMOVE,
        REPLACE;

    }

    class InfinispanKeycloakTransaction
    implements KeycloakTransaction {
        private boolean active;
        private boolean rollback;
        private Map<Object, CacheTask> tasks = new HashMap<Object, CacheTask>();

        InfinispanKeycloakTransaction() {
        }

        public void begin() {
            this.active = true;
        }

        public void commit() {
            if (this.rollback) {
                throw new RuntimeException("Rollback only!");
            }
            for (CacheTask task : this.tasks.values()) {
                task.execute();
            }
        }

        public void rollback() {
            this.tasks.clear();
        }

        public void setRollbackOnly() {
            this.rollback = true;
        }

        public boolean getRollbackOnly() {
            return this.rollback;
        }

        public boolean isActive() {
            return this.active;
        }

        public void put(Cache cache, Object key, Object value) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD, key);
            Object taskKey = this.getTaskKey(cache, key);
            if (this.tasks.containsKey(taskKey)) {
                throw new IllegalStateException("Can't add session: task in progress for session");
            }
            this.tasks.put(taskKey, new CacheTask(cache, CacheOperation.ADD, key, value));
        }

        public void replace(Cache cache, Object key, Object value) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REPLACE, key);
            Object taskKey = this.getTaskKey(cache, key);
            CacheTask current = this.tasks.get(taskKey);
            if (current != null) {
                switch (current.operation) {
                    case ADD: 
                    case REPLACE: {
                        current.value = value;
                        return;
                    }
                    case REMOVE: {
                        return;
                    }
                }
            } else {
                this.tasks.put(taskKey, new CacheTask(cache, CacheOperation.REPLACE, key, value));
            }
        }

        public void remove(Cache cache, Object key) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REMOVE, key);
            Object taskKey = this.getTaskKey(cache, key);
            this.tasks.put(taskKey, new CacheTask(cache, CacheOperation.REMOVE, key, null));
        }

        public Object get(Cache cache, Object key) {
            Object taskKey = this.getTaskKey(cache, key);
            CacheTask current = this.tasks.get(taskKey);
            if (current != null) {
                switch (current.operation) {
                    case ADD: 
                    case REPLACE: {
                        return current.value;
                    }
                }
            }
            return null;
        }

        private Object getTaskKey(Cache cache, Object key) {
            if (key instanceof String) {
                return cache.getName() + "::" + key.toString();
            }
            return key;
        }

        public class CacheTask {
            private Cache cache;
            private CacheOperation operation;
            private Object key;
            private Object value;

            public CacheTask(Cache cache, CacheOperation operation, Object key, Object value) {
                this.cache = cache;
                this.operation = operation;
                this.key = key;
                this.value = value;
            }

            public void execute() {
                log.tracev("Executing cache operation: {0} on {1}", (Object)this.operation, this.key);
                switch (this.operation) {
                    case ADD: {
                        this.cache.put(this.key, this.value);
                        break;
                    }
                    case REMOVE: {
                        this.cache.remove(this.key);
                        break;
                    }
                    case REPLACE: {
                        this.cache.replace(this.key, this.value);
                    }
                }
            }
        }
    }
}

