/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.compat;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.sessions.infinispan.compat.MemUserSessionProvider;
import org.keycloak.models.sessions.infinispan.compat.entities.ClientInitialAccessEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.UsernameLoginFailureEntity;
import org.keycloak.models.sessions.infinispan.compat.entities.UsernameLoginFailureKey;

public class MemUserSessionProviderFactory {
    private ConcurrentHashMap<String, UserSessionEntity> userSessions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientSessionEntity> clientSessions = new ConcurrentHashMap();
    private ConcurrentHashMap<UsernameLoginFailureKey, UsernameLoginFailureEntity> loginFailures = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> userSessionsByBrokerSessionId = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> userSessionsByBrokerUserId = new ConcurrentHashMap();
    private ConcurrentHashMap<String, UserSessionEntity> offlineUserSessions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientSessionEntity> offlineClientSessions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientInitialAccessEntity> clientInitialAccess = new ConcurrentHashMap();

    public UserSessionProvider create(KeycloakSession session) {
        return new MemUserSessionProvider(session, this.userSessions, this.userSessionsByBrokerSessionId, this.userSessionsByBrokerUserId, this.clientSessions, this.loginFailures, this.offlineUserSessions, this.offlineClientSessions, this.clientInitialAccess);
    }

    public void close() {
        this.userSessions.clear();
        this.loginFailures.clear();
        this.userSessionsByBrokerSessionId.clear();
        this.userSessionsByBrokerUserId.clear();
    }
}

