/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.jpa;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.jpa.UserSessionAdapter;
import org.keycloak.models.sessions.jpa.entities.ClientSessionEntity;
import org.keycloak.models.sessions.jpa.entities.ClientSessionRoleEntity;

public class ClientSessionAdapter
implements ClientSessionModel {
    private KeycloakSession session;
    private ClientSessionEntity entity;
    private EntityManager em;
    private RealmModel realm;

    public ClientSessionAdapter(KeycloakSession session, EntityManager em, RealmModel realm, ClientSessionEntity entity) {
        this.session = session;
        this.em = em;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public ClientModel getClient() {
        return this.realm.findClientById(this.entity.getClientId());
    }

    public String getState() {
        return this.entity.getState();
    }

    public UserSessionModel getUserSession() {
        return new UserSessionAdapter(this.session, this.em, this.realm, this.entity.getSession());
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
    }

    public ClientSessionModel.Action getAction() {
        return this.entity.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.entity.setAction(action);
    }

    public Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        if (this.entity.getRoles() != null) {
            for (ClientSessionRoleEntity e : this.entity.getRoles()) {
                roles.add(e.getRoleId());
            }
        }
        return roles;
    }
}

