/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.resteasy.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.util.JsonSerialization;

public class AbstractModelTest {
    private final Logger log = Logger.getLogger(this.getClass());
    protected KeycloakSessionFactory factory;
    protected KeycloakSession identitySession;
    protected RealmManager realmManager;

    @Before
    public void before() throws Exception {
        this.factory = KeycloakApplication.createSessionFactory();
        this.identitySession = this.factory.createSession();
        this.identitySession.getTransaction().begin();
        this.realmManager = new RealmManager(this.identitySession);
    }

    @After
    public void after() throws Exception {
        this.identitySession.getTransaction().commit();
        this.identitySession.close();
        this.factory.close();
    }

    protected void commit() {
        this.identitySession.getTransaction().commit();
        this.identitySession.close();
        this.identitySession = this.factory.createSession();
        this.identitySession.getTransaction().begin();
        this.realmManager = new RealmManager(this.identitySession);
    }

    public static RealmRepresentation loadJson(String path) throws IOException {
        int c;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((c = is.read()) != -1) {
            os.write(c);
        }
        byte[] bytes = os.toByteArray();
        System.out.println(new String(bytes));
        return (RealmRepresentation)JsonSerialization.readValue((byte[])bytes, RealmRepresentation.class);
    }
}

