/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.OAuthClientManager;
import org.keycloak.services.managers.RealmManager;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class AdapterTest
extends AbstractModelTest {
    private RealmModel realmModel;

    @Test
    public void installTest() throws Exception {
        new ApplianceBootstrap().bootstrap(this.identitySession);
    }

    @Test
    public void test1CreateRealm() throws Exception {
        this.realmModel = this.realmManager.createRealm("JUGGLER");
        this.realmModel.setAccessCodeLifespan(100);
        this.realmModel.setAccessCodeLifespanUserAction(600);
        this.realmModel.setEnabled(true);
        this.realmModel.setName("JUGGLER");
        this.realmModel.setPrivateKeyPem("0234234");
        this.realmModel.setPublicKeyPem("0234234");
        this.realmModel.setTokenLifespan(1000);
        this.realmModel.setUpdateProfileOnInitialSocialLogin(true);
        this.realmModel.addDefaultRole("foo");
        System.out.println(this.realmModel.getId());
        this.realmModel = this.realmManager.getRealm(this.realmModel.getId());
        Assert.assertNotNull((Object)this.realmModel);
        Assert.assertEquals((long)this.realmModel.getAccessCodeLifespan(), (long)100L);
        Assert.assertEquals((long)600L, (long)this.realmModel.getAccessCodeLifespanUserAction());
        Assert.assertEquals((long)this.realmModel.getTokenLifespan(), (long)1000L);
        Assert.assertEquals((Object)this.realmModel.isEnabled(), (Object)true);
        Assert.assertEquals((Object)this.realmModel.getName(), (Object)"JUGGLER");
        Assert.assertEquals((Object)this.realmModel.getPrivateKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.getPublicKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.isUpdateProfileOnInitialSocialLogin(), (Object)true);
        Assert.assertEquals((long)1L, (long)this.realmModel.getDefaultRoles().size());
        Assert.assertEquals((Object)"foo", this.realmModel.getDefaultRoles().get(0));
    }

    @Test
    public void testRealmListing() throws Exception {
        this.realmModel = this.realmManager.createRealm("JUGGLER");
        this.realmModel.setAccessCodeLifespan(100);
        this.realmModel.setAccessCodeLifespanUserAction(600);
        this.realmModel.setEnabled(true);
        this.realmModel.setName("JUGGLER");
        this.realmModel.setPrivateKeyPem("0234234");
        this.realmModel.setPublicKeyPem("0234234");
        this.realmModel.setTokenLifespan(1000);
        this.realmModel.setUpdateProfileOnInitialSocialLogin(true);
        this.realmModel.addDefaultRole("foo");
        System.out.println(this.realmModel.getId());
        this.realmModel = this.realmManager.getRealm(this.realmModel.getId());
        Assert.assertNotNull((Object)this.realmModel);
        Assert.assertEquals((long)this.realmModel.getAccessCodeLifespan(), (long)100L);
        Assert.assertEquals((long)600L, (long)this.realmModel.getAccessCodeLifespanUserAction());
        Assert.assertEquals((long)this.realmModel.getTokenLifespan(), (long)1000L);
        Assert.assertEquals((Object)this.realmModel.isEnabled(), (Object)true);
        Assert.assertEquals((Object)this.realmModel.getName(), (Object)"JUGGLER");
        Assert.assertEquals((Object)this.realmModel.getPrivateKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.getPublicKeyPem(), (Object)"0234234");
        Assert.assertEquals((Object)this.realmModel.isUpdateProfileOnInitialSocialLogin(), (Object)true);
        Assert.assertEquals((long)1L, (long)this.realmModel.getDefaultRoles().size());
        Assert.assertEquals((Object)"foo", this.realmModel.getDefaultRoles().get(0));
        String id = this.realmModel.getId();
        System.out.println("id: " + id);
        this.commit();
        List realms = this.identitySession.getRealms(null);
        System.out.println("num realms: " + realms.size());
        Assert.assertEquals((long)realms.size(), (long)1L);
    }

    @Test
    public void test2RequiredCredential() throws Exception {
        this.test1CreateRealm();
        this.realmModel.addRequiredCredential("password");
        List storedCreds = this.realmModel.getRequiredCredentials();
        Assert.assertEquals((long)1L, (long)storedCreds.size());
        HashSet<String> creds = new HashSet<String>();
        creds.add("password");
        creds.add("totp");
        this.realmModel.updateRequiredCredentials(creds);
        storedCreds = this.realmModel.getRequiredCredentials();
        Assert.assertEquals((long)2L, (long)storedCreds.size());
        boolean totp = false;
        boolean password = false;
        for (RequiredCredentialModel cred : storedCreds) {
            Assert.assertTrue((boolean)cred.isInput());
            if (cred.getType().equals("password")) {
                password = true;
                Assert.assertTrue((boolean)cred.isSecret());
                continue;
            }
            if (!cred.getType().equals("totp")) continue;
            totp = true;
            Assert.assertFalse((boolean)cred.isSecret());
        }
        Assert.assertTrue((boolean)totp);
        Assert.assertTrue((boolean)password);
    }

    @Test
    public void testCredentialValidation() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue("geheim");
        this.realmModel.updateCredential(user, cred);
        Assert.assertTrue((boolean)this.realmModel.validatePassword(user, "geheim"));
    }

    @Test
    public void testOAuthClient() throws Exception {
        this.test1CreateRealm();
        OAuthClientModel oauth = new OAuthClientManager(this.realmModel).create("oauth-client");
        oauth = this.realmModel.getOAuthClient("oauth-client");
        Assert.assertTrue((boolean)this.realmModel.hasRole(oauth.getOAuthAgent(), this.realmModel.getRole("KEYCLOAK__IDENTITY_REQUESTER")));
    }

    @Test
    public void testDeleteUser() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        user.setAttribute("attr1", "val1");
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        RoleModel testRole = this.realmModel.addRole("test");
        this.realmModel.grantRole(user, testRole);
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        SocialLinkModel socialLink = new SocialLinkModel("google", user.getLoginName());
        this.realmModel.addSocialLink(user, socialLink);
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue("password");
        this.realmModel.updateCredential(user, cred);
        Assert.assertTrue((boolean)this.realmModel.removeUser("bburke"));
        Assert.assertFalse((boolean)this.realmModel.removeUser("bburke"));
        Assert.assertNull((Object)this.realmModel.getUser("bburke"));
    }

    @Test
    public void testRemoveApplication() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        this.realmModel.addScopeMapping(client.getOAuthAgent(), appRole);
        RoleModel realmRole = this.realmModel.addRole("test");
        this.realmModel.addScopeMapping(app.getApplicationUser(), realmRole);
        Assert.assertTrue((boolean)this.realmModel.removeApplication(app.getId()));
        Assert.assertFalse((boolean)this.realmModel.removeApplication(app.getId()));
        Assert.assertNull((Object)this.realmModel.getApplicationById(app.getId()));
    }

    @Test
    public void testRemoveRealm() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        UserCredentialModel cred = new UserCredentialModel();
        cred.setType("password");
        cred.setValue("password");
        this.realmModel.updateCredential(user, cred);
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        this.realmModel.addScopeMapping(client.getOAuthAgent(), appRole);
        RoleModel realmRole = this.realmModel.addRole("test");
        this.realmModel.addScopeMapping(app.getApplicationUser(), realmRole);
        Assert.assertTrue((boolean)this.identitySession.removeRealm(this.realmModel.getId()));
        Assert.assertFalse((boolean)this.identitySession.removeRealm(this.realmModel.getId()));
        Assert.assertNull((Object)this.identitySession.getRealm(this.realmModel.getId()));
    }

    @Test
    public void testRemoveRole() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        OAuthClientModel client = this.realmModel.addOAuthClient("client");
        ApplicationModel app = this.realmModel.addApplication("test-app");
        RoleModel appRole = app.addRole("test");
        this.realmModel.grantRole(user, appRole);
        this.realmModel.addScopeMapping(client.getOAuthAgent(), appRole);
        RoleModel realmRole = this.realmModel.addRole("test");
        this.realmModel.addScopeMapping(app.getApplicationUser(), realmRole);
        Assert.assertTrue((boolean)this.realmModel.removeRoleById(realmRole.getId()));
        Assert.assertFalse((boolean)this.realmModel.removeRoleById(realmRole.getId()));
        Assert.assertNull((Object)this.realmModel.getRole(realmRole.getName()));
        Assert.assertTrue((boolean)app.removeRoleById(appRole.getId()));
        Assert.assertFalse((boolean)app.removeRoleById(appRole.getId()));
        Assert.assertNull((Object)app.getRole(appRole.getName()));
    }

    @Test
    public void testUserSearch() throws Exception {
        this.test1CreateRealm();
        UserModel user = this.realmModel.addUser("bburke");
        user.setLastName("Burke");
        user.setFirstName("Bill");
        user.setEmail("bburke@redhat.com");
        UserModel user2 = this.realmModel.addUser("doublefirst");
        user2.setFirstName("Knut Ole");
        user2.setLastName("Alver");
        user2.setEmail("knut@redhat.com");
        UserModel user3 = this.realmModel.addUser("doublelast");
        user3.setFirstName("Ole");
        user3.setLastName("Alver Veland");
        user3.setEmail("knut@redhat.com");
        RealmManager adapter = this.realmManager;
        List userModels = adapter.searchUsers("total junk query", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)0L);
        userModels = adapter.searchUsers("Bill Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        UserModel bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("bill burk", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        ArrayList<String> users = new ArrayList<String>();
        for (UserModel u : adapter.searchUsers("ole alver", this.realmModel)) {
            users.add(u.getLoginName());
        }
        Object[] usernames = users.toArray(new String[users.size()]);
        Arrays.sort(usernames);
        Assert.assertArrayEquals((Object[])new String[]{"doublefirst", "doublelast"}, (Object[])usernames);
        userModels = adapter.searchUsers("bburke@redhat.com", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("rke@redhat.com", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("bburke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("BurK", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        userModels = adapter.searchUsers("Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Bill");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"bburke@redhat.com");
        UserModel user4 = this.realmModel.addUser("mburke");
        user4.setLastName("Burke");
        user4.setFirstName("Monica");
        user4.setEmail("mburke@redhat.com");
        user4 = this.realmModel.addUser("thor");
        user4.setLastName("Thorgersen");
        user4.setFirstName("Stian");
        user4.setEmail("thor@redhat.com");
        userModels = adapter.searchUsers("Monica Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Monica");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"mburke@redhat.com");
        userModels = adapter.searchUsers("mburke@redhat.com", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Monica");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"mburke@redhat.com");
        userModels = adapter.searchUsers("mburke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)1L);
        bburke = (UserModel)userModels.get(0);
        Assert.assertEquals((Object)bburke.getFirstName(), (Object)"Monica");
        Assert.assertEquals((Object)bburke.getLastName(), (Object)"Burke");
        Assert.assertEquals((Object)bburke.getEmail(), (Object)"mburke@redhat.com");
        userModels = adapter.searchUsers("Burke", this.realmModel);
        Assert.assertEquals((long)userModels.size(), (long)2L);
        UserModel first = (UserModel)userModels.get(0);
        UserModel second = (UserModel)userModels.get(1);
        if (!first.getEmail().equals("bburke@redhat.com") && !second.getEmail().equals("bburke@redhat.com")) {
            Assert.fail();
        }
        if (!first.getEmail().equals("mburke@redhat.com") && !second.getEmail().equals("mburke@redhat.com")) {
            Assert.fail();
        }
        RealmModel otherRealm = adapter.createRealm("other");
        otherRealm.addUser("bburke");
        Assert.assertEquals((long)2L, (long)otherRealm.getUsers().size());
        Assert.assertEquals((long)1L, (long)otherRealm.searchForUser("bu").size());
    }

    @Test
    public void testRoles() throws Exception {
        this.test1CreateRealm();
        this.realmModel.addRole("admin");
        this.realmModel.addRole("user");
        Set roles = this.realmModel.getRoles();
        Assert.assertEquals((long)5L, (long)roles.size());
        UserModel user = this.realmModel.addUser("bburke");
        RoleModel role = this.realmModel.getRole("user");
        this.realmModel.grantRole(user, role);
        Assert.assertTrue((boolean)this.realmModel.hasRole(user, role));
        System.out.println("Role id: " + role.getId());
        role = this.realmModel.getRoleById(role.getId());
        Assert.assertNotNull((Object)role);
        Assert.assertEquals((Object)"user", (Object)role.getName());
    }
}

