/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;

public class CompositeRolesModelTest
extends AbstractModelTest {
    @Override
    @Before
    public void before() throws Exception {
        super.before();
        RealmManager manager = this.realmManager;
        RealmRepresentation rep = AbstractModelTest.loadJson("testcomposites.json");
        RealmModel realm = manager.createRealm("Test", rep.getRealm());
        manager.importRealm(rep, realm);
    }

    @Test
    public void testComposites() {
        Set<RoleModel> requestedRoles = this.getRequestedRoles("APP_COMPOSITE_APPLICATION", "APP_COMPOSITE_USER");
        Assert.assertEquals((long)2L, (long)requestedRoles.size());
        this.assertContains("APP_ROLE_APPLICATION", "APP_ROLE_1", requestedRoles);
        this.assertContains("realm", "REALM_ROLE_1", requestedRoles);
        requestedRoles = this.getRequestedRoles("APP_COMPOSITE_APPLICATION", "REALM_APP_COMPOSITE_USER");
        Assert.assertEquals((long)1L, (long)requestedRoles.size());
        this.assertContains("APP_ROLE_APPLICATION", "APP_ROLE_1", requestedRoles);
        requestedRoles = this.getRequestedRoles("REALM_COMPOSITE_1_APPLICATION", "REALM_COMPOSITE_1_USER");
        Assert.assertEquals((long)1L, (long)requestedRoles.size());
        this.assertContains("realm", "REALM_COMPOSITE_1", requestedRoles);
        requestedRoles = this.getRequestedRoles("REALM_ROLE_1_APPLICATION", "REALM_COMPOSITE_1_USER");
        Assert.assertEquals((long)1L, (long)requestedRoles.size());
        this.assertContains("realm", "REALM_ROLE_1", requestedRoles);
        requestedRoles = this.getRequestedRoles("REALM_COMPOSITE_1_APPLICATION", "REALM_ROLE_1_USER");
        Assert.assertEquals((long)1L, (long)requestedRoles.size());
        this.assertContains("realm", "REALM_ROLE_1", requestedRoles);
    }

    private Set<RoleModel> getRequestedRoles(String applicationName, String username) {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        RealmModel realm = this.realmManager.getRealm("Test");
        UserModel user = realm.getUser(username);
        ApplicationModel application = realm.getApplicationByName(applicationName);
        Set roleMappings = realm.getRoleMappings(user);
        Set scopeMappings = realm.getScopeMappings(application.getApplicationUser());
        Set appRoles = application.getRoles();
        if (appRoles != null) {
            scopeMappings.addAll(appRoles);
        }
        for (RoleModel role : roleMappings) {
            if (role.getContainer().equals(application)) {
                requestedRoles.add(role);
            }
            for (RoleModel desiredRole : scopeMappings) {
                HashSet<RoleModel> visited = new HashSet<RoleModel>();
                CompositeRolesModelTest.applyScope(role, desiredRole, visited, requestedRoles);
            }
        }
        return requestedRoles;
    }

    private static void applyScope(RoleModel role, RoleModel scope, Set<RoleModel> visited, Set<RoleModel> requested) {
        if (visited.contains(scope)) {
            return;
        }
        visited.add(scope);
        if (role.hasRole(scope)) {
            requested.add(scope);
            return;
        }
        if (!scope.isComposite()) {
            return;
        }
        for (RoleModel contained : scope.getComposites()) {
            CompositeRolesModelTest.applyScope(role, contained, visited, requested);
        }
    }

    private RoleModel getRole(String appName, String roleName) {
        RealmModel realm = this.realmManager.getRealm("Test");
        if ("realm".equals(appName)) {
            return realm.getRole(roleName);
        }
        return realm.getApplicationByName(appName).getRole(roleName);
    }

    private void assertContains(String appName, String roleName, Set<RoleModel> requestedRoles) {
        RoleModel expectedRole = this.getRole(appName, roleName);
        Assert.assertTrue((boolean)requestedRoles.contains(expectedRole));
        for (RoleModel role : requestedRoles) {
            if (!role.equals(expectedRole)) continue;
            Assert.assertEquals((Object)role.getContainer(), (Object)expectedRole.getContainer());
        }
    }
}

