/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.RealmManager;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ImportTest
extends AbstractModelTest {
    @Test
    public void install() throws Exception {
        RealmManager manager = this.realmManager;
        RealmRepresentation rep = AbstractModelTest.loadJson("testrealm.json");
        RealmModel realm = manager.createRealm("demo", rep.getRealm());
        manager.importRealm(rep, realm);
        Assert.assertTrue((boolean)realm.isVerifyEmail());
        Assert.assertFalse((boolean)realm.isUpdateProfileOnInitialSocialLogin());
        List creds = realm.getRequiredCredentials();
        Assert.assertEquals((long)1L, (long)creds.size());
        RequiredCredentialModel cred = (RequiredCredentialModel)creds.get(0);
        Assert.assertEquals((Object)"password", (Object)cred.getFormLabel());
        Assert.assertEquals((long)2L, (long)realm.getDefaultRoles().size());
        Assert.assertNotNull((Object)realm.getRole("foo"));
        Assert.assertNotNull((Object)realm.getRole("bar"));
        UserModel user = realm.getUser("loginclient");
        Assert.assertNotNull((Object)user);
        Set scopes = realm.getRealmScopeMappings(user);
        Assert.assertEquals((long)0L, (long)scopes.size());
        Assert.assertEquals((long)0L, (long)realm.getSocialLinks(user).size());
        List resources = realm.getApplications();
        Assert.assertEquals((long)3L, (long)resources.size());
        ApplicationModel application = realm.getApplicationByName("Application");
        ApplicationModel otherApp = realm.getApplicationByName("OtherApp");
        ApplicationModel accountApp = realm.getApplicationByName("account");
        ApplicationModel nonExisting = realm.getApplicationByName("NonExisting");
        Assert.assertNotNull((Object)application);
        Assert.assertNotNull((Object)otherApp);
        Assert.assertNull((Object)nonExisting);
        Map apps = realm.getApplicationNameMap();
        Assert.assertEquals((long)3L, (long)apps.size());
        Assert.assertTrue((boolean)apps.values().contains(application));
        Assert.assertTrue((boolean)apps.values().contains(otherApp));
        Assert.assertTrue((boolean)apps.values().contains(accountApp));
        realm.getApplications().containsAll(apps.values());
        Assert.assertNull((Object)realm.getApplicationById("982734"));
        Assert.assertEquals((Object)application, (Object)realm.getApplicationById(application.getId()));
        UserModel admin = realm.getUser("admin");
        Set allRoles = realm.getRoleMappings(admin);
        Assert.assertEquals((long)5L, (long)allRoles.size());
        Assert.assertTrue((boolean)allRoles.contains(realm.getRole("admin")));
        Assert.assertTrue((boolean)allRoles.contains(application.getRole("app-admin")));
        Assert.assertTrue((boolean)allRoles.contains(otherApp.getRole("otherapp-admin")));
        Assert.assertTrue((boolean)allRoles.contains(accountApp.getRole("view-profile")));
        Assert.assertTrue((boolean)allRoles.contains(accountApp.getRole("manage-account")));
        UserModel wburke = realm.getUser("wburke");
        allRoles = realm.getRoleMappings(wburke);
        Assert.assertEquals((long)4L, (long)allRoles.size());
        Assert.assertFalse((boolean)allRoles.contains(realm.getRole("admin")));
        Assert.assertTrue((boolean)allRoles.contains(application.getRole("app-user")));
        Assert.assertTrue((boolean)allRoles.contains(otherApp.getRole("otherapp-user")));
        Assert.assertEquals((long)0L, (long)realm.getRealmRoleMappings(wburke).size());
        Set realmRoles = realm.getRealmRoleMappings(admin);
        Assert.assertEquals((long)1L, (long)realmRoles.size());
        Assert.assertEquals((Object)"admin", (Object)((RoleModel)realmRoles.iterator().next()).getName());
        Set appRoles = application.getApplicationRoleMappings(admin);
        Assert.assertEquals((long)1L, (long)appRoles.size());
        Assert.assertEquals((Object)"app-admin", (Object)((RoleModel)appRoles.iterator().next()).getName());
        UserModel oauthClient = realm.getUser("oauthclient");
        Assert.assertNotNull((Object)oauthClient);
        Set allScopes = realm.getScopeMappings(oauthClient);
        Assert.assertEquals((long)2L, (long)allScopes.size());
        Assert.assertTrue((boolean)allScopes.contains(realm.getRole("admin")));
        Assert.assertTrue((boolean)allScopes.contains(application.getRole("app-user")));
        Set realmScopes = realm.getRealmScopeMappings(oauthClient);
        Assert.assertTrue((boolean)realmScopes.contains(realm.getRole("admin")));
        Set appScopes = application.getApplicationScopeMappings(oauthClient);
        Assert.assertTrue((boolean)appScopes.contains(application.getRole("app-user")));
        UserModel socialUser = realm.getUser("mySocialUser");
        Set socialLinks = realm.getSocialLinks(socialUser);
        Assert.assertEquals((long)3L, (long)socialLinks.size());
        int facebookCount = 0;
        int googleCount = 0;
        for (SocialLinkModel socialLinkModel : socialLinks) {
            if ("facebook".equals(socialLinkModel.getSocialProvider())) {
                ++facebookCount;
                continue;
            }
            if (!"google".equals(socialLinkModel.getSocialProvider())) continue;
            ++googleCount;
            Assert.assertEquals((Object)socialLinkModel.getSocialUsername(), (Object)"mySocialUser@gmail.com");
        }
        Assert.assertEquals((long)2L, (long)facebookCount);
        Assert.assertEquals((long)1L, (long)googleCount);
        UserModel foundSocialUser = realm.getUserBySocialLink(new SocialLinkModel("facebook", "fbuser1"));
        Assert.assertEquals((Object)foundSocialUser.getLoginName(), (Object)socialUser.getLoginName());
        Assert.assertNull((Object)realm.getUserBySocialLink(new SocialLinkModel("facebook", "not-existing")));
    }

    @Test
    public void install2() throws Exception {
        RealmManager manager = this.realmManager;
        RealmRepresentation rep = AbstractModelTest.loadJson("testrealm-demo.json");
        RealmModel realm = manager.createRealm("demo", rep.getRealm());
        manager.importRealm(rep, realm);
        Assert.assertFalse((boolean)realm.isUpdateProfileOnInitialSocialLogin());
        Assert.assertEquals((long)600L, (long)realm.getAccessCodeLifespanUserAction());
        this.verifyRequiredCredentials(realm.getRequiredCredentials(), "password");
        this.verifyRequiredCredentials(realm.getRequiredApplicationCredentials(), "secret");
        this.verifyRequiredCredentials(realm.getRequiredOAuthClientCredentials(), "secret");
    }

    private void verifyRequiredCredentials(List<RequiredCredentialModel> requiredCreds, String expectedType) {
        Assert.assertEquals((long)1L, (long)requiredCreds.size());
        Assert.assertEquals((Object)expectedType, (Object)requiredCreds.get(0).getType());
    }
}

