/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;

public class ModelTest
extends AbstractModelTest {
    @Test
    public void importExportRealm() {
        RealmModel realm = this.realmManager.createRealm("original");
        realm.setRegistrationAllowed(true);
        realm.setResetPasswordAllowed(true);
        realm.setSocial(true);
        realm.setSslNotRequired(true);
        realm.setVerifyEmail(true);
        realm.setTokenLifespan(1000);
        realm.setPasswordPolicy(new PasswordPolicy("length"));
        realm.setAccessCodeLifespan(1001);
        realm.setAccessCodeLifespanUserAction(1002);
        realm.setPublicKeyPem("0234234");
        realm.setPrivateKeyPem("1234234");
        realm.addDefaultRole("default-role");
        HashMap<String, String> smtp = new HashMap<String, String>();
        smtp.put("from", "auto@keycloak");
        smtp.put("hostname", "localhost");
        realm.setSmtpConfig(smtp);
        HashMap<String, String> social = new HashMap<String, String>();
        social.put("google.key", "1234");
        social.put("google.secret", "5678");
        realm.setSocialConfig(social);
        RealmModel persisted = this.realmManager.getRealm(realm.getId());
        ModelTest.assertEquals(realm, persisted);
        RealmModel copy = this.importExport(realm, "copy");
        ModelTest.assertEquals(realm, copy);
    }

    public static void assertEquals(RealmModel expected, RealmModel actual) {
        Assert.assertEquals((Object)expected.isUpdateProfileOnInitialSocialLogin(), (Object)actual.isUpdateProfileOnInitialSocialLogin());
        Assert.assertEquals((Object)expected.isRegistrationAllowed(), (Object)actual.isRegistrationAllowed());
        Assert.assertEquals((Object)expected.isResetPasswordAllowed(), (Object)actual.isResetPasswordAllowed());
        Assert.assertEquals((Object)expected.isSocial(), (Object)actual.isSocial());
        Assert.assertEquals((Object)expected.isSslNotRequired(), (Object)actual.isSslNotRequired());
        Assert.assertEquals((Object)expected.isVerifyEmail(), (Object)actual.isVerifyEmail());
        Assert.assertEquals((long)expected.getTokenLifespan(), (long)actual.getTokenLifespan());
        Assert.assertEquals((long)expected.getAccessCodeLifespan(), (long)actual.getAccessCodeLifespan());
        Assert.assertEquals((long)expected.getAccessCodeLifespanUserAction(), (long)actual.getAccessCodeLifespanUserAction());
        Assert.assertEquals((Object)expected.getPublicKeyPem(), (Object)actual.getPublicKeyPem());
        Assert.assertEquals((Object)expected.getPrivateKeyPem(), (Object)actual.getPrivateKeyPem());
        Assert.assertEquals((Object)expected.getDefaultRoles(), (Object)actual.getDefaultRoles());
        Assert.assertEquals((Object)expected.getSmtpConfig(), (Object)actual.getSmtpConfig());
        Assert.assertEquals((Object)expected.getSocialConfig(), (Object)actual.getSocialConfig());
    }

    public static void assertEquals(List<RoleModel> expected, List<RoleModel> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<RoleModel> exp = expected.iterator();
        Iterator<RoleModel> act = actual.iterator();
        while (exp.hasNext()) {
            Assert.assertEquals((Object)exp.next().getName(), (Object)act.next().getName());
        }
    }

    private RealmModel importExport(RealmModel src, String copyName) {
        RealmRepresentation representation = ModelToRepresentation.toRepresentation((RealmModel)src);
        RealmModel copy = this.realmManager.createRealm(copyName);
        this.realmManager.importRealm(representation, copy);
        return this.realmManager.getRealm(copy.getId());
    }
}

