/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.model.test;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.model.test.AbstractModelTest;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class UserModelTest
extends AbstractModelTest {
    @Test
    public void persistUser() {
        RealmModel realm = this.realmManager.createRealm("original");
        UserModel user = realm.addUser("user");
        user.setFirstName("first-name");
        user.setLastName("last-name");
        user.setEmail("email");
        user.addRedirectUri("redirect-1");
        user.addRedirectUri("redirect-2");
        user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
        user.addWebOrigin("origin-1");
        user.addWebOrigin("origin-2");
        UserModel persisted = this.realmManager.getRealm(realm.getId()).getUser("user");
        UserModelTest.assertEquals(user, persisted);
    }

    @Test
    public void webOriginSetTest() {
        RealmModel realm = this.realmManager.createRealm("original");
        UserModel user = realm.addUser("user");
        Assert.assertTrue((boolean)user.getWebOrigins().isEmpty());
        user.addWebOrigin("origin-1");
        Assert.assertEquals((long)1L, (long)user.getWebOrigins().size());
        user.addWebOrigin("origin-2");
        Assert.assertEquals((long)2L, (long)user.getWebOrigins().size());
        user.removeWebOrigin("origin-2");
        Assert.assertEquals((long)1L, (long)user.getWebOrigins().size());
        user.removeWebOrigin("origin-1");
        Assert.assertTrue((boolean)user.getWebOrigins().isEmpty());
    }

    @Test
    public void testUserRequiredActions() throws Exception {
        RealmModel realm = this.realmManager.createRealm("original");
        UserModel user = realm.addUser("user");
        Assert.assertTrue((boolean)user.getRequiredActions().isEmpty());
        user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        String id = realm.getId();
        this.commit();
        realm = this.realmManager.getRealm(id);
        user = realm.getUser("user");
        Assert.assertEquals((long)1L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP));
        user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        user = realm.getUser("user");
        Assert.assertEquals((long)1L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP));
        user.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        user = realm.getUser("user");
        Assert.assertEquals((long)2L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.CONFIGURE_TOTP));
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.VERIFY_EMAIL));
        user.removeRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
        user = realm.getUser("user");
        Assert.assertEquals((long)1L, (long)user.getRequiredActions().size());
        Assert.assertTrue((boolean)user.getRequiredActions().contains(UserModel.RequiredAction.VERIFY_EMAIL));
        user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
        user = realm.getUser("user");
        Assert.assertTrue((boolean)user.getRequiredActions().isEmpty());
    }

    public static void assertEquals(UserModel expected, UserModel actual) {
        Assert.assertEquals((Object)expected.getLoginName(), (Object)actual.getLoginName());
        Assert.assertEquals((Object)expected.getFirstName(), (Object)actual.getFirstName());
        Assert.assertEquals((Object)expected.getLastName(), (Object)actual.getLastName());
        Assert.assertArrayEquals((Object[])expected.getRedirectUris().toArray(), (Object[])actual.getRedirectUris().toArray());
        Assert.assertArrayEquals((Object[])expected.getRequiredActions().toArray(), (Object[])actual.getRequiredActions().toArray());
        Assert.assertArrayEquals((Object[])expected.getWebOrigins().toArray(), (Object[])actual.getWebOrigins().toArray());
    }

    public static void assertEquals(List<RoleModel> expected, List<RoleModel> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<RoleModel> exp = expected.iterator();
        Iterator<RoleModel> act = actual.iterator();
        while (exp.hasNext()) {
            Assert.assertEquals((Object)exp.next().getName(), (Object)act.next().getName());
        }
    }
}

